/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4732;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public abstract class DoubleBlockModel
extends class_3879 {
    private final Map<class_4732.class_4733, List<class_630>> parts;
    protected final int textureWidth;
    protected final int textureHeight;

    public DoubleBlockModel(int textureWidth, int textureHeight) {
        this(class_1921::method_23576, textureWidth, textureHeight);
    }

    public DoubleBlockModel(Function<class_2960, class_1921> layerFactory, int textureWidth, int textureHeight) {
        super(layerFactory);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.parts = new HashMap<class_4732.class_4733, List<class_630>>();
    }

    protected class_630 createCuboid(int textureOffsetU, int textureOffsetV, float x, float y, float z, float xSize, float ySize, float zSize) {
        class_630.class_628 cuboid = new class_630.class_628(textureOffsetU, textureOffsetV, 0.0f, 0.0f, 0.0f, xSize, ySize, zSize, 0.0f, 0.0f, 0.0f, true, (float)this.textureWidth, (float)this.textureHeight);
        class_630 part = new class_630(List.of(cuboid), Map.of());
        part.method_2851(x, y, z);
        return part;
    }

    protected class_630 createCuboid(int textureOffsetU, int textureOffsetV, float x, float y, float z, float xSize, float ySize, float zSize, class_630 template) {
        class_630 part = this.createCuboid(textureOffsetU, textureOffsetV, x, y, z, xSize, ySize, zSize);
        part.method_17138(template);
        part.method_2851(x, y, z);
        return part;
    }

    protected class_630 addCuboid(class_4732.class_4733 type, int textureOffsetU, int textureOffsetV, float x, float y, float z, float xSize, float ySize, float zSize) {
        class_630 part = this.createCuboid(textureOffsetU, textureOffsetV, x, y, z, xSize, ySize, zSize);
        if (!this.parts.containsKey(type)) {
            this.parts.put(type, new ArrayList());
        }
        this.parts.get(type).add(part);
        return part;
    }

    protected class_630 addCuboid(class_4732.class_4733 type, int textureOffsetU, int textureOffsetV, float x, float y, float z, float xSize, float ySize, float zSize, class_630 template) {
        class_630 part = this.addCuboid(type, textureOffsetU, textureOffsetV, x, y, z, xSize, ySize, zSize);
        part.method_17138(template);
        part.method_2851(x, y, z);
        return part;
    }

    protected class_630 createTemplate() {
        return new class_630(List.of(), Map.of());
    }

    protected class_630 createRotationTemplate(float pitch, float yaw, float roll) {
        class_630 template = this.createTemplate();
        template.field_3654 = pitch;
        template.field_3675 = yaw;
        template.field_3674 = roll;
        return template;
    }

    public void render(class_4587 matrices, class_4588 vertices, int light, int overlay) {
        this.method_2828(matrices, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        matrices.method_22903();
        this.render(class_4732.class_4733.field_21784, matrices, vertices, light, overlay, red, green, blue, alpha);
        this.translate(matrices);
        this.render(class_4732.class_4733.field_21785, matrices, vertices, light, overlay, red, green, blue, alpha);
        matrices.method_22909();
    }

    public void render(class_4732.class_4733 type, class_4587 matrices, class_4588 vertices, int light, int overlay) {
        this.render(type, matrices, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(class_4732.class_4733 type, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        List<class_630> currentParts = this.parts.get(type);
        if (currentParts == null) {
            return;
        }
        for (class_630 part : currentParts) {
            part.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    protected abstract void translate(class_4587 var1);
}

