/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFPlant
extends BlockFlower
implements IShearable {
    boolean[] isGrassColor = new boolean[]{false, false, false, false, true, true, false, false, true, false, true, false, false, false, false, false};
    int[] field_71984_q = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 8, 0, 0};
    private Icon[] icons;
    private String[] iconNames = new String[]{null, null, null, "mosspatch", "mayapple", "cloverpatch", null, null, "fiddlehead", "mushgloom", null, null, null, "torchberry", "rootstrand", null};
    public static Icon mayappleSide;
    public static final int META_MOSSPATCH = 3;
    public static final int META_MAYAPPLE = 4;
    public static final int META_CLOVERPATCH = 5;
    public static final int META_FIDDLEHEAD = 8;
    public static final int META_MUSHGLOOM = 9;
    public static final int META_FORESTGRASS = 10;
    public static final int META_DEADBUSH = 11;
    public static final int META_TORCHBERRY = 13;
    public static final int META_ROOT_STRAND = 14;

    protected BlockTFPlant(int par1) {
        super(par1, Material.field_76254_j);
        this.func_71907_b(true);
        float var3 = 0.4f;
        this.func_71905_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 0.8f, 0.5f + var3);
        this.func_71848_c(0.0f);
        this.func_71884_a(Block.field_71965_g);
        this.func_71849_a(TFItems.creativeTab);
    }

    public Icon func_71858_a(int side, int metadata) {
        return this.icons[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.icons = new Icon[this.iconNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.iconNames[i] == null) continue;
            this.icons[i] = par1IconRegister.func_94245_a("TwilightForest:" + this.iconNames[i]);
        }
        this.icons[10] = Block.field_71962_X.func_71858_a(2, 1);
        this.icons[11] = Block.field_71961_Y.func_71851_a(2);
        mayappleSide = par1IconRegister.func_94245_a("TwilightForest:mayapple_side");
    }

    public int func_71933_m() {
        double var1 = 0.5;
        double var3 = 1.0;
        return ColorizerGrass.func_77480_a((double)var1, (double)var3);
    }

    public void func_71861_g(World world, int i, int j, int k) {
        super.func_71861_g(world, i, j, k);
        world.func_72836_a(i, j, k, this.field_71990_ca, world.field_73012_v.nextInt(50) + 20);
    }

    public boolean func_94331_a(World par1World, int par2, int par3, int par4, int par5, ItemStack par6ItemStack) {
        int blockAt = par1World.func_72798_a(par2, par3, par4);
        return (blockAt == 0 || BlockTFPlant.field_71973_m[blockAt].field_72018_cp.func_76222_j()) && this.canBlockStay(par1World, par2, par3, par4, par6ItemStack.func_77960_j());
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.canBlockStay(world, x, y, z, meta);
    }

    public boolean canBlockStay(World world, int x, int y, int z, int meta) {
        Block soil = field_71973_m[world.func_72798_a(x, y - 1, z)];
        switch (meta) {
            case 13: 
            case 14: {
                return BlockTFPlant.canPlaceRootBelow(world, x, y + 1, z);
            }
            case 0: 
            case 10: 
            case 11: {
                return soil != null && soil.canSustainPlant(world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
            case 3: 
            case 9: {
                return soil != null && soil.isBlockSolidOnSide(world, x, y, z, ForgeDirection.UP);
            }
        }
        return (world.func_72883_k(x, y, z) >= 3 || world.func_72937_j(x, y, z)) && soil != null && soil.canSustainPlant(world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_71902_a(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        int meta = par1IBlockAccess.func_72805_g(x, y, z);
        if (meta == 3) {
            long seed = (long)(x * 3129871) ^ (long)y * 116129781L ^ (long)z;
            seed = seed * seed * 42317861L + seed * 11L;
            int xOff0 = (int)(seed >> 12 & 3L);
            int xOff1 = (int)(seed >> 15 & 3L);
            int zOff0 = (int)(seed >> 18 & 3L);
            int zOff1 = (int)(seed >> 21 & 3L);
            int yOff0 = (int)(seed >> 24 & 1L);
            int yOff1 = (int)(seed >> 27 & 1L);
            boolean xConnect0 = par1IBlockAccess.func_72798_a(x + 1, y, z) == this.field_71990_ca && par1IBlockAccess.func_72805_g(x + 1, y, z) == 3;
            boolean xConnect1 = par1IBlockAccess.func_72798_a(x - 1, y, z) == this.field_71990_ca && par1IBlockAccess.func_72805_g(x - 1, y, z) == 3;
            boolean zConnect0 = par1IBlockAccess.func_72798_a(x, y, z + 1) == this.field_71990_ca && par1IBlockAccess.func_72805_g(x, y, z + 1) == 3;
            boolean zConnect1 = par1IBlockAccess.func_72798_a(x, y, z - 1) == this.field_71990_ca && par1IBlockAccess.func_72805_g(x, y, z - 1) == 3;
            this.func_71905_a(xConnect1 ? 0.0f : (1.0f + (float)xOff1) / 16.0f, 0.0f, zConnect1 ? 0.0f : (1.0f + (float)zOff1) / 16.0f, xConnect0 ? 1.0f : (15.0f - (float)xOff0) / 16.0f, 0.0625f, zConnect0 ? 1.0f : (15.0f - (float)zOff0) / 16.0f);
        } else if (meta == 5) {
            long seed = (long)(x * 3129871) ^ (long)y * 116129781L ^ (long)z;
            seed = seed * seed * 42317861L + seed * 11L;
            int xOff0 = (int)(seed >> 12 & 3L);
            int xOff1 = (int)(seed >> 15 & 3L);
            int zOff0 = (int)(seed >> 18 & 3L);
            int zOff1 = (int)(seed >> 21 & 3L);
            int yOff0 = (int)(seed >> 24 & 1L);
            int yOff1 = (int)(seed >> 27 & 1L);
            boolean xConnect0 = par1IBlockAccess.func_72798_a(x + 1, y, z) == this.field_71990_ca && par1IBlockAccess.func_72805_g(x + 1, y, z) == 5;
            boolean xConnect1 = par1IBlockAccess.func_72798_a(x - 1, y, z) == this.field_71990_ca && par1IBlockAccess.func_72805_g(x - 1, y, z) == 5;
            boolean zConnect0 = par1IBlockAccess.func_72798_a(x, y, z + 1) == this.field_71990_ca && par1IBlockAccess.func_72805_g(x, y, z + 1) == 5;
            boolean zConnect1 = par1IBlockAccess.func_72798_a(x, y, z - 1) == this.field_71990_ca && par1IBlockAccess.func_72805_g(x, y, z - 1) == 5;
            this.func_71905_a(xConnect1 ? 0.0f : (1.0f + (float)xOff1) / 16.0f, 0.0f, zConnect1 ? 0.0f : (1.0f + (float)zOff1) / 16.0f, xConnect0 ? 1.0f : (15.0f - (float)xOff0) / 16.0f, (1.0f + (float)yOff0 + (float)yOff1) / 16.0f, zConnect0 ? 1.0f : (15.0f - (float)zOff0) / 16.0f);
        } else if (meta == 4) {
            this.func_71905_a(0.25f, 0.0f, 0.25f, 0.8125f, 0.375f, 0.8125f);
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public int func_71889_f_(int par1) {
        return this.isGrassColor[par1] ? ColorizerFoliage.func_77468_c() : 0xFFFFFF;
    }

    public int func_71920_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int meta = par1IBlockAccess.func_72805_g(par2, par3, par4);
        return this.isGrassColor[meta] ? par1IBlockAccess.func_72807_a(par2, par4).func_76737_k() : 0xFFFFFF;
    }

    public AxisAlignedBB func_71872_e(World par1World, int x, int y, int z) {
        int meta = par1World.func_72805_g(x, y, z);
        return null;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return TwilightForestMod.proxy.getPlantBlockRenderID();
    }

    public void func_71847_b(World par1World, int x, int y, int z, Random par5Random) {
        int meta = par1World.func_72805_g(x, y, z);
        if (par1World.func_72957_l(x, y, z) < this.field_71984_q[meta]) {
            par1World.func_72936_c(EnumSkyBlock.Block, x, y, z);
            par1World.func_72845_h(x, y, z);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.field_71984_q[meta];
    }

    public static boolean canPlaceRootBelow(World world, int x, int y, int z) {
        int blockID = world.func_72798_a(x, y, z);
        if (Block.field_71973_m[blockID] != null && (Block.field_71973_m[blockID].field_72018_cp == Material.field_76248_c || Block.field_71973_m[blockID].field_72018_cp == Material.field_76247_b)) {
            return true;
        }
        int blockMeta = world.func_72805_g(x, y, z);
        return blockID == TFBlocks.plant.field_71990_ca && blockMeta == 14 || blockID == TFBlocks.root.field_71990_ca && blockMeta == 0;
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        switch (meta) {
            case 13: {
                ret.add(new ItemStack(TFItems.torchberries));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            default: {
                ret.add(new ItemStack((Block)this, 1, meta));
            }
        }
        return ret;
    }

    public int func_71899_b(int par1) {
        return par1;
    }

    public boolean isShearable(ItemStack item, World world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        world.func_94571_i(x, y, z);
        return ret;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Block)this, 1, 3));
        par3List.add(new ItemStack((Block)this, 1, 4));
        par3List.add(new ItemStack((Block)this, 1, 8));
        par3List.add(new ItemStack((Block)this, 1, 9));
        par3List.add(new ItemStack((Block)this, 1, 10));
        par3List.add(new ItemStack((Block)this, 1, 11));
        par3List.add(new ItemStack((Block)this, 1, 13));
        par3List.add(new ItemStack((Block)this, 1, 14));
    }

    public void func_71919_f() {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 3: 
            case 9: {
                return EnumPlantType.Cave;
            }
        }
        return EnumPlantType.Plains;
    }

    public int getPlantID(World world, int x, int y, int z) {
        return this.field_71990_ca;
    }

    public int getPlantMetadata(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World par1World, int x, int y, int z, Random par5Random) {
        super.func_71862_a(par1World, x, y, z, par5Random);
        int meta = par1World.func_72805_g(x, y, z);
        if (meta == 3 && par5Random.nextInt(10) == 0) {
            par1World.func_72869_a("townaura", (double)((float)x + par5Random.nextFloat()), (double)((float)y + 0.1f), (double)((float)z + par5Random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }
}

