/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;
import twilightforest.world.TFGenerator;

public class ItemTFOreMagnet
extends ItemTF {
    private static final float WIGGLE = 10.0f;
    private Icon[] icons;
    private String[] iconNames = new String[]{"oreMagnet", "oreMagnet1", "oreMagnet2"};

    protected ItemTFOreMagnet(int par1) {
        super(par1);
        this.func_77637_a(TFItems.creativeTab);
        this.field_77777_bU = 1;
        this.func_77656_e(12);
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World world, EntityPlayer player) {
        player.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public void func_77615_a(ItemStack par1ItemStack, World world, EntityPlayer player, int useRemaining) {
        int useTime = this.func_77626_a(par1ItemStack) - useRemaining;
        if (!world.field_72995_K && useTime > 10) {
            int moved = this.doMagnet(world, player, 0.0f, 0.0f);
            if (moved == 0) {
                moved = this.doMagnet(world, player, 10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, 10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, 0.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, -10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, -10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, -10.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, 0.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, 10.0f, -10.0f);
            }
            if (moved > 0) {
                par1ItemStack.func_77972_a(moved, (EntityLivingBase)player);
                if (par1ItemStack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
                world.func_72956_a((Entity)player, "mob.endermen.portal", 1.0f, 1.0f);
            }
        }
    }

    public Icon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem != null && usingItem.func_77973_b().field_77779_bT == this.field_77779_bT) {
            int useTime = usingItem.func_77988_m() - useRemaining;
            if (useTime >= 20) {
                return (useTime >> 2) % 2 == 0 ? this.icons[2] : this.icons[1];
            }
            if (useTime > 10) {
                return this.icons[1];
            }
        }
        return this.icons[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        this.icons = new Icon[this.iconNames.length];
        for (int i = 0; i < this.iconNames.length; ++i) {
            this.icons[i] = par1IconRegister.func_94245_a("TwilightForest:" + this.iconNames[i]);
        }
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    protected int doMagnet(World world, EntityPlayer player, float yawOffset, float pitchOffset) {
        double range = 32.0;
        Vec3 srcVec = world.func_82732_R().func_72345_a(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3 lookVec = this.getOffsetLook(player, yawOffset, pitchOffset);
        Vec3 destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        int useX = MathHelper.func_76128_c((double)srcVec.field_72450_a);
        int useY = MathHelper.func_76128_c((double)srcVec.field_72448_b);
        int useZ = MathHelper.func_76128_c((double)srcVec.field_72449_c);
        int destX = MathHelper.func_76128_c((double)destVec.field_72450_a);
        int destY = MathHelper.func_76128_c((double)destVec.field_72448_b);
        int destZ = MathHelper.func_76128_c((double)destVec.field_72449_c);
        int blocksMoved = ItemTFOreMagnet.doMagnet(world, useX, useY, useZ, destX, destY, destZ);
        return blocksMoved;
    }

    public static int doMagnet(World world, int useX, int useY, int useZ, int destX, int destY, int destZ) {
        int blocksMoved = 0;
        ChunkCoordinates[] lineArray = TFGenerator.getBresehnamArrayCoords(useX, useY, useZ, destX, destY, destZ);
        int foundID = -1;
        int foundMeta = -1;
        int foundX = -1;
        int foundY = -1;
        int foundZ = -1;
        int baseX = -1;
        int baseY = -1;
        int baseZ = -1;
        boolean isNetherrack = false;
        for (ChunkCoordinates coord : lineArray) {
            int searchID = world.func_72798_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
            int searchMeta = world.func_72805_g(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
            if (baseY == -1) {
                if (ItemTFOreMagnet.isReplaceable(world, searchID, searchMeta, coord.field_71574_a, coord.field_71572_b, coord.field_71573_c)) {
                    baseX = coord.field_71574_a;
                    baseY = coord.field_71572_b;
                    baseZ = coord.field_71573_c;
                } else if (ItemTFOreMagnet.isNetherReplaceable(world, searchID, searchMeta, coord.field_71574_a, coord.field_71572_b, coord.field_71573_c)) {
                    isNetherrack = true;
                    baseX = coord.field_71574_a;
                    baseY = coord.field_71572_b;
                    baseZ = coord.field_71573_c;
                }
            }
            if (searchID <= 0 || !ItemTFOreMagnet.isOre(searchID, searchMeta)) continue;
            foundID = searchID;
            foundMeta = searchMeta;
            foundX = coord.field_71574_a;
            foundY = coord.field_71572_b;
            foundZ = coord.field_71573_c;
            break;
        }
        if (baseY != -1 && foundID != -1) {
            ArrayList<ChunkCoordinates> veinBlocks = new ArrayList<ChunkCoordinates>();
            ItemTFOreMagnet.findVein(world, foundX, foundY, foundZ, foundID, foundMeta, veinBlocks);
            int offX = baseX - foundX;
            int offY = baseY - foundY;
            int offZ = baseZ - foundZ;
            for (ChunkCoordinates coord : veinBlocks) {
                int replaceX = coord.field_71574_a + offX;
                int replaceY = coord.field_71572_b + offY;
                int replaceZ = coord.field_71573_c + offZ;
                int replaceID = world.func_72798_a(replaceX, replaceY, replaceZ);
                int replaceMeta = world.func_72805_g(replaceX, replaceY, replaceZ);
                if (!(!isNetherrack ? ItemTFOreMagnet.isReplaceable(world, replaceID, replaceMeta, replaceX, replaceY, replaceZ) : ItemTFOreMagnet.isNetherReplaceable(world, replaceID, replaceMeta, replaceX, replaceY, replaceZ)) && replaceID != 0) continue;
                world.func_72832_d(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, isNetherrack ? Block.field_72012_bb.field_71990_ca : Block.field_71981_t.field_71990_ca, 0, 2);
                world.func_72832_d(replaceX, replaceY, replaceZ, foundID, foundMeta, 2);
                ++blocksMoved;
            }
        }
        return blocksMoved;
    }

    private Vec3 getOffsetLook(EntityPlayer player, float yawOffset, float pitchOffset) {
        float var2 = MathHelper.func_76134_b((float)(-(player.field_70177_z + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var3 = MathHelper.func_76126_a((float)(-(player.field_70177_z + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var4 = -MathHelper.func_76134_b((float)(-(player.field_70125_A + pitchOffset) * ((float)Math.PI / 180)));
        float var5 = MathHelper.func_76126_a((float)(-(player.field_70125_A + pitchOffset) * ((float)Math.PI / 180)));
        return player.field_70170_p.func_82732_R().func_72345_a((double)(var3 * var4), (double)var5, (double)(var2 * var4));
    }

    private static boolean isReplaceable(World world, int replaceID, int replaceMeta, int x, int y, int z) {
        if (replaceID == Block.field_71979_v.field_71990_ca) {
            return true;
        }
        if (replaceID == Block.field_71980_u.field_71990_ca) {
            return true;
        }
        if (replaceID == Block.field_71940_F.field_71990_ca) {
            return true;
        }
        return replaceID > 0 && Block.field_71973_m[replaceID].isGenMineableReplaceable(world, x, y, z, Block.field_71981_t.field_71990_ca);
    }

    private static boolean isNetherReplaceable(World world, int replaceID, int replaceMeta, int x, int y, int z) {
        if (replaceID == Block.field_72012_bb.field_71990_ca) {
            return true;
        }
        return replaceID > 0 && Block.field_71973_m[replaceID].isGenMineableReplaceable(world, x, y, z, Block.field_72012_bb.field_71990_ca);
    }

    private static boolean findVein(World world, int x, int y, int z, int oreID, int oreMeta, ArrayList<ChunkCoordinates> veinBlocks) {
        ChunkCoordinates here = new ChunkCoordinates(x, y, z);
        if (veinBlocks.contains(here)) {
            return false;
        }
        if (veinBlocks.size() >= 24) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == oreID && world.func_72805_g(x, y, z) == oreMeta) {
            veinBlocks.add(here);
            ItemTFOreMagnet.findVein(world, x + 1, y, z, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x - 1, y, z, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x, y + 1, z, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x, y - 1, z, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x, y, z + 1, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x, y, z - 1, oreID, oreMeta, veinBlocks);
            return true;
        }
        return false;
    }

    public static boolean isOre(int blockID, int meta) {
        if (blockID == Block.field_71950_I.field_71990_ca) {
            return false;
        }
        if (blockID == Block.field_71949_H.field_71990_ca) {
            return true;
        }
        if (blockID == Block.field_72073_aw.field_71990_ca) {
            return true;
        }
        if (blockID == Block.field_72068_bR.field_71990_ca) {
            return true;
        }
        if (blockID == Block.field_71941_G.field_71990_ca) {
            return true;
        }
        if (blockID == Block.field_71947_N.field_71990_ca) {
            return true;
        }
        if (blockID == Block.field_72047_aN.field_71990_ca) {
            return true;
        }
        if (blockID == Block.field_72048_aO.field_71990_ca) {
            return true;
        }
        if (blockID == Block.field_72048_aO.field_71990_ca) {
            return true;
        }
        if (blockID == Block.field_94342_cr.field_71990_ca) {
            return true;
        }
        if (blockID == TFBlocks.root.field_71990_ca && meta == 1) {
            return true;
        }
        return Block.field_71973_m[blockID].func_71917_a().toLowerCase().contains("ore");
    }
}

