/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.SpawnListEntry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.world.MapGenTFHollowTree;
import twilightforest.world.MapGenTFMajorFeature;
import twilightforest.world.TFGenCaves;
import twilightforest.world.TFGenRavine;
import twilightforest.world.TFWorld;

public class ChunkProviderTwilightForest
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private double[] landMap;
    private double[] stoneNoise = new double[256];
    private TFGenCaves caveGenerator = new TFGenCaves();
    private TFGenRavine ravineGenerator;
    private BiomeGenBase[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] squareTable;
    int[][] unusedIntArray32x32;
    private MapGenTFMajorFeature majorFeatureGenerator = new MapGenTFMajorFeature();
    private MapGenTFHollowTree hollowTreeGenerator = new MapGenTFHollowTree();

    public ChunkProviderTwilightForest(World world, long l, boolean flag) {
        this.ravineGenerator = new TFGenRavine();
        this.unusedIntArray32x32 = new int[32][32];
        this.worldObj = world;
        this.mapFeaturesEnabled = flag;
        this.rand = new Random(l);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void generateTerrain(int par1, int par2, short[] par3ArrayofShort) {
        int byte0 = 4;
        int byte1 = 8;
        byte byte2 = (byte)TFWorld.SEALEVEL;
        int i = byte0 + 1;
        int byte3 = 9;
        int j = byte0 + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, par1 * 4 - 2, par2 * 4 - 2, i + 5, j + 5);
        this.landMap = this.makeLandPerBiome(this.landMap, par1 * byte0, 0, par2 * byte0, i, byte3, j);
        for (int k = 0; k < byte0; ++k) {
            for (int l = 0; l < byte0; ++l) {
                for (int i1 = 0; i1 < byte1; ++i1) {
                    double d = 0.125;
                    double d1 = this.landMap[((k + 0) * j + (l + 0)) * byte3 + (i1 + 0)];
                    double d2 = this.landMap[((k + 0) * j + (l + 1)) * byte3 + (i1 + 0)];
                    double d3 = this.landMap[((k + 1) * j + (l + 0)) * byte3 + (i1 + 0)];
                    double d4 = this.landMap[((k + 1) * j + (l + 1)) * byte3 + (i1 + 0)];
                    double d5 = (this.landMap[((k + 0) * j + (l + 0)) * byte3 + (i1 + 1)] - d1) * d;
                    double d6 = (this.landMap[((k + 0) * j + (l + 1)) * byte3 + (i1 + 1)] - d2) * d;
                    double d7 = (this.landMap[((k + 1) * j + (l + 0)) * byte3 + (i1 + 1)] - d3) * d;
                    double d8 = (this.landMap[((k + 1) * j + (l + 1)) * byte3 + (i1 + 1)] - d4) * d;
                    for (int j1 = 0; j1 < 8; ++j1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k1 = 0; k1 < 4; ++k1) {
                            int l1 = k1 + k * 4 << 11 | 0 + l * 4 << 7 | i1 * 8 + j1;
                            int c = 128;
                            l1 -= c;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            d15 -= d16;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                double d17;
                                d15 += d16;
                                par3ArrayofShort[l1 += c] = d17 > 0.0 ? (short)Block.field_71981_t.field_71990_ca : (i1 * 8 + j1 < byte2 ? (short)Block.field_71943_B.field_71990_ca : (short)0);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, short[] blockArray4096, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        byte sealevel = (byte)TFWorld.SEALEVEL;
        double d = 0.03125;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BiomeGenBase biomegenbase = par4ArrayOfBiomeGenBase[j + i * 16];
                if (biomegenbase == null) {
                    biomegenbase = TFBiomeBase.twilightForest;
                }
                float f = biomegenbase.func_76743_j();
                int k = (int)(this.stoneNoise[i + j * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int l = -1;
                short top = biomegenbase.field_76752_A;
                short filler = biomegenbase.field_76753_B;
                for (int i1 = 127; i1 >= 0; --i1) {
                    int j1 = (j * 16 + i) * 128 + i1;
                    if (i1 <= 0 + this.rand.nextInt(5)) {
                        blockArray4096[j1] = (short)Block.field_71986_z.field_71990_ca;
                        continue;
                    }
                    short currentBlock = blockArray4096[j1];
                    if (currentBlock != Block.field_71981_t.field_71990_ca) continue;
                    if (l == -1) {
                        if (k <= 0) {
                            top = 0;
                            filler = (short)Block.field_71981_t.field_71990_ca;
                        } else if (i1 >= sealevel - 4 && i1 <= sealevel + 1) {
                            top = biomegenbase.field_76752_A;
                            filler = biomegenbase.field_76753_B;
                        }
                        if (i1 < sealevel && top == 0) {
                            top = f < 0.15f ? (short)Block.field_72036_aT.field_71990_ca : (short)Block.field_71943_B.field_71990_ca;
                        }
                        l = k;
                        if (i1 >= sealevel - 1) {
                            blockArray4096[j1] = top;
                            continue;
                        }
                        blockArray4096[j1] = filler;
                        continue;
                    }
                    if (l <= 0) continue;
                    blockArray4096[j1] = filler;
                    if (--l != 0 || filler != Block.field_71939_E.field_71990_ca) continue;
                    l = this.rand.nextInt(4);
                    filler = (short)Block.field_71957_Q.field_71990_ca;
                }
            }
        }
    }

    public Chunk func_73158_c(int i, int j) {
        return this.func_73154_d(i, j);
    }

    public Chunk func_73154_d(int cx, int cz) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        short[] blockStorage = new short[32768];
        byte[] metaStorage = new byte[32768];
        this.generateTerrain(cx, cz, blockStorage);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, cx * 16, cz * 16, 16, 16);
        this.addGlaciers(cx, cz, blockStorage, metaStorage, this.biomesForGeneration);
        this.raiseHills(cx, cz, blockStorage);
        this.addDarkForestCanopy(cx, cz, blockStorage, metaStorage, this.biomesForGeneration);
        this.replaceBlocksForBiome(cx, cz, blockStorage, this.biomesForGeneration);
        this.addFeatureMarker(cx, cz, blockStorage, metaStorage);
        this.caveGenerator.generate(this, this.worldObj, cx, cz, blockStorage);
        this.ravineGenerator.generate(this, this.worldObj, cx, cz, blockStorage);
        byte[] fake = new byte[]{};
        this.majorFeatureGenerator.func_75036_a(this, this.worldObj, cx, cz, fake);
        this.hollowTreeGenerator.func_75036_a(this, this.worldObj, cx, cz, fake);
        Chunk chunk = this.makeAChunk(this.worldObj, blockStorage, metaStorage, cx, cz);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    protected Chunk makeAChunk(World world, short[] ids, byte[] metadata, int chunkX, int chunkZ) {
        Chunk chunk = new Chunk(world, chunkX, chunkZ);
        ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
        int height = ids.length / 256;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < height; ++y) {
                    int index = x << 11 | z << 7 | y;
                    int id = ids[index] & 0xFFF;
                    byte meta = metadata[index];
                    if (id <= 0) continue;
                    int storageIndex = y >> 4;
                    if (storageArrays[storageIndex] == null) {
                        storageArrays[storageIndex] = new ExtendedBlockStorage(storageIndex << 4, true);
                    }
                    storageArrays[storageIndex].func_76655_a(x, y & 0xF, z, id);
                    storageArrays[storageIndex].func_76654_b(x, y & 0xF, z, (int)meta);
                }
            }
        }
        return chunk;
    }

    public void raiseHills(int cx, int cz, short[] storage) {
        TFFeature nearFeature = TFFeature.getNearestFeature(cx, cz, this.worldObj);
        if (nearFeature == TFFeature.nothing) {
            return;
        }
        int[] nearCenter = TFFeature.getNearestCenter(cx, cz, this.worldObj);
        double hdiam = (double)(nearFeature.size * 2 + 1) * 16.0;
        int hx = nearCenter[0];
        int hz = nearCenter[1];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index;
                int y;
                int oldGround = -1;
                int newGround = -1;
                int dx = x - hx;
                int dz = z - hz;
                int dist = (int)Math.sqrt(dx * dx + dz * dz);
                int hheight = (int)(Math.cos((double)dist / hdiam * Math.PI) * (hdiam / 3.0));
                if (nearFeature == TFFeature.hill1 || nearFeature == TFFeature.hill2 || nearFeature == TFFeature.hill3 || nearFeature == TFFeature.hydraLair) {
                    for (int y2 = 0; y2 <= 127; ++y2) {
                        int index2 = (x * 16 + z) * TFWorld.WORLDHEIGHT + y2;
                        short currentTerrain = storage[index2];
                        if (currentTerrain != 0 && currentTerrain != Block.field_72036_aT.field_71990_ca) continue;
                        if (newGround == -1) {
                            oldGround = y2;
                            newGround = oldGround + hheight;
                        }
                        if (y2 > newGround) continue;
                        storage[index2] = (short)Block.field_71981_t.field_71990_ca;
                    }
                    int hollow = hheight - 4 - nearFeature.size;
                    if (nearFeature == TFFeature.hydraLair) {
                        int mx = dx + 16;
                        int mz = dz + 16;
                        int mdist = (int)Math.sqrt(mx * mx + mz * mz);
                        int mheight = (int)(Math.cos((double)mdist / (hdiam / 1.5) * Math.PI) * (hdiam / 1.5));
                        hollow = Math.max(mheight - 4, hollow);
                    }
                    if (hollow < 0) {
                        hollow = 0;
                    }
                    for (int y3 = 0; y3 <= 127; ++y3) {
                        int index3 = (x * 16 + z) * TFWorld.WORLDHEIGHT + y3;
                        if (hheight > 0 && y3 < TFWorld.SEALEVEL && storage[index3] != Block.field_71981_t.field_71990_ca) {
                            storage[index3] = (short)Block.field_71981_t.field_71990_ca;
                        }
                        int hollowFloor = TFWorld.SEALEVEL - 3 - hollow / 8;
                        if (nearFeature == TFFeature.hydraLair) {
                            hollowFloor = TFWorld.SEALEVEL;
                        }
                        if (y3 <= hollowFloor || y3 >= hollowFloor + hollow) continue;
                        storage[index3] = 0;
                    }
                }
                if (nearFeature != TFFeature.hedgeMaze && nearFeature != TFFeature.nagaLair && nearFeature != TFFeature.questGrove) continue;
                float squishfactor = 0.0f;
                int mazeheight = TFWorld.SEALEVEL + 1;
                int FEATUREBOUNDRY = (nearFeature.size * 2 + 1) * 8 - 8;
                if (dx <= -FEATUREBOUNDRY) {
                    squishfactor = (float)(-dx - FEATUREBOUNDRY) / 8.0f;
                }
                if (dx >= FEATUREBOUNDRY) {
                    squishfactor = (float)(dx - FEATUREBOUNDRY) / 8.0f;
                }
                if (dz <= -FEATUREBOUNDRY) {
                    squishfactor = Math.max(squishfactor, (float)(-dz - FEATUREBOUNDRY) / 8.0f);
                }
                if (dz >= FEATUREBOUNDRY) {
                    squishfactor = Math.max(squishfactor, (float)(dz - FEATUREBOUNDRY) / 8.0f);
                }
                if (squishfactor > 0.0f) {
                    newGround = -1;
                    for (y = 0; y <= 127; ++y) {
                        index = (x * 16 + z) * TFWorld.WORLDHEIGHT + y;
                        short currentTerrain = storage[index];
                        if (currentTerrain == Block.field_71981_t.field_71990_ca || newGround != -1) continue;
                        oldGround = y;
                        mazeheight = (int)((float)mazeheight + (float)(oldGround - mazeheight) * squishfactor);
                        newGround = oldGround;
                    }
                }
                for (y = 0; y <= 127; ++y) {
                    index = (x * 16 + z) * TFWorld.WORLDHEIGHT + y;
                    if (y < mazeheight && (storage[index] == 0 || storage[index] == Block.field_71943_B.field_71990_ca)) {
                        storage[index] = (short)Block.field_71981_t.field_71990_ca;
                    }
                    if (y < mazeheight || storage[index] == Block.field_71943_B.field_71990_ca) continue;
                    storage[index] = 0;
                }
            }
        }
    }

    private double[] makeLandPerBiome(double[] ad, int xx, int zero, int zz, int l, int i1, int j1) {
        if (ad == null) {
            ad = new double[l * i1 * j1];
        }
        if (this.squareTable == null) {
            this.squareTable = new float[25];
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    float f;
                    this.squareTable[k1 + 2 + (l1 + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(k1 * k1 + l1 * l1) + 0.2f));
                }
            }
        }
        double d = 684.412;
        double d1 = 684.412;
        this.noise5 = this.noiseGen5.func_76305_a(this.noise5, xx, zz, l, j1, 1.121, 1.121, 0.5);
        this.noise6 = this.noiseGen6.func_76305_a(this.noise6, xx, zz, l, j1, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.func_76304_a(this.noise3, xx, zero, zz, l, i1, j1, d / 80.0, d1 / 160.0, d / 80.0);
        this.noise1 = this.noiseGen1.func_76304_a(this.noise1, xx, zero, zz, l, i1, j1, d, d1, d);
        this.noise2 = this.noiseGen2.func_76304_a(this.noise2, xx, zero, zz, l, i1, j1, d, d1, d);
        zz = 0;
        xx = 0;
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < l; ++k2) {
            for (int l2 = 0; l2 < j1; ++l2) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int byte0 = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[k2 + 2 + (l2 + 2) * (l + 5)];
                for (int i3 = -byte0; i3 <= byte0; ++i3) {
                    for (int j3 = -byte0; j3 <= byte0; ++j3) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[k2 + i3 + 2 + (l2 + j3 + 2) * (l + 5)];
                        float f4 = this.squareTable[i3 + 2 + (j3 + 2) * 5] / (biomegenbase1.field_76748_D + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f4 /= 2.0f;
                        }
                        f1 += biomegenbase1.field_76749_E * f4;
                        f2 += biomegenbase1.field_76748_D * f4;
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = this.noise6[j2] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++j2;
                for (int k3 = 0; k3 < i1; ++k3) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)i1 / 16.0;
                    double d5 = (double)i1 / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)k3 - d5) * 12.0 * 128.0 / (double)TFWorld.WORLDHEIGHT / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noise1[i2] / 512.0;
                    double d9 = this.noise2[i2] / 512.0;
                    double d10 = (this.noise3[i2] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k3 > i1 - 4) {
                        double d11 = (float)(k3 - (i1 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    ad[i2] = d6;
                    ++i2;
                }
            }
        }
        return ad;
    }

    private void addFeatureMarker(int cx, int cz, short[] blockStorage, byte[] metaStorage) {
        TFFeature feature = TFFeature.getFeatureDirectlyAt(cx, cz, this.worldObj);
        if (feature != TFFeature.nothing) {
            byte featureLowNibble = (byte)(feature.featureID & 0xF);
            byte featureHighNibble = (byte)((feature.featureID & 0xF0) >> 4);
            blockStorage[0] = (short)Block.field_71986_z.field_71990_ca;
            blockStorage[1] = (short)Block.field_71986_z.field_71990_ca;
            blockStorage[2] = (short)Block.field_71986_z.field_71990_ca;
            metaStorage[0] = featureLowNibble;
            metaStorage[1] = featureHighNibble;
            metaStorage[2] = 1;
        }
    }

    public void addGlaciers(int chunkX, int chunkZ, short[] blocks, byte[] meta, BiomeGenBase[] biomes) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeGenBase biome = biomes[z + x * 16];
                if (biome != TFBiomeBase.glacier) continue;
                int topLevel = -1;
                for (int y = 127; y >= 0; --y) {
                    int index = (z * 16 + x) * 128 + y;
                    short cb = blocks[index];
                    if (cb != Block.field_71981_t.field_71990_ca) continue;
                    topLevel = y;
                    blocks[index] = (short)Block.field_71940_F.field_71990_ca;
                    break;
                }
                int gHeight = 32;
                int gTop = topLevel + gHeight + 1;
                for (int y = topLevel + 1; y <= gTop && y < 128; ++y) {
                    int index = (z * 16 + x) * 128 + y;
                    blocks[index] = (short)Block.field_72036_aT.field_71990_ca;
                }
            }
        }
    }

    public void addDarkForestCanopy(int chunkX, int chunkZ, short[] blocks, byte[] meta, BiomeGenBase[] biomes) {
        double d = 0.03125;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index;
                short currentBlock;
                boolean generateForest;
                BiomeGenBase biome = biomes[z + x * 16];
                boolean bl = generateForest = biome == TFBiomeBase.darkForest;
                if ((biome == TFBiomeBase.majorFeature || biome == TFBiomeBase.minorFeature) && z + 1 + x * 16 < biomes.length) {
                    boolean bl2 = generateForest = biomes[z + 1 + x * 16] == TFBiomeBase.darkForest;
                }
                if (!generateForest) continue;
                int topLevel = -1;
                for (int y = 127; y >= 0 && (currentBlock = blocks[index = (z * 16 + x) * 128 + y]) != Block.field_71943_B.field_71990_ca; --y) {
                    if (currentBlock != Block.field_71981_t.field_71990_ca) continue;
                    topLevel = y;
                    break;
                }
                if (topLevel == -1) continue;
                int noise = (int)(this.stoneNoise[x + z * 16] / 1.25);
                int treeBottom = topLevel + 7 - noise;
                int treeTop = treeBottom + 11;
                for (int y = treeBottom; y <= treeTop; ++y) {
                    int index2 = (z * 16 + x) * 128 + y;
                    blocks[index2] = (short)TFBlocks.hedge.field_71990_ca;
                    meta[index2] = 1;
                }
            }
        }
    }

    public boolean func_73149_a(int i, int j) {
        return true;
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int chunkX, int chunkZ) {
        long startTime = System.nanoTime();
        BlockSand.field_72192_a = true;
        int mapX = chunkX * 16;
        int mapY = chunkZ * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(mapX + 16, mapY + 16);
        if (biomegenbase == TFBiomeBase.majorFeature || biomegenbase == TFBiomeBase.minorFeature) {
            biomegenbase = this.worldObj.func_72807_a(mapX + 17, mapY + 17);
        }
        this.rand.setSeed(this.worldObj.func_72905_C());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.worldObj.func_72905_C());
        boolean disableFeatures = false;
        this.hollowTreeGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        disableFeatures |= this.majorFeatureGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        if (!(disableFeatures |= !TFFeature.getNearestFeature((int)chunkX, (int)chunkZ, (World)this.worldObj).chunkDecorationsEnabled) && this.rand.nextInt(4) == 0) {
            int i1 = mapX + this.rand.nextInt(16) + 8;
            int i2 = this.rand.nextInt(TFWorld.WORLDHEIGHT);
            int i3 = mapY + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Block.field_71943_B.field_71990_ca).func_76484_a(this.worldObj, this.rand, i1, i2, i3);
        }
        if (!disableFeatures && this.rand.nextInt(32) == 0) {
            int j1 = mapX + this.rand.nextInt(16) + 8;
            int j2 = this.rand.nextInt(this.rand.nextInt(TFWorld.WORLDHEIGHT - 8) + 8);
            int j3 = mapY + this.rand.nextInt(16) + 8;
            if (j2 < TFWorld.SEALEVEL || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Block.field_71938_D.field_71990_ca).func_76484_a(this.worldObj, this.rand, j1, j2, j3);
            }
        }
        for (int k1 = 0; k1 < 8; ++k1) {
            int l3;
            int k3;
            int k2 = mapX + this.rand.nextInt(16) + 8;
            if (new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, k2, k3 = this.rand.nextInt(TFWorld.WORLDHEIGHT), l3 = mapY + this.rand.nextInt(16) + 8)) continue;
        }
        biomegenbase.func_76728_a(this.worldObj, this.rand, mapX, mapY);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(mapX + 8), (int)(mapY + 8), (int)16, (int)16, (Random)this.rand);
        mapX += 8;
        mapY += 8;
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                int j4 = this.worldObj.func_72874_g(mapX + i2, mapY + j3);
                if (this.worldObj.func_72884_u(i2 + mapX, j4 - 1, j3 + mapY)) {
                    this.worldObj.func_72832_d(i2 + mapX, j4 - 1, j3 + mapY, Block.field_72036_aT.field_71990_ca, 0, 2);
                }
                if (!this.worldObj.func_72858_w(i2 + mapX, j4, j3 + mapY)) continue;
                this.worldObj.func_72832_d(i2 + mapX, j4, j3 + mapY, Block.field_72037_aS.field_71990_ca, 0, 2);
            }
        }
        BlockSand.field_72192_a = false;
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "TwilightLevelSource";
    }

    public List<SpawnListEntry> func_73155_a(EnumCreatureType creatureType, int mapX, int mapY, int mapZ) {
        int spawnListIndex;
        TFFeature nearestFeature = TFFeature.getNearestFeatureIncludeMore(mapX >> 4, mapZ >> 4, this.worldObj);
        if (nearestFeature != TFFeature.nothing && (spawnListIndex = this.majorFeatureGenerator.getSpawnListIndexAt(mapX, mapY, mapZ)) >= 0) {
            return nearestFeature.getSpawnableList(creatureType, spawnListIndex);
        }
        if (mapY < TFWorld.SEALEVEL && creatureType == EnumCreatureType.monster) {
            return TFFeature.underground.getSpawnableList(creatureType);
        }
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(mapX, mapZ);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.func_76747_a(creatureType);
    }

    public ChunkPosition func_73150_a(World par1World, String par2Str, int par3, int par4, int par5) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int var1, int var2) {
        this.majorFeatureGenerator.func_75036_a(this, this.worldObj, var1, var2, null);
        this.hollowTreeGenerator.func_75036_a(this, this.worldObj, var1, var2, null);
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }
}

