/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class TFGenerator
extends WorldGenerator {
    public TFGenerator() {
        this(false);
    }

    public TFGenerator(boolean par1) {
        super(par1);
    }

    public static int[] translate(int sx, int sy, int sz, double distance, double angle, double tilt) {
        int[] dest = new int[]{sx, sy, sz};
        double rangle = angle * 2.0 * Math.PI;
        double rtilt = tilt * Math.PI;
        dest[0] = (int)((long)dest[0] + Math.round(Math.sin(rangle) * Math.sin(rtilt) * distance));
        dest[1] = (int)((long)dest[1] + Math.round(Math.cos(rtilt) * distance));
        dest[2] = (int)((long)dest[2] + Math.round(Math.cos(rangle) * Math.sin(rtilt) * distance));
        return dest;
    }

    public static ChunkCoordinates translateCoords(int sx, int sy, int sz, double distance, double angle, double tilt) {
        ChunkCoordinates dest = new ChunkCoordinates(sx, sy, sz);
        double rangle = angle * 2.0 * Math.PI;
        double rtilt = tilt * Math.PI;
        dest.field_71574_a = (int)((long)dest.field_71574_a + Math.round(Math.sin(rangle) * Math.sin(rtilt) * distance));
        dest.field_71572_b = (int)((long)dest.field_71572_b + Math.round(Math.cos(rtilt) * distance));
        dest.field_71573_c = (int)((long)dest.field_71573_c + Math.round(Math.cos(rangle) * Math.sin(rtilt) * distance));
        return dest;
    }

    protected void drawBresehnam(World world, int x1, int y1, int z1, int x2, int y2, int z2, int blockValue, int metaValue) {
        ChunkCoordinates[] lineArray;
        for (ChunkCoordinates pixel : lineArray = TFGenerator.getBresehnamArrayCoords(x1, y1, z1, x2, y2, z2)) {
            this.func_76485_a(world, pixel.field_71574_a, pixel.field_71572_b, pixel.field_71573_c, blockValue, metaValue);
        }
    }

    public static ChunkCoordinates[] getBresehnamArrayCoords(ChunkCoordinates src, ChunkCoordinates dest) {
        return TFGenerator.getBresehnamArrayCoords(src.field_71574_a, src.field_71572_b, src.field_71573_c, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c);
    }

    public static ChunkCoordinates[] getBresehnamArrayCoords(int x1, int y1, int z1, int x2, int y2, int z2) {
        ChunkCoordinates[] lineArray;
        ChunkCoordinates pixel = new ChunkCoordinates(x1, y1, z1);
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        if (l >= m && l >= n) {
            int err_1 = dy2 - l;
            int err_2 = dz2 - l;
            lineArray = new ChunkCoordinates[l + 1];
            for (int i = 0; i < l; ++i) {
                lineArray[i] = new ChunkCoordinates(pixel);
                if (err_1 > 0) {
                    pixel.field_71572_b += y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    pixel.field_71573_c += z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                pixel.field_71574_a += x_inc;
            }
        } else if (m >= l && m >= n) {
            int err_1 = dx2 - m;
            int err_2 = dz2 - m;
            lineArray = new ChunkCoordinates[m + 1];
            for (int i = 0; i < m; ++i) {
                lineArray[i] = new ChunkCoordinates(pixel);
                if (err_1 > 0) {
                    pixel.field_71574_a += x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    pixel.field_71573_c += z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                pixel.field_71572_b += y_inc;
            }
        } else {
            int err_1 = dy2 - n;
            int err_2 = dx2 - n;
            lineArray = new ChunkCoordinates[n + 1];
            for (int i = 0; i < n; ++i) {
                lineArray[i] = new ChunkCoordinates(pixel);
                if (err_1 > 0) {
                    pixel.field_71572_b += y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    pixel.field_71574_a += x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                pixel.field_71573_c += z_inc;
            }
        }
        lineArray[lineArray.length - 1] = new ChunkCoordinates(pixel);
        return lineArray;
    }

    public void makeLeafCircle(World world, int sx, int sy, int sz, int rad, int blockValue, int metaValue) {
        this.makeLeafCircle(world, sx, sy, sz, rad, blockValue, metaValue, false);
    }

    public void makeLeafCircle(World world, int sx, int sy, int sz, int rad, int blockValue, int metaValue, boolean useHack) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = Math.max(dx, dz) + (Math.min(dx, dz) >> 1);
                if (useHack && dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dist > rad) continue;
                this.putLeafBlock(world, sx + dx, sy, sz + dz, blockValue, metaValue);
                this.putLeafBlock(world, sx + dx, sy, sz - dz, blockValue, metaValue);
                this.putLeafBlock(world, sx - dx, sy, sz + dz, blockValue, metaValue);
                this.putLeafBlock(world, sx - dx, sy, sz - dz, blockValue, metaValue);
            }
        }
    }

    public void putLeafBlock(World world, int x, int y, int z, int blockValue, int metaValue) {
        int whatsThere = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[whatsThere];
        if (block == null || block.canBeReplacedByLeaves(world, x, y, z)) {
            this.func_76485_a(world, x, y, z, blockValue, metaValue);
        }
    }

    protected byte randStone(Random rand, int howMuch) {
        return rand.nextInt(howMuch) >= 1 ? (byte)Block.field_71978_w.field_71990_ca : (byte)Block.field_72087_ao.field_71990_ca;
    }

    protected boolean isAreaClear(World world, Random rand, int x, int y, int z, int dx, int dy, int dz) {
        boolean flag = true;
        for (int cx = 0; cx < dx; ++cx) {
            for (int cz = 0; cz < dy; ++cz) {
                Material m = world.func_72803_f(x + cx, y - 1, z + cz);
                if (m != Material.field_76248_c && m != Material.field_76247_b && m != Material.field_76246_e) {
                    flag = false;
                }
                for (int cy = 0; cy < dz; ++cy) {
                    if (world.func_72799_c(x + cx, y + cy, z + cz)) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    public void drawBlob(World world, int sx, int sy, int sz, int rad, int blockValue, int metaValue) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = 0;
                    dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    this.func_76485_a(world, sx + dx, sy + dy, sz + dz, blockValue, metaValue);
                    this.func_76485_a(world, sx + dx, sy + dy, sz - dz, blockValue, metaValue);
                    this.func_76485_a(world, sx - dx, sy + dy, sz + dz, blockValue, metaValue);
                    this.func_76485_a(world, sx - dx, sy + dy, sz - dz, blockValue, metaValue);
                    this.func_76485_a(world, sx + dx, sy - dy, sz + dz, blockValue, metaValue);
                    this.func_76485_a(world, sx + dx, sy - dy, sz - dz, blockValue, metaValue);
                    this.func_76485_a(world, sx - dx, sy - dy, sz + dz, blockValue, metaValue);
                    this.func_76485_a(world, sx - dx, sy - dy, sz - dz, blockValue, metaValue);
                }
            }
        }
    }

    public void drawLeafBlob(World world, int sx, int sy, int sz, int rad, int blockValue, int metaValue) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = 0;
                    dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    this.putLeafBlock(world, sx + dx, sy + dy, sz + dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx + dx, sy + dy, sz - dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx - dx, sy + dy, sz + dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx - dx, sy + dy, sz - dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx + dx, sy - dy, sz + dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx + dx, sy - dy, sz - dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx - dx, sy - dy, sz + dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx - dx, sy - dy, sz - dz, blockValue, metaValue);
                }
            }
        }
    }

    protected boolean hasAirAround(IBlockAccess world, int bx, int by, int bz) {
        boolean airAround = false;
        if (world.func_72798_a(bx + 1, by, bz) == 0) {
            airAround = true;
        }
        if (world.func_72798_a(bx - 1, by, bz) == 0) {
            airAround = true;
        }
        if (world.func_72798_a(bx, by, bz + 1) == 0) {
            airAround = true;
        }
        if (world.func_72798_a(bx, by, bz - 1) == 0) {
            airAround = true;
        }
        if (world.func_72798_a(bx, by + 1, bz) == 0) {
            airAround = true;
        }
        return airAround;
    }

    protected static boolean isNearSolid(IBlockAccess world, int bx, int by, int bz) {
        boolean nearSolid = false;
        if (world.func_72803_f(bx + 1, by, bz).func_76220_a()) {
            nearSolid = true;
        }
        if (world.func_72803_f(bx - 1, by, bz).func_76220_a()) {
            nearSolid = true;
        }
        if (world.func_72803_f(bx, by, bz + 1).func_76220_a()) {
            nearSolid = true;
        }
        if (world.func_72803_f(bx, by, bz - 1).func_76220_a()) {
            nearSolid = true;
        }
        return nearSolid;
    }
}

