/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.trollcave;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.trollcave.ComponentTFTrollCaveGarden;
import twilightforest.structures.trollcave.ComponentTFTrollCaveMain;

public class ComponentTFTrollCaveConnect
extends ComponentTFTrollCaveMain {
    public ComponentTFTrollCaveConnect() {
    }

    public ComponentTFTrollCaveConnect(int index, int x, int y, int z, int caveSize, int caveHeight, int direction) {
        super(index);
        this.size = caveSize;
        this.height = caveHeight;
        this.setCoordBaseMode(direction);
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction);
    }

    @Override
    public void func_74861_a(StructureComponent parent, List list, Random rand) {
        if (this.func_74877_c() < 3) {
            for (int i = 0; i < 4; ++i) {
                ChunkCoordinates dest = this.getValidOpening(rand, 2, i);
                if (!rand.nextBoolean() && this.makeGardenCave(list, rand, this.func_74877_c() + 1, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c, 30, 15, i)) continue;
                this.makeSmallerCave(list, rand, this.func_74877_c() + 1, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c, 20, 15, i);
            }
        }
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        ChunkCoordinates dest;
        int i;
        if (this.isBoundingBoxOutOfHighlands(world, sbb)) {
            return false;
        }
        this.hollowCaveMiddle(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockStalactite(world, decoRNG, Blocks.field_150348_b, 0.5f, true, dest.field_71574_a, 3, dest.field_71573_c, sbb);
        }
        for (i = 0; i < 8; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockStalactite(world, decoRNG, Blocks.field_150348_b, 0.5f, false, dest.field_71574_a, 3, dest.field_71573_c, sbb);
        }
        return true;
    }

    protected boolean makeGardenCave(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int caveSize, int caveHeight, int rotation) {
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        ChunkCoordinates dest = this.offsetTowerCCoords(x, y, z, caveSize, direction);
        ComponentTFTrollCaveGarden cave = new ComponentTFTrollCaveGarden(index, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c, caveSize, caveHeight, direction);
        StructureComponent intersect = StructureComponent.func_74883_a(list, (StructureBoundingBox)cave.func_74874_b());
        StructureComponent otherGarden = this.findNearbyGarden(list, cave.func_74874_b());
        if ((intersect == null || intersect == this) && otherGarden == null) {
            list.add(cave);
            cave.func_74861_a(list.get(0), list, rand);
            return true;
        }
        return false;
    }

    private StructureComponent findNearbyGarden(List<StructureComponent> list, StructureBoundingBox boundingBox) {
        StructureBoundingBox largeBox = new StructureBoundingBox(boundingBox);
        largeBox.field_78897_a -= 40;
        largeBox.field_78895_b -= 40;
        largeBox.field_78896_c -= 40;
        largeBox.field_78893_d += 40;
        largeBox.field_78894_e += 40;
        largeBox.field_78892_f += 40;
        for (StructureComponent component : list) {
            if (!(component instanceof ComponentTFTrollCaveGarden) || !component.func_74874_b().func_78884_a(largeBox)) continue;
            return component;
        }
        return null;
    }
}

