/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.armourer.dialog;

import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.AbstractGuiDialog;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCheckBox;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.IDialogCallback;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.type.block.SkinBlock;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDialogCopy
extends AbstractGuiDialog {
    private final ISkinType skinType;
    private GuiButtonExt buttonClose;
    private GuiButtonExt buttonCopy;
    private GuiDropDownList dropDownSrcPart;
    private GuiDropDownList dropDownDesPart;
    private GuiCheckBox checkMirror;
    private final SkinProperties skinProperties;

    public GuiDialogCopy(GuiScreen parent, String name, IDialogCallback callback, int width, int height, ISkinType skinType, SkinProperties skinProperties) {
        super(parent, name, callback, width, height);
        this.skinType = skinType;
        this.skinProperties = skinProperties;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonClose = new GuiButtonExt(-1, this.x + this.width - 80 - 10, this.y + this.height - 30, 80, 20, GuiHelper.getLocalizedControlName(this.name, "close", new Object[0]));
        this.buttonCopy = new GuiButtonExt(-1, this.x + this.width - 160 - 20, this.y + this.height - 30, 80, 20, GuiHelper.getLocalizedControlName(this.name, "copy", new Object[0]));
        this.checkMirror = new GuiCheckBox(-1, this.x + 10, this.y + this.height - 50, GuiHelper.getLocalizedControlName(this.name, "mirror", new Object[0]), false);
        this.dropDownSrcPart = new GuiDropDownList(0, this.x + 10, this.y + 35, 80, "", null);
        this.dropDownDesPart = new GuiDropDownList(0, this.x + 100, this.y + 35, 80, "", null);
        if (this.skinType != null) {
            if (this.skinType != SkinTypeRegistry.skinBlock) {
                for (int i = 0; i < this.skinType.getSkinParts().size(); ++i) {
                    this.addPartToDropDown(this.dropDownSrcPart, this.skinType.getSkinParts().get(i));
                    this.addPartToDropDown(this.dropDownDesPart, this.skinType.getSkinParts().get(i));
                }
            } else {
                boolean multiblock = SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(this.skinProperties);
                ISkinPartType partType = multiblock ? ((SkinBlock)SkinTypeRegistry.skinBlock).partMultiblock : ((SkinBlock)SkinTypeRegistry.skinBlock).partBase;
                this.addPartToDropDown(this.dropDownSrcPart, partType);
                this.addPartToDropDown(this.dropDownDesPart, partType);
            }
        }
        this.dropDownSrcPart.setListSelectedIndex(0);
        this.dropDownDesPart.setListSelectedIndex(0);
        this.buttonList.add(this.buttonClose);
        this.buttonList.add(this.buttonCopy);
        this.buttonList.add(this.checkMirror);
        this.buttonList.add(this.dropDownSrcPart);
        this.buttonList.add(this.dropDownDesPart);
    }

    private void addPartToDropDown(GuiDropDownList dropDown, ISkinPartType partType) {
        String regName = partType.getRegistryName();
        String disName = SkinTypeRegistry.INSTANCE.getLocalizedSkinPartTypeName(partType);
        dropDown.addListItem(disName, regName, true);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.buttonClose) {
            this.returnDialogResult(IDialogCallback.DialogResult.CANCEL);
        }
        if (button == this.buttonCopy) {
            this.returnDialogResult(IDialogCallback.DialogResult.OK);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        super.drawForeground(mouseX, mouseY, partialTickTime);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.name, "srcPart", new Object[0]), this.x + 10, this.y + 25, 0x404040);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.name, "desPart", new Object[0]), this.x + 100, this.y + 25, 0x404040);
        this.drawTitle();
        this.dropDownSrcPart.drawForeground(this.mc, mouseX, mouseY, partialTickTime);
        this.dropDownDesPart.drawForeground(this.mc, mouseX, mouseY, partialTickTime);
    }

    public ISkinPartType getSrcPart() {
        return SkinTypeRegistry.INSTANCE.getSkinPartFromRegistryName(this.dropDownSrcPart.getListSelectedItem().tag);
    }

    public ISkinPartType getDesPart() {
        return SkinTypeRegistry.INSTANCE.getSkinPartFromRegistryName(this.dropDownDesPart.getListSelectedItem().tag);
    }

    public boolean isMirror() {
        return this.checkMirror.isChecked();
    }
}

