/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.armourer.tab;

import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.armourer.GuiArmourer;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCheckBox;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiButton;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiSetSkin;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTabArmourerDisplaySettings
extends GuiTabPanel
implements GuiDropDownList.IDropDownListCallback {
    private static final ResourceLocation TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/armourer/armourer.png");
    private final TileEntityArmourer tileEntity;
    private GuiDropDownList textureTypeList;
    private GuiTextField textUserSkin;
    private GuiCheckBox checkShowGuides;
    private GuiCheckBox checkShowHelper;

    public GuiTabArmourerDisplaySettings(int tabId, GuiScreen parent) {
        super(tabId, parent, false);
        this.tileEntity = ((GuiArmourer)parent).tileEntity;
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        super.initGui(xPos, yPos, width, height);
        String guiName = this.tileEntity.func_70005_c_();
        this.buttonList.clear();
        this.checkShowGuides = new GuiCheckBox(7, 10, 110, GuiHelper.getLocalizedControlName(guiName, "showGuide", new Object[0]), this.tileEntity.isShowGuides());
        this.checkShowHelper = new GuiCheckBox(6, 10, 125, GuiHelper.getLocalizedControlName(guiName, "showHelper", new Object[0]), this.tileEntity.isShowHelper());
        this.buttonList.add(new GuiButtonExt(8, 10, 90, 80, 16, GuiHelper.getLocalizedControlName(guiName, "set", new Object[0])));
        this.textUserSkin = new GuiTextField(-1, this.fontRenderer, this.x + 10, this.y + 70, 120, 16);
        this.textUserSkin.func_146203_f(300);
        this.textUserSkin.func_146180_a(this.tileEntity.getTexture().getTextureString());
        this.textureTypeList = new GuiDropDownList(0, 10, 30, 80, "", this);
        this.textureTypeList.addListItem(GuiHelper.getLocalizedControlName(this.tileEntity.func_70005_c_(), "dropdown.user", new Object[0]), TextureType.USER.toString(), true);
        this.textureTypeList.addListItem(GuiHelper.getLocalizedControlName(this.tileEntity.func_70005_c_(), "dropdown.url", new Object[0]), TextureType.URL.toString(), true);
        this.textureTypeList.setListSelectedIndex(this.tileEntity.getTexture().getTextureType().ordinal());
        this.buttonList.add(this.checkShowGuides);
        this.buttonList.add(this.checkShowHelper);
        this.buttonList.add(this.textureTypeList);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        this.textUserSkin.func_146192_a(mouseX, mouseY, button);
        return clicked;
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        return this.textUserSkin.func_146201_a(c, keycode);
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button.field_146127_k == 8) {
            String username = this.textUserSkin.func_146179_b().trim();
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiSetSkin(new PlayerTexture(username, TextureType.values()[this.textureTypeList.getListSelectedIndex()])));
        } else {
            PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiButton((byte)button.field_146127_k));
        }
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.x, this.y, 0, 0, this.width, this.height);
        this.func_73729_b(this.x + 7, this.y + 141, 7, 3, 162, 76);
        this.textUserSkin.func_146194_f();
        this.checkShowGuides.setIsChecked(this.tileEntity.isShowGuides());
        this.checkShowHelper.field_146125_m = this.tileEntity.getSkinType() != null ? this.tileEntity.getSkinType().showHelperCheckbox() : false;
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY, float partialTickTime) {
        String labelSkinType = GuiHelper.getLocalizedControlName(this.tileEntity.func_70005_c_(), "label.skinType", new Object[0]);
        String usernameLabel = GuiHelper.getLocalizedControlName(this.tileEntity.func_70005_c_(), "label.username", new Object[0]);
        String urlLabel = GuiHelper.getLocalizedControlName(this.tileEntity.func_70005_c_(), "label.url", new Object[0]);
        this.fontRenderer.func_78276_b(labelSkinType, 10, 20, 0x404040);
        if (this.textureTypeList.getListSelectedIndex() == 0) {
            this.fontRenderer.func_78276_b(usernameLabel, 10, 60, 0x404040);
        } else {
            this.fontRenderer.func_78276_b(urlLabel, 10, 60, 0x404040);
        }
        super.drawForegroundLayer(mouseX, mouseY, partialTickTime);
        this.textureTypeList.drawForeground(this.mc, mouseX - this.x, mouseY - this.y, partialTickTime);
    }

    @Override
    public void onDropDownListChanged(GuiDropDownList dropDownList) {
        this.textUserSkin.func_146180_a("");
    }
}

