/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.armourer.tab;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.armourer.GuiArmourer;
import moe.plushie.armourers_workshop.client.gui.controls.GuiDropDownList;
import moe.plushie.armourers_workshop.client.gui.controls.GuiHelp;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.client.gui.controls.ModGuiControl;
import moe.plushie.armourers_workshop.common.lib.LibModInfo;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiButton;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiSetArmourerSkinProps;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiSetArmourerSkinType;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientLoadArmour;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTabArmourerMain
extends GuiTabPanel<GuiArmourer>
implements GuiDropDownList.IDropDownListCallback {
    private static final ResourceLocation TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/armourer/armourer.png");
    private final TileEntityArmourer tileEntity;
    private GuiDropDownList dropDownSkinType;
    private GuiTextField textItemName;
    private GuiTextField textFlavour;
    private boolean resetting;
    int fidgCount = 0;
    String[] fidgMessage = new String[]{"STOP!", "STOP ALREADY", "I SAID STOP!"};

    public GuiTabArmourerMain(int tabId, GuiArmourer parent) {
        super(tabId, parent, false);
        this.tileEntity = parent.tileEntity;
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        super.initGui(xPos, yPos, width, height);
        String guiName = this.tileEntity.func_70005_c_();
        this.buttonList.clear();
        SkinTypeRegistry str = SkinTypeRegistry.INSTANCE;
        this.dropDownSkinType = new GuiDropDownList(0, 7, 21, 50, "", this);
        ArrayList<ISkinType> skinList = str.getRegisteredSkinTypes();
        int skinCount = 0;
        for (int i = 0; i < skinList.size(); ++i) {
            ISkinType skinType = skinList.get(i);
            if (!(!skinType.isHidden() & skinType != SkinTypeRegistry.skinOutfit)) continue;
            String skinLocalizedName = str.getLocalizedSkinTypeName(skinType);
            String skinRegistryName = skinType.getRegistryName();
            DropDownItemSkin item = new DropDownItemSkin(skinLocalizedName, skinRegistryName, skinType.enabled(), skinType);
            this.dropDownSkinType.addListItem(item);
            if (skinType == this.tileEntity.getSkinType()) {
                this.dropDownSkinType.setListSelectedIndex(skinCount);
            }
            ++skinCount;
        }
        this.buttonList.add(this.dropDownSkinType);
        this.buttonList.add(new GuiButtonExt(13, 88, 16, 50, 12, GuiHelper.getLocalizedControlName(guiName, "save", new Object[0])));
        this.buttonList.add(new GuiButtonExt(14, 88, 29, 50, 12, GuiHelper.getLocalizedControlName(guiName, "load", new Object[0])));
        this.textItemName = new GuiTextField(-1, this.fontRenderer, this.x + 8, this.y + 58, 158, 16);
        this.textItemName.func_146203_f(40);
        this.textItemName.func_146180_a(SkinProperties.PROP_ALL_CUSTOM_NAME.getValue(this.tileEntity.getSkinProps()));
        this.textFlavour = new GuiTextField(-1, this.fontRenderer, this.x + 8, this.y + 90, 158, 16);
        this.textFlavour.func_146203_f(40);
        this.textFlavour.func_146180_a(SkinProperties.PROP_ALL_FLAVOUR_TEXT.getValue(this.tileEntity.getSkinProps()));
        this.buttonList.add(new GuiHelp((ModGuiControl.IScreenSize)this.parent, 0, 6, 12, GuiHelper.getLocalizedControlName(guiName, "main.help.skinType", new Object[0])));
        this.buttonList.add(new GuiHelp((ModGuiControl.IScreenSize)this.parent, 0, 81, 18, GuiHelper.getLocalizedControlName(guiName, "main.help.save", new Object[0])));
        this.buttonList.add(new GuiHelp((ModGuiControl.IScreenSize)this.parent, 0, 81, 30, GuiHelper.getLocalizedControlName(guiName, "main.help.load", new Object[0])));
        this.buttonList.add(new GuiHelp((ModGuiControl.IScreenSize)this.parent, 0, 6, 48, GuiHelper.getLocalizedControlName(guiName, "main.help.itemName", new Object[0])));
        this.buttonList.add(new GuiHelp((ModGuiControl.IScreenSize)this.parent, 0, 6, 80, GuiHelper.getLocalizedControlName(guiName, "main.help.itemFlavour", new Object[0])));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (!clicked) {
            this.textItemName.func_146192_a(mouseX, mouseY, button);
            this.textFlavour.func_146192_a(mouseX, mouseY, button);
            if (button == 1) {
                if (this.textItemName.func_146206_l()) {
                    this.textItemName.func_146180_a("");
                }
                if (this.textFlavour.func_146206_l()) {
                    this.textFlavour.func_146180_a("");
                }
            }
        }
        return clicked;
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        boolean typed = super.keyTyped(c, keycode);
        if (!typed) {
            typed = this.textItemName.func_146201_a(c, keycode);
        }
        if (!typed) {
            typed = this.textFlavour.func_146201_a(c, keycode);
        }
        if (typed) {
            SkinProperties skinProps = this.tileEntity.getSkinProps();
            String sendTextName = this.textItemName.func_146179_b().trim();
            String sendTextFlavour = this.textFlavour.func_146179_b().trim();
            if (this.fidgCount < 3 && sendTextName.equalsIgnoreCase("fidget spinner")) {
                sendTextName = this.fidgMessage[this.fidgCount];
                ++this.fidgCount;
            }
            boolean textChanged = false;
            if (!sendTextName.equals(SkinProperties.PROP_ALL_CUSTOM_NAME.getValue(skinProps))) {
                textChanged = true;
            }
            if (!sendTextFlavour.equals(SkinProperties.PROP_ALL_FLAVOUR_TEXT.getValue(skinProps))) {
                textChanged = true;
            }
            if (textChanged) {
                SkinProperties.PROP_ALL_CUSTOM_NAME.setValue(skinProps, sendTextName);
                SkinProperties.PROP_ALL_FLAVOUR_TEXT.setValue(skinProps, sendTextFlavour);
                PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiSetArmourerSkinProps(skinProps));
            }
        }
        return typed;
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        switch (button.field_146127_k) {
            case 13: {
                PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientLoadArmour(this.textItemName.func_146179_b().trim(), ""));
                break;
            }
            default: {
                if (button.field_146127_k == 14) {
                    // empty if block
                }
                PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiButton((byte)button.field_146127_k));
            }
        }
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.x, this.y, 0, 0, this.width, this.height);
        this.func_73729_b(this.x + 63, this.y + 20, 238, 0, 18, 18);
        this.func_73729_b(this.x + 142, this.y + 16, 230, 18, 26, 26);
        this.fontRenderer.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), this.x + 8, this.y + this.height - 96 + 2, 0x404040);
        this.textItemName.func_146194_f();
        this.textFlavour.func_146194_f();
    }

    public void resetValues(SkinProperties skinProperties) {
        this.resetting = true;
        String newNameText = SkinProperties.PROP_ALL_CUSTOM_NAME.getValue(skinProperties);
        if (!newNameText.equals("")) {
            int cur = this.textItemName.func_146198_h();
            this.textItemName.func_146180_a(newNameText);
            this.textItemName.func_146190_e(cur);
        } else {
            this.textItemName.func_146180_a(newNameText);
        }
        String newFlavourText = SkinProperties.PROP_ALL_FLAVOUR_TEXT.getValue(skinProperties);
        if (!newFlavourText.equals("")) {
            int cur = this.textFlavour.func_146198_h();
            this.textFlavour.func_146180_a(newFlavourText);
            this.textFlavour.func_146190_e(cur);
        } else {
            this.textFlavour.func_146180_a(newFlavourText);
        }
        this.resetting = false;
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY, float partialTickTime) {
        super.drawForegroundLayer(mouseX, mouseY, partialTickTime);
        String itemNameLabel = GuiHelper.getLocalizedControlName(this.tileEntity.func_70005_c_(), "label.itemName", new Object[0]);
        String labelFlavour = GuiHelper.getLocalizedControlName(this.tileEntity.func_70005_c_(), "label.flavour", new Object[0]);
        String versionLabel = LibModInfo.RELEASE_TYPE.toString() + ": " + "1.12.2-0.50.3";
        this.fontRenderer.func_78276_b(itemNameLabel, 14, 48, 0x404040);
        this.fontRenderer.func_78276_b(labelFlavour, 14, 80, 0x404040);
        int versionWidth = this.fontRenderer.func_78256_a(versionLabel);
        this.fontRenderer.func_78276_b(versionLabel, this.width - versionWidth - 7, this.height - 96 + 2, 0x404040);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.dropDownSkinType.drawForeground(this.mc, mouseX - this.x, mouseY - this.y, partialTickTime);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
        for (int i = 0; i < this.buttonList.size(); ++i) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            if (!(button instanceof GuiHelp)) continue;
            ((GuiHelp)button).drawRollover(this.mc, mouseX - this.x, mouseY - this.y);
        }
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void onDropDownListChanged(GuiDropDownList dropDownList) {
        GuiDropDownList.DropDownListItem listItem = dropDownList.getListSelectedItem();
        ISkinType skinType = SkinTypeRegistry.INSTANCE.getSkinTypeFromRegistryName(listItem.tag);
        ((GuiArmourer)this.parent).skinTypeUpdate(skinType);
        PacketHandler.networkWrapper.sendToServer((IMessage)new MessageClientGuiSetArmourerSkinType(skinType));
    }

    public static class DropDownItemSkin
    extends GuiDropDownList.DropDownListItem {
        private final ISkinType skinType;

        public DropDownItemSkin(String displayText, String tag, boolean enabled, ISkinType skinType) {
            super(displayText, tag, enabled);
            this.skinType = skinType;
        }

        @Override
        public void drawItem(Minecraft mc, GuiDropDownList parent, int x, int y, int mouseX, int mouseY, float partial, boolean topItem) {
            int textWidth = parent.field_146120_f - 8;
            int textHeight = 8;
            int textColour = 0xFFFFFF;
            if (topItem) {
                mc.field_71466_p.func_78276_b(this.displayText, x, y, textColour);
            } else {
                if (!this.enabled) {
                    textColour = -3407872;
                } else if (this.isMouseOver(parent, x, y, mouseX, mouseY) & !topItem && this.enabled) {
                    textColour = 0xFFFFA0;
                    Gui.func_73734_a((int)x, (int)y, (int)(x + textWidth), (int)(y + textHeight), (int)0x44CCCCCC);
                }
                mc.field_71446_o.func_110577_a(this.skinType.getIcon());
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                Gui.func_152125_a((int)(x - 2), (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)8, (int)8, (float)16.0f, (float)16.0f);
                mc.field_71466_p.func_78276_b(this.displayText, x + 7, y, textColour);
            }
        }
    }
}

