/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.client.render.SkinItemRenderHelper;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiControlSkinPanel
extends GuiButtonExt {
    private static final ResourceLocation TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/_controls/skin-panel.png");
    private final ArrayList<SkinIcon> iconList = new ArrayList();
    private int panelPadding;
    private int iconPadding;
    private int iconSize;
    private int iconCount;
    private int rowCount;
    private int colCount;
    private boolean showName;
    private SkinIcon lastPressedSkinIcon;

    public GuiControlSkinPanel() {
        this(0, 0, 0, 0);
    }

    public GuiControlSkinPanel(int xPos, int yPos, int width, int height) {
        super(0, xPos, yPos, width, height, "");
    }

    public void init(int x, int y, int width, int height) {
        this.field_146128_h = x;
        this.field_146129_i = y;
        this.field_146120_f = width;
        this.field_146121_g = height;
        this.panelPadding = 1;
        this.iconPadding = 1;
        this.iconSize = 50;
        this.showName = false;
        this.lastPressedSkinIcon = null;
        this.updateIconCount();
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
        this.updateIconCount();
    }

    public void setPanelPadding(int panelPadding) {
        this.panelPadding = panelPadding;
    }

    public void setShowName(boolean showName) {
        this.showName = showName;
    }

    public void updateIconCount() {
        int boxW = this.field_146120_f + this.iconPadding - this.panelPadding * 2;
        int boxH = this.field_146121_g + this.iconPadding - this.panelPadding * 2;
        this.rowCount = Math.max(1, (int)Math.floor(boxW / (this.iconSize + this.iconPadding)));
        this.colCount = Math.max(1, (int)Math.floor(boxH / (this.iconSize + this.iconPadding)));
        this.iconCount = this.rowCount * this.colCount;
    }

    public int getIconCount() {
        return this.iconCount;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int hover = this.func_146114_a(this.field_146123_n);
            this.func_73733_a(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + this.field_146121_g, -1071504862, -801950925);
            for (int i = 0; i < this.iconList.size(); ++i) {
                int x = i % this.rowCount;
                int y = i / this.rowCount;
                int iconX = this.field_146128_h + x * (this.iconSize + this.iconPadding) + this.panelPadding;
                int iconY = this.field_146129_i + y * (this.iconSize + this.iconPadding) + this.panelPadding;
                SkinIcon skinIcon = this.iconList.get(i);
                if (y >= this.colCount) continue;
                skinIcon.drawIcon(iconX, iconY, mouseX, mouseY, this.iconSize, this.showName & this.iconSize > 30);
            }
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        for (int i = 0; i < this.iconList.size(); ++i) {
            int x = i % this.rowCount;
            int y = i / this.rowCount;
            int iconX = this.field_146128_h + x * (this.iconSize + this.iconPadding) + this.panelPadding;
            int iconY = this.field_146129_i + y * (this.iconSize + this.iconPadding) + this.panelPadding;
            SkinIcon skinIcon = this.iconList.get(i);
            if (y >= this.colCount || !skinIcon.mouseOver(iconX, iconY, mouseX, mouseY, this.iconSize)) continue;
            this.lastPressedSkinIcon = skinIcon;
            return true;
        }
        return false;
    }

    public SkinIcon getLastPressedSkinIcon() {
        return this.lastPressedSkinIcon;
    }

    public void clearIcons() {
        this.iconList.clear();
    }

    public void addIcon(JsonObject skinJson) {
        this.iconList.add(new SkinIcon(skinJson));
    }

    public class SkinIcon {
        private final JsonObject skinJson;
        private final int id;

        public SkinIcon(JsonObject skinJson) {
            this.skinJson = skinJson;
            this.id = skinJson.get("id").getAsInt();
        }

        public JsonObject getSkinJson() {
            return this.skinJson;
        }

        public void drawIcon(int x, int y, int mouseX, int mouseY, int iconSize, boolean showName) {
            int backgroundColour = 0x22AAAAAA;
            int borderColour = 0x22FFFFFF;
            if (this.mouseOver(x, y, mouseX, mouseY, iconSize)) {
                backgroundColour = -1065912559;
                borderColour = -863467503;
            }
            ModRenderHelper.enableScissorScaled(x, y, iconSize, iconSize);
            Gui.func_73734_a((int)x, (int)y, (int)(x + iconSize), (int)(y + iconSize), (int)backgroundColour);
            Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + iconSize), (int)borderColour);
            Gui.func_73734_a((int)x, (int)y, (int)(x + iconSize - 1), (int)(y + 1), (int)borderColour);
            Gui.func_73734_a((int)(x + 1), (int)(y + iconSize - 1), (int)(x + iconSize), (int)(y + iconSize), (int)borderColour);
            Gui.func_73734_a((int)(x + iconSize - 1), (int)y, (int)(x + iconSize + iconSize), (int)(y + iconSize - 1), (int)borderColour);
            SkinIdentifier identifier = new SkinIdentifier(0, null, this.id, null);
            Skin skin = ClientSkinCache.INSTANCE.getSkin(identifier);
            if (skin != null) {
                if (showName) {
                    String name = this.skinJson.get("name").getAsString();
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    int size = fontRenderer.func_78256_a(skin.getCustomName());
                    List list = fontRenderer.func_78271_c(name, iconSize - 2);
                    int textY = y + iconSize;
                    fontRenderer.func_78279_b(name, x + 1, textY -= fontRenderer.field_78288_b * list.size(), iconSize - 2, -1118482);
                }
                Minecraft.func_71410_x().field_71446_o.func_110577_a(skin.getSkinType().getIcon());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Gui.func_152125_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)((int)((float)iconSize / 4.0f)), (int)((int)((float)iconSize / 4.0f)), (float)16.0f, (float)16.0f);
                float scale = iconSize / 2;
                GlStateManager.func_179094_E();
                GlStateManager.func_179123_a();
                if (showName) {
                    GlStateManager.func_179109_b((float)(x + iconSize / 2), (float)(y + iconSize / 2 - 4), (float)200.0f);
                } else {
                    GlStateManager.func_179109_b((float)(x + iconSize / 2), (float)(y + iconSize / 2), (float)200.0f);
                }
                GlStateManager.func_179152_a((float)-10.0f, (float)10.0f, (float)10.0f);
                if (this.mouseOver(x, y, mouseX, mouseY, iconSize)) {
                    GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                }
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                float rotation = (float)((double)System.currentTimeMillis() / 10.0 % 360.0);
                GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                RenderHelper.func_74520_c();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179133_A();
                GlStateManager.func_179119_h();
                GlStateManager.func_179108_z();
                GlStateManager.func_179142_g();
                ModRenderHelper.enableAlphaBlend();
                GlStateManager.func_179126_j();
                SkinItemRenderHelper.renderSkinAsItem(skin, new SkinDescriptor(identifier), true, false, iconSize, iconSize);
                GlStateManager.func_179097_i();
                ModRenderHelper.disableAlphaBlend();
                GlStateManager.func_179133_A();
                GlStateManager.func_179119_h();
                RenderHelper.func_74518_a();
                GlStateManager.func_179117_G();
                GlStateManager.func_179099_b();
                GlStateManager.func_179121_F();
            } else {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
                int speed = 60;
                int frames = 18;
                int frame = (int)(System.currentTimeMillis() / (long)speed % (long)frames);
                int u = MathHelper.func_76141_d((float)(frame / 9));
                int v = frame - u * 9;
                Gui.func_152125_a((int)(x + 8), (int)(y + 8), (float)(u * 28), (float)(v * 28), (int)27, (int)27, (int)(iconSize - 16), (int)(iconSize - 16), (float)256.0f, (float)256.0f);
            }
            ModRenderHelper.disableScissor();
        }

        public boolean mouseOver(int x, int y, int mouseX, int mouseY, int iconSize) {
            return mouseX >= x & mouseY >= y & mouseX < x + iconSize & mouseY < y + iconSize;
        }
    }
}

