/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import java.awt.Point;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTabController
extends GuiButtonExt {
    private static final ResourceLocation TEXTURE_TABS = new ResourceLocation("armourers_workshop:textures/gui/_controls/tabs.png");
    private final ResourceLocation textureIcons;
    private GuiScreen parent;
    private boolean fullscreen;
    private int activeTab = -1;
    private ArrayList<GuiTab> tabs = new ArrayList();
    private int tabSpacing = 27;
    private boolean editMode = false;
    private int tabsPerSide = 5;

    public GuiTabController(GuiScreen parent, boolean fullscreen, int xPos, int yPos, int width, int height, ResourceLocation tabIcons) {
        super(0, xPos, yPos, width, height, "");
        this.parent = parent;
        this.fullscreen = fullscreen;
        this.textureIcons = tabIcons;
        if (!fullscreen) {
            this.tabSpacing = 25;
        }
    }

    public GuiTabController(GuiScreen parent, boolean fullscreen, ResourceLocation tabIcons) {
        this(parent, fullscreen, 0, 0, 0, 0, tabIcons);
    }

    public void setTabSpacing(int tabSpacing) {
        this.tabSpacing = tabSpacing;
    }

    public void initGui(int xPos, int yPos, int width, int height) {
        if (this.fullscreen) {
            this.field_146128_h = 0;
            this.field_146129_i = 0;
            this.field_146120_f = this.parent.field_146294_l;
            this.field_146121_g = this.parent.field_146295_m;
        } else {
            this.field_146128_h = xPos;
            this.field_146129_i = yPos;
            this.field_146120_f = width;
            this.field_146121_g = height;
        }
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setActiveTabIndex(int index) {
        this.activeTab = index < this.getTabCount() - 1 ? index : this.getTabCount() - 1;
        if (this.getTabCount() == 0) {
            this.activeTab = -1;
        }
    }

    public void addTab(GuiTab tab) {
        this.tabs.add(tab);
    }

    public void clearTabs() {
        this.tabs.clear();
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public int getActiveTabIndex() {
        return this.activeTab;
    }

    public String getActiveTabName() {
        GuiTab tab = this.getActiveTab();
        if (tab != null) {
            return tab.getName();
        }
        return "";
    }

    public GuiTab getTab(int index) {
        if (index >= 0 & index < this.tabs.size()) {
            return this.tabs.get(index);
        }
        return null;
    }

    private int getYOffSet() {
        if (!this.fullscreen) {
            return 5;
        }
        return (int)((float)this.field_146121_g / 2.0f - (float)this.tabs.size() * (float)this.tabSpacing / 2.0f);
    }

    public Point getTabPos(int index) {
        int yOffset = this.getYOffSet();
        int xOffset = -4;
        int count = 0;
        boolean movedRight = false;
        for (int i = 0; i < this.tabs.size(); ++i) {
            GuiTab tab = this.tabs.get(i);
            if (tab.visible) {
                if (i == index) {
                    return new Point(this.field_146128_h + xOffset, this.field_146129_i + count * this.tabSpacing + yOffset);
                }
                ++count;
            }
            if (!(count >= this.getTabsPerSide() & !movedRight)) continue;
            count = 0;
            xOffset += this.field_146120_f - this.tabSpacing;
            if (this.isFullscreen()) {
                xOffset += 10;
            }
            movedRight = true;
        }
        return null;
    }

    public boolean isTabLeft(int index) {
        int count = 0;
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.tabs.get((int)i).visible) continue;
            if (i == index) {
                return count < this.getTabsPerSide();
            }
            ++count;
        }
        return true;
    }

    public int getTabsPerSide() {
        return this.tabsPerSide;
    }

    public void setTabsPerSide(int count) {
        this.tabsPerSide = count;
    }

    public GuiTab getActiveTab() {
        if (this.activeTab >= 0 & this.activeTab < this.tabs.size()) {
            return this.tabs.get(this.activeTab);
        }
        return null;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            Point point = this.getTabPos(i);
            if (point == null || !this.tabs.get(i).isMouseOver(point.x, point.y, mouseX, mouseY)) continue;
            if (this.tabs.get(i).mousePress(point.x, point.y, mouseX, mouseY)) {
                this.activeTab = i;
            }
            return true;
        }
        return false;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partial) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Point point = this.getTabPos(i);
            if (point == null) continue;
            mc.field_71446_o.func_110577_a(TEXTURE_TABS);
            this.tabs.get(i).render(i, point.x, point.y, mouseX, mouseY, this.activeTab == i, this.textureIcons, this.isTabLeft(i));
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public void drawHoverText(Minecraft mc, int mouseX, int mouseY) {
        GuiTab hoverTab = null;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Point point = this.getTabPos(i);
            if (point == null || !this.tabs.get(i).isMouseOver(point.x, point.y, mouseX, mouseY)) continue;
            hoverTab = this.tabs.get(i);
        }
        if (hoverTab != null) {
            ArrayList<String> textList = new ArrayList<String>();
            textList.add(hoverTab.getName());
            GuiHelper.drawHoveringText(textList, mouseX, mouseY, mc.field_71466_p, this.parent.field_146294_l, this.parent.field_146295_m, this.field_73735_i);
        }
    }
}

