/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiIconButton;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieSession;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelHeader
extends GuiPanel {
    private static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("armourers_workshop:textures/gui/global_library/global-library.png");
    private GuiIconButton iconButtonHome;
    private GuiIconButton iconButtonFavourites;
    private GuiIconButton iconButtonMyFiles;
    private GuiIconButton iconButtonUploadSkin;
    private GuiIconButton iconButtonJoinBeta;
    private GuiIconButton iconButtonInfo;

    public GuiGlobalLibraryPanelHeader(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
    }

    @Override
    public void initGui() {
        super.initGui();
        String guiName = ((GuiGlobalLibrary)this.parent).getGuiName();
        this.buttonList.clear();
        this.iconButtonHome = new GuiIconButton(this.parent, 0, this.x + this.width - 21, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.home", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 0, 16, 16);
        this.iconButtonMyFiles = new GuiIconButton(this.parent, 2, this.x + this.width - 41, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.myFiles", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 34, 16, 16);
        this.iconButtonUploadSkin = new GuiIconButton(this.parent, 3, this.x + this.width - 61, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.uploadSkin", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 51, 16, 16);
        this.iconButtonJoinBeta = new GuiIconButton(this.parent, 4, this.x + this.width - 41, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.joinBeta", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 68, 16, 16);
        this.iconButtonInfo = new GuiIconButton(this.parent, 5, this.x + this.width - 81, this.y + 4, 18, 18, GuiHelper.getLocalizedControlName(guiName, "header.info", new Object[0]), BUTTON_TEXTURES).setIconLocation(0, 17, 16, 16);
        this.iconButtonUploadSkin.setDisableText(GuiHelper.getLocalizedControlName(guiName, "header.uploadSkinBan", new Object[0]));
        this.buttonList.add(this.iconButtonHome);
        this.buttonList.add(this.iconButtonMyFiles);
        this.buttonList.add(this.iconButtonUploadSkin);
        this.buttonList.add(this.iconButtonJoinBeta);
        this.buttonList.add(this.iconButtonInfo);
        this.betaCheckUpdate();
    }

    @Override
    public void update() {
        super.update();
        this.betaCheckUpdate();
    }

    private void betaCheckUpdate() {
        boolean inBeta = PlushieAuth.isRemoteUser();
        boolean doneBetaCheck = PlushieAuth.doneRemoteUserCheck();
        PlushieSession session = PlushieAuth.PLUSHIE_SESSION;
        this.iconButtonInfo.field_146128_h = inBeta ? this.x + this.width - 81 : this.x + this.width - 61;
        if (session.hasServerId()) {
            this.iconButtonMyFiles.field_146125_m = inBeta;
            this.iconButtonUploadSkin.field_146125_m = inBeta;
            this.iconButtonUploadSkin.field_146124_l = session.hasPermission(PermissionSystem.PlushieAction.SKIN_UPLOAD);
        } else {
            this.iconButtonMyFiles.field_146125_m = false;
            this.iconButtonUploadSkin.field_146125_m = false;
            this.iconButtonJoinBeta.field_146125_m = true;
        }
        if (doneBetaCheck) {
            this.iconButtonJoinBeta.field_146125_m = !inBeta;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.iconButtonHome) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.HOME);
            ((GuiGlobalLibrary)this.parent).panelHome.updateSkinPanels();
        }
        if (button == this.iconButtonFavourites) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.FAVOURITES);
        }
        if (button == this.iconButtonMyFiles) {
            GuiGlobalLibrary guiGlobalLibrary = (GuiGlobalLibrary)this.parent;
            int serverId = PlushieAuth.PLUSHIE_SESSION.getServerId();
            ((GuiGlobalLibrary)this.parent).panelUserSkins.clearResults();
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.USER_SKINS);
            ((GuiGlobalLibrary)this.parent).panelUserSkins.switchToUser(serverId);
        }
        if (button == this.iconButtonUploadSkin) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.UPLOAD);
        }
        if (button == this.iconButtonJoinBeta) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.JOIN_BETA);
        }
        if (button == this.iconButtonInfo) {
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.INFO);
            ((GuiGlobalLibrary)this.parent).panelInfo.updateInfo();
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        String username = "player";
        GameProfile gameProfile = this.mc.field_71439_g.func_146103_bH();
        if (gameProfile != null) {
            username = gameProfile.getName();
            GuiHelper.drawPlayerHead(this.x + 4, this.y + 4, 16, username);
            this.fontRenderer.func_78276_b(" - " + username, this.x + 24, this.y + this.height / 2 - this.fontRenderer.field_78288_b / 2, 0xAAFFAA);
        } else {
            this.fontRenderer.func_78276_b("Not logged in.", this.x + 90, this.y + this.height / 2 - this.fontRenderer.field_78288_b / 2, 0xFFAAAA);
        }
        String titleText = ((GuiGlobalLibrary)this.parent).getGuiName();
        this.func_73732_a(this.fontRenderer, GuiHelper.getLocalizedControlName(titleText, "name", new Object[0]), this.x + this.width / 2, this.y + this.height / 2 - this.fontRenderer.field_78288_b / 2, -1118482);
        super.draw(mouseX, mouseY, partialTickTime);
    }

    private void drawPlayerHead(String username) {
        ResourceLocation rl = DefaultPlayerSkin.func_177335_a();
        rl = AbstractClientPlayer.func_110311_f((String)username);
        AbstractClientPlayer.func_110304_a((ResourceLocation)rl, (String)username);
        this.mc.field_71446_o.func_110577_a(rl);
        int sourceSize = 8;
        int targetSize = 16;
        GuiGlobalLibraryPanelHeader.func_152125_a((int)(this.x + 5), (int)(this.y + 5), (float)8.0f, (float)8.0f, (int)sourceSize, (int)sourceSize, (int)targetSize, (int)targetSize, (float)64.0f, (float)32.0f);
        GuiGlobalLibraryPanelHeader.func_152125_a((int)(this.x + 4), (int)(this.y + 4), (float)40.0f, (float)8.0f, (int)sourceSize, (int)sourceSize, (int)(targetSize + 2), (int)(targetSize + 2), (float)64.0f, (float)32.0f);
    }
}

