/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiControlSkinPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelSearchResults;
import moe.plushie.armourers_workshop.common.library.global.GlobalSkinLibraryUtils;
import moe.plushie.armourers_workshop.common.library.global.PlushieUser;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskSkinListUser;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public class GuiGlobalLibraryPanelUserSkins
extends GuiGlobalLibraryPanelSearchResults {
    private int userId;

    public GuiGlobalLibraryPanelUserSkins(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
    }

    public void switchToUser(int userId) {
        this.clearResults();
        if (userId != 0) {
            this.userId = userId;
            this.fetchPage(0);
        }
    }

    @Override
    protected void resize() {
        int thisUserId = this.userId;
        this.clearResults();
        this.switchToUser(thisUserId);
    }

    @Override
    protected void fetchPage(int pageIndex) {
        if (this.downloadedPageList.contains(pageIndex)) {
            return;
        }
        this.downloadedPageList.add(pageIndex);
        ArrayList<ISkinType> skinTypes = SkinTypeRegistry.INSTANCE.getRegisteredSkinTypes();
        String searchTypes = "";
        for (int i = 0; i < skinTypes.size(); ++i) {
            searchTypes = searchTypes + skinTypes.get(i).getRegistryName();
            if (i >= skinTypes.size() - 1) continue;
            searchTypes = searchTypes + ";";
        }
        GlobalTaskSkinListUser taskSkinListUser = new GlobalTaskSkinListUser(this.userId, searchTypes, pageIndex, this.skinPanelResults.getIconCount());
        taskSkinListUser.createTaskAndRun(new FutureCallback<JsonObject>(){

            public void onSuccess(final JsonObject result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelUserSkins.this.onPageJsonDownload(result);
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        GuiControlSkinPanel.SkinIcon skinIcon;
        if (button.field_146127_k == 1) {
            this.changePage(this.currentPageIndex - 1);
        }
        if (button.field_146127_k == 2) {
            this.changePage(this.currentPageIndex + 1);
            if (this.currentPageIndex + 1 < this.totalPages) {
                this.fetchPage(this.currentPageIndex + 1);
            }
        }
        if (button == this.iconButtonSmall) {
            iconScale = 50;
            this.skinPanelResults.setIconSize(iconScale);
            this.resize();
        }
        if (button == this.iconButtonMedium) {
            iconScale = 80;
            this.skinPanelResults.setIconSize(iconScale);
            this.resize();
        }
        if (button == this.iconButtonLarge) {
            iconScale = 110;
            this.skinPanelResults.setIconSize(iconScale);
            this.resize();
        }
        if (button == this.skinPanelResults && (skinIcon = ((GuiControlSkinPanel)button).getLastPressedSkinIcon()) != null) {
            ((GuiGlobalLibrary)this.parent).panelSkinInfo.displaySkinInfo(skinIcon.getSkinJson(), GuiGlobalLibrary.Screen.USER_SKINS);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        PlushieUser plushieUser = GlobalSkinLibraryUtils.getUserInfo(this.userId);
        String username = "unknown";
        if (plushieUser != null) {
            username = plushieUser.getUsername();
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        super.draw(mouseX, mouseY, partialTickTime);
        int maxPages = this.totalPages;
        int totalSkins = this.totalResults;
        String guiName = ((GuiGlobalLibrary)this.parent).getGuiName();
        String unlocalizedName = "inventory." + "armourers_workshop".toLowerCase() + ":" + guiName + ".userSkins.results";
        String resultsText = TranslateUtils.translate(unlocalizedName, username, this.currentPageIndex + 1, maxPages, totalSkins);
        if (this.jsonCurrentPage == null) {
            resultsText = GuiHelper.getLocalizedControlName(guiName, "searchResults.label.searching", new Object[0]);
        }
        this.fontRenderer.func_78276_b(resultsText, this.x + 5, this.y + 6, -1118482);
    }
}

