/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.wardrobe.tab;

import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCheckBox;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.client.gui.style.GuiResourceManager;
import moe.plushie.armourers_workshop.client.gui.style.GuiStyle;
import moe.plushie.armourers_workshop.client.gui.wardrobe.GuiWardrobe;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTabWardrobeDisplaySettings
extends GuiTabPanel {
    private static final ResourceLocation GUI_JSON = new ResourceLocation("armourers_workshop:gui/wardrobe.json");
    private final GuiStyle guiStyle = GuiResourceManager.getGuiJsonInfo(GUI_JSON);
    private EntityPlayer entityPlayer;
    private IEntitySkinCapability skinCapability;
    private IPlayerWardrobeCap wardrobeCapability;
    private boolean[] armourOverride;
    private GuiCheckBox[] armourOverrideCheck;
    String guiName = "wardrobe.tab.display_settings";

    public GuiTabWardrobeDisplaySettings(int tabId, GuiScreen parent, EntityPlayer entityPlayer, IEntitySkinCapability skinCapability, IPlayerWardrobeCap wardrobeCapability) {
        super(tabId, parent, false);
        this.entityPlayer = entityPlayer;
        this.skinCapability = skinCapability;
        this.wardrobeCapability = wardrobeCapability;
        this.armourOverride = new boolean[4];
        for (int i = 0; i < this.armourOverride.length; ++i) {
            EntityEquipmentSlot slot = EntityEquipmentSlot.values()[i + 2];
            this.armourOverride[i] = wardrobeCapability.getArmourOverride(slot);
        }
    }

    @Override
    public void initGui(int xPos, int yPos, int width, int height) {
        super.initGui(xPos, yPos, width, height);
        this.armourOverrideCheck = new GuiCheckBox[4];
        this.armourOverrideCheck[0] = new GuiCheckBox(2, 83, 27, GuiHelper.getLocalizedControlName(this.guiName, "renderHeadArmour", new Object[0]), !this.armourOverride[3]);
        this.armourOverrideCheck[1] = new GuiCheckBox(3, 83, 47, GuiHelper.getLocalizedControlName(this.guiName, "renderChestArmour", new Object[0]), !this.armourOverride[2]);
        this.armourOverrideCheck[2] = new GuiCheckBox(4, 83, 67, GuiHelper.getLocalizedControlName(this.guiName, "renderLegArmour", new Object[0]), !this.armourOverride[1]);
        this.armourOverrideCheck[3] = new GuiCheckBox(5, 83, 87, GuiHelper.getLocalizedControlName(this.guiName, "renderFootArmour", new Object[0]), !this.armourOverride[0]);
        for (int i = 0; i < this.armourOverrideCheck.length; ++i) {
            this.armourOverrideCheck[i].setTextColour(this.guiStyle.getColour("text"));
            this.buttonList.add(this.armourOverrideCheck[i]);
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        int i;
        if (button instanceof GuiCheckBox) {
            for (i = 0; i < this.armourOverride.length; ++i) {
                this.armourOverride[i] = !this.armourOverrideCheck[3 - i].isChecked();
            }
        }
        if (button.field_146127_k >= 1) {
            for (i = 0; i < this.armourOverride.length; ++i) {
                EntityEquipmentSlot slot = EntityEquipmentSlot.values()[i + 2];
                this.wardrobeCapability.setArmourOverride(slot, this.armourOverride[i]);
            }
            this.wardrobeCapability.sendUpdateToServer();
        }
    }

    @Override
    public void drawBackgroundLayer(float partialTickTime, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawForegroundLayer(int mouseX, int mouseY, float partialTickTime) {
        super.drawForegroundLayer(mouseX, mouseY, partialTickTime);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.x), (double)(-this.y), (double)0.0);
        ((GuiWardrobe)this.parent).drawPlayerPreview(this.x, this.y, mouseX, mouseY);
        GL11.glPopMatrix();
    }
}

