/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.handler;

import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.data.type.BipedRotations;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.init.items.ItemMannequin;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import moe.plushie.armourers_workshop.utils.TrigUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MannequinPlacementHandler {
    private final ModelPlayer modelPlayerSmall = new ModelPlayer(0.0f, true);
    private final ModelPlayer modelPlayerNormal = new ModelPlayer(0.0f, false);

    public MannequinPlacementHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        this.drawMannequinBounds(event);
        this.drawMannequinPlacementGhost(event);
    }

    private void drawMannequinBounds(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = event.getPlayer().func_130014_f_();
        RayTraceResult target = event.getTarget();
        if (target != null && target.field_72313_a != RayTraceResult.Type.ENTITY) {
            return;
        }
        if (!(target.field_72308_g instanceof EntityMannequin)) {
            return;
        }
        EntityMannequin mannequin = (EntityMannequin)target.field_72308_g;
        double xOff = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double yOff = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double zOff = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        AxisAlignedBB aabb = mannequin.func_174813_aQ();
        aabb = aabb.func_72317_d(-xOff, -yOff, -zOff);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)0.1f, (float)0.1f, (float)0.1f, (float)0.75f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
    }

    private void drawMannequinPlacementGhost(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = event.getPlayer().func_130014_f_();
        RayTraceResult target = event.getTarget();
        if (target != null && target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = target.func_178782_a();
        EnumFacing facing = target.field_178784_b;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != ModItems.MANNEQUIN) {
            return;
        }
        pos = pos.func_177972_a(facing);
        double xOff = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double yOff = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double zOff = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        EntityMannequin.TextureData textureData = ItemMannequin.getTextureData(stack);
        float size = ItemMannequin.getScale(stack);
        PlayerTexture playerTexture = ClientProxy.playerTextureDownloader.getPlayerTexture(textureData);
        ModelPlayer targetModel = this.modelPlayerNormal;
        double angle = TrigUtils.getAngleDegrees(xOff, zOff, target.field_72307_f.field_72450_a, target.field_72307_f.field_72449_c) + 90.0;
        if (player.func_70093_af()) {
            int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            angle = (float)l * 22.5f + 180.0f;
        }
        if (playerTexture.isSlimModel()) {
            targetModel = this.modelPlayerSmall;
        }
        float scale = 0.0625f;
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179137_b((double)((double)((float)pos.func_177958_n() + 0.5f) - xOff), (double)((double)pos.func_177956_o() - yOff), (double)((double)((float)pos.func_177952_p() + 0.5f) - zOff));
        } else {
            GlStateManager.func_179137_b((double)(target.field_72307_f.field_72450_a - xOff), (double)((double)pos.func_177956_o() - yOff), (double)(target.field_72307_f.field_72449_c - zOff));
        }
        GlStateManager.func_179152_a((float)(15.0f * scale), (float)(-15.0f * scale), (float)(-15.0f * scale));
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        GlStateManager.func_179109_b((float)0.0f, (float)(-24.0f * scale), (float)0.0f);
        GlStateManager.func_179114_b((float)((float)angle), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179131_c((float)0.1f, (float)0.1f, (float)0.1f, (float)0.75f);
        GL11.glPolygonMode((int)1032, (int)6913);
        GL11.glLineWidth((float)1.0f);
        targetModel.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, (Entity)Minecraft.func_71410_x().field_71439_g);
        BipedRotations bipedRotations = new BipedRotations();
        bipedRotations.applyRotationsToBiped(targetModel);
        targetModel.field_78116_c.func_78785_a(scale);
        targetModel.field_78115_e.func_78785_a(scale);
        targetModel.field_178724_i.func_78785_a(scale);
        targetModel.field_178723_h.func_78785_a(scale);
        targetModel.field_178722_k.func_78785_a(scale);
        targetModel.field_178721_j.func_78785_a(scale);
        GL11.glPolygonMode((int)1032, (int)6914);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

