/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.handler;

import java.util.List;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.client.render.SkinItemRenderHelper;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class SkinPreviewHandler {
    private final ResourceLocation TEXTURE = new ResourceLocation("armourers_workshop:textures/gui/skin-preview.png");
    private SkinDescriptor lastSkinDescriptor;
    private List<String> lastList;

    public SkinPreviewHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!ConfigHandlerClient.skinPreEnabled) {
            return;
        }
        if (!ConfigHandlerClient.skinPreLocFollowMouse) {
            return;
        }
        SkinDescriptor skinDescriptor = this.lastSkinDescriptor;
        List<String> list = this.lastList;
        this.lastSkinDescriptor = null;
        this.lastList = null;
        if (skinDescriptor != null & list != null) {
            Minecraft mc = Minecraft.func_71410_x();
            float skinPreSize = ConfigHandlerClient.skinPreSize;
            int[] toolTipSize = this.getTooltipSize(list, mc.field_71462_r.field_146294_l, mc.field_71462_r.field_146295_m, event.getMouseX() + 8, event.getMouseY(), mc.field_71466_p);
            int x = (int)((float)toolTipSize[0] - skinPreSize - 28.0f);
            int y = toolTipSize[1] - 4;
            if (this.tooltipOnLeft(list, mc.field_71462_r.field_146294_l, mc.field_71462_r.field_146295_m, event.getMouseX() + 8, event.getMouseY(), mc.field_71466_p)) {
                x = toolTipSize[0] + toolTipSize[2] + 15;
            }
            if (y < 0) {
                y = 0;
            }
            if ((float)y + skinPreSize > (float)mc.field_71462_r.field_146295_m) {
                y = mc.field_71462_r.field_146295_m - (int)skinPreSize;
            }
            this.drawSkinBox(mc, x, y, skinPreSize, skinDescriptor);
        }
    }

    @SubscribeEvent
    public void onDrawScreenPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!ConfigHandlerClient.skinPreEnabled) {
            return;
        }
        if (ConfigHandlerClient.skinPreLocFollowMouse) {
            return;
        }
        SkinDescriptor skinDescriptor = this.lastSkinDescriptor;
        List<String> list = this.lastList;
        this.lastSkinDescriptor = null;
        this.lastList = null;
        if (skinDescriptor != null & list != null) {
            Minecraft mc = Minecraft.func_71410_x();
            float skinPreSize = ConfigHandlerClient.skinPreSize;
            float skinPreLocHorizontal = ConfigHandlerClient.skinPreLocHorizontal;
            float skinPreLocVertical = ConfigHandlerClient.skinPreLocVertical;
            ScaledResolution sr = new ScaledResolution(mc);
            double widthClip = sr.func_78327_c() - (double)skinPreSize;
            double heightClip = sr.func_78324_d() - (double)skinPreSize;
            int x = MathHelper.func_76143_f((double)(widthClip * (double)skinPreLocHorizontal));
            int y = MathHelper.func_76143_f((double)(heightClip * (double)skinPreLocVertical));
            this.drawSkinBox(mc, x, y, skinPreSize, skinDescriptor);
            skinDescriptor = null;
        }
    }

    private void drawSkinBox(Minecraft mc, int x, int y, float skinPreSize, SkinDescriptor skinPointer) {
        boolean skinPreDrawBackground = ConfigHandlerClient.skinPreDrawBackground;
        if (skinPreDrawBackground & ClientSkinCache.INSTANCE.isSkinInCache(skinPointer)) {
            RenderHelper.func_74518_a();
            mc.field_71446_o.func_110577_a(this.TEXTURE);
            ModRenderHelper.enableAlphaBlend();
            GuiUtils.drawContinuousTexturedBox((int)x, (int)y, (int)0, (int)0, (int)((int)skinPreSize), (int)((int)skinPreSize), (int)62, (int)62, (int)4, (float)400.0f);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)2977);
        RenderHelper.func_74520_c();
        GL11.glTranslatef((float)-10.0f, (float)-5.0f, (float)600.0f);
        GL11.glTranslatef((float)(skinPreSize / 2.0f + (float)x), (float)(skinPreSize / 2.0f + (float)y), (float)0.0f);
        GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
        GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float rotation = (float)((double)System.currentTimeMillis() / 10.0 % 360.0);
        GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        SkinItemRenderHelper.renderSkinAsItem(skinPointer, true, false, (int)skinPreSize, (int)skinPreSize);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private int[] getTooltipSize(List<String> list, int width, int height, int mouseX, int mouseY, FontRenderer font) {
        if (!list.isEmpty()) {
            int strWidth = 0;
            for (String s : list) {
                int l = font.func_78256_a(s);
                if (l <= strWidth) continue;
                strWidth = l;
            }
            int xPos = mouseX + 12;
            int yPos = mouseY - 12;
            int strHeight = 8;
            if (list.size() > 1) {
                strHeight += 2 + (list.size() - 1) * 10;
            }
            if (xPos + strWidth > width) {
                xPos -= 28 + strWidth;
            }
            if (yPos + strHeight + 6 > height) {
                yPos = height - strHeight - 6;
            }
            if (xPos < 12) {
                xPos = 12;
            }
            if (yPos < 8) {
                yPos = 8;
            }
            return new int[]{xPos, yPos, strWidth, strHeight};
        }
        return null;
    }

    private boolean tooltipOnLeft(List<String> list, int width, int height, int mouseX, int mouseY, FontRenderer font) {
        if (!list.isEmpty()) {
            int strWidth = 0;
            for (String s : list) {
                int l = font.func_78256_a(s);
                if (l <= strWidth) continue;
                strWidth = l;
            }
            int xPos = mouseX + 12;
            int yPos = mouseY - 12;
            int strHeight = 8;
            if (list.size() > 1) {
                strHeight += 2 + (list.size() - 1) * 10;
            }
            if (xPos + strWidth > width) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        if (ConfigHandlerClient.skinPreEnabled) {
            this.lastSkinDescriptor = SkinNBTHelper.getSkinDescriptorFromStack(event.getItemStack());
            this.lastList = event.getToolTip();
        }
    }
}

