/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartTypeTextured;
import moe.plushie.armourers_workshop.client.model.bake.ColouredFace;
import moe.plushie.armourers_workshop.common.SkinHelper;
import moe.plushie.armourers_workshop.common.capability.wardrobe.ExtraColours;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.utils.BitwiseUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class EntityTextureInfo {
    private static final int TEXURE_REPLACMENT_WIDTH = 64;
    private static final int TEXURE_REPLACMENT_HEIGHT = 32;
    private final int textureWidth;
    private final int textureHeight;
    private int lastEntityTextureHash;
    private int[] lastSkinHashs;
    private int[] lastDyeHashs;
    private Skin[] skins;
    private ISkinDye[] dyes;
    private ResourceLocation normalTexture;
    private ResourceLocation replacementTexture;
    private ExtraColours lastEntityColours;
    private BufferedImage bufferedEntityImage;
    private BufferedImage bufferedEntitySkinnedImage;
    private boolean needsUpdate;
    private boolean loading;

    public EntityTextureInfo() {
        this(64, 64);
    }

    public EntityTextureInfo(int width, int height) {
        int i;
        this.textureWidth = width;
        this.textureHeight = height;
        this.lastEntityTextureHash = -1;
        this.lastSkinHashs = new int[54];
        this.lastDyeHashs = new int[54];
        this.normalTexture = null;
        this.replacementTexture = null;
        for (i = 0; i < this.lastSkinHashs.length; ++i) {
            this.lastSkinHashs[i] = -1;
        }
        for (i = 0; i < this.lastDyeHashs.length; ++i) {
            this.lastDyeHashs[i] = -1;
        }
        this.lastEntityColours = ExtraColours.EMPTY_COLOUR;
        this.needsUpdate = true;
        this.loading = false;
    }

    public boolean getNeedsUpdate() {
        return this.needsUpdate;
    }

    public void updateTexture(ResourceLocation resourceLocation) {
        if (this.lastEntityTextureHash != resourceLocation.hashCode()) {
            BufferedImage buff = SkinHelper.getBufferedImageSkin(resourceLocation);
            this.bufferedEntityImage = null;
            if (buff != null) {
                this.loading = false;
                this.lastEntityTextureHash = resourceLocation.hashCode();
                this.normalTexture = resourceLocation;
                this.bufferedEntityImage = buff;
                this.needsUpdate = true;
            }
        }
        if (this.bufferedEntityImage == null) {
            this.lastEntityTextureHash = DefaultPlayerSkin.func_177335_a().hashCode();
            this.bufferedEntityImage = SkinHelper.getBufferedImageSkin(DefaultPlayerSkin.func_177335_a());
            if (this.bufferedEntityImage != null & !this.loading) {
                this.loading = true;
                this.needsUpdate = true;
            }
        }
    }

    public void updateExtraColours(IExtraColours extraColours) {
        if (!this.lastEntityColours.equals(extraColours)) {
            this.lastEntityColours = new ExtraColours(extraColours);
            this.needsUpdate = true;
        }
    }

    public void updateSkins(Skin[] skins) {
        this.skins = skins;
        for (int i = 0; i < skins.length; ++i) {
            if (skins[i] != null) {
                if (skins[i].lightHash() == this.lastSkinHashs[i]) continue;
                this.lastSkinHashs[i] = skins[i].lightHash();
                this.needsUpdate = true;
                continue;
            }
            if (this.lastSkinHashs[i] == -1) continue;
            this.lastSkinHashs[i] = -1;
            this.needsUpdate = true;
        }
    }

    public void updateDyes(ISkinDye[] dyes) {
        this.dyes = dyes;
        for (int i = 0; i < this.skins.length; ++i) {
            if (dyes[i] != null) {
                if (dyes[i].hashCode() == this.lastDyeHashs[i]) continue;
                this.lastDyeHashs[i] = dyes[i].hashCode();
                this.needsUpdate = true;
                continue;
            }
            if (this.lastDyeHashs[i] == -1) continue;
            this.lastDyeHashs[i] = -1;
            this.needsUpdate = true;
        }
    }

    public void checkTexture() {
        if (this.needsUpdate) {
            this.buildTexture();
            this.needsUpdate = false;
        }
    }

    private void buildTexture() {
        this.applyPlayerToTexture();
        this.applySkinsToTexture();
        this.createReplacmentTexture();
    }

    private void applyPlayerToTexture() {
        this.bufferedEntitySkinnedImage = SkinHelper.deepCopyBufferedImage(this.bufferedEntityImage);
    }

    private void applySkinsToTexture() {
        Skin skin;
        int i;
        for (i = 0; i < this.skins.length; ++i) {
            skin = this.skins[i];
            if (skin == null || !skin.hasPaintData()) continue;
            this.paintTexture(skin, this.dyes[i], this.bufferedEntitySkinnedImage);
        }
        for (i = 0; i < this.skins.length; ++i) {
            skin = this.skins[i];
            if (skin == null) continue;
            for (int partIndex = 0; partIndex < skin.getSkinType().getSkinParts().size(); ++partIndex) {
                ISkinPartType part = skin.getSkinType().getSkinParts().get(partIndex);
                if (!(part instanceof ISkinPartTypeTextured)) continue;
                ISkinPartTypeTextured skinPartTex = (ISkinPartTypeTextured)part;
                this.makePartBlank(skinPartTex, this.bufferedEntitySkinnedImage, skin.getProperties());
            }
        }
    }

    public void makePartBlank(ISkinPartTypeTextured skinPartTex, BufferedImage texture, SkinProperties skinProps) {
        Point posBase = skinPartTex.getTextureBasePos();
        Point posOverlay = skinPartTex.getTextureOverlayPos();
        int width = skinPartTex.getTextureModelSize().getX() * 2 + skinPartTex.getTextureModelSize().getZ() * 2;
        int height = skinPartTex.getTextureModelSize().getY() + skinPartTex.getTextureModelSize().getZ();
        for (int ix = 0; ix < width; ++ix) {
            for (int iy = 0; iy < height; ++iy) {
                if (skinPartTex.isModelOverridden(skinProps)) {
                    texture.setRGB(posBase.x + ix, posBase.y + iy, 0xFFFFFF);
                }
                if (!skinPartTex.isOverlayOverridden(skinProps)) continue;
                texture.setRGB(posOverlay.x + ix, posOverlay.y + iy, 0xFFFFFF);
            }
        }
    }

    private void paintTexture(Skin skin, ISkinDye skinDye, BufferedImage texture) {
        for (int ix = 0; ix < 64; ++ix) {
            for (int iy = 0; iy < 32; ++iy) {
                int paintColour = skin.getPaintData()[ix + iy * this.textureWidth];
                IPaintType paintType = PaintTypeRegistry.getInstance().getPaintTypeFromColour(paintColour);
                if (paintType == PaintTypeRegistry.PAINT_TYPE_NORMAL) {
                    this.paintTexture(this.bufferedEntitySkinnedImage, ix, iy, BitwiseUtils.setUByteToInt(paintColour, 0, 255));
                    continue;
                }
                if (paintType.getId() >= 1 && paintType.getId() <= 8) {
                    int dyeNumber = paintType.getId() - 1;
                    if (skinDye != null && skinDye.haveDyeInSlot(dyeNumber)) {
                        byte[] dye = skinDye.getDyeColour(dyeNumber);
                        int colour = this.dyeColour(dye, paintColour, paintType.getChannelIndex(), skin);
                        this.paintTexture(this.bufferedEntitySkinnedImage, ix, iy, colour);
                        continue;
                    }
                    this.paintTexture(this.bufferedEntitySkinnedImage, ix, iy, BitwiseUtils.setUByteToInt(paintColour, 0, 255));
                    continue;
                }
                if (paintType.getColourType() == null) continue;
                int colour = this.dyeColour(this.lastEntityColours.getColourBytes(paintType.getColourType()), paintColour, paintType.getChannelIndex(), skin);
                this.paintTexture(this.bufferedEntitySkinnedImage, ix, iy, colour);
            }
        }
    }

    private void paintTexture(BufferedImage texture, int x, int y, int rgb) {
        texture.setRGB(x, y, rgb);
        if (x < 16 & y >= 16 & y < 32) {
            if (y >= 20) {
                if (x < 12) {
                    texture.setRGB(15 + (12 - x), y + 32, rgb);
                } else {
                    texture.setRGB(27 + (4 - (x - 12)), y + 32, rgb);
                }
            } else if (x < 8) {
                texture.setRGB(15 + (8 - (x - 4)), y + 32, rgb);
            } else {
                texture.setRGB(23 + (8 - (x - 4)), y + 32, rgb);
            }
        }
        if (x >= 40 & x < 56 & y >= 16 & y < 32) {
            if (y >= 20) {
                if (x < 52) {
                    texture.setRGB(12 - (x - 40) + 31, y + 32, rgb);
                } else {
                    texture.setRGB(4 - (x - 52) + 43, y + 32, rgb);
                }
            } else if (x < 48) {
                texture.setRGB(8 - (x - 40) + 4 + 31, y + 32, rgb);
            } else {
                texture.setRGB(8 - (x - 48) + 4 + 31, y + 32, rgb);
            }
        }
    }

    private void paintMirroredPart(BufferedImage texture, int x, int y, int rgb, int width, int height, int depth, int offsetX, int offsetY) {
        if (y >= 20) {
            if (x < 12) {
                texture.setRGB(15 + (12 - x), y + 32, rgb);
            } else {
                texture.setRGB(27 + (4 - (x - 12)), y + 32, rgb);
            }
        } else {
            texture.setRGB(15 + (16 - x), y + 32, rgb);
        }
    }

    private int dyeColour(byte[] dye, int colour, int dyeIndex, Skin skin) {
        IPaintType t;
        byte r = (byte)(colour >>> 16 & 0xFF);
        byte g = (byte)(colour >>> 8 & 0xFF);
        byte b = (byte)(colour & 0xFF);
        if (dye.length > 3 && (t = PaintTypeRegistry.getInstance().getPaintTypeFormByte(dye[3])).getColourType() != null) {
            dye = this.lastEntityColours.getColourBytes(t.getColourType());
        }
        int[] average = new int[]{127, 127, 127};
        if (skin != null) {
            average = skin.getAverageDyeColour(dyeIndex);
        }
        dye = ColouredFace.dyeColour(r, g, b, dye, average);
        return -16777216 + ((dye[0] & 0xFF) << 16) + ((dye[1] & 0xFF) << 8) + (dye[2] & 0xFF);
    }

    protected void finalize() throws Throwable {
        this.deleteTexture();
        super.finalize();
    }

    public void deleteTexture() {
        final TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        if (this.replacementTexture != null) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    renderEngine.func_147645_c(EntityTextureInfo.this.replacementTexture);
                }
            });
        }
    }

    private void createReplacmentTexture() {
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        if (this.replacementTexture != null) {
            renderEngine.func_147645_c(this.replacementTexture);
        }
        SkinTextureObject sto = new SkinTextureObject(this.bufferedEntitySkinnedImage);
        this.replacementTexture = new ResourceLocation("armourers_workshop".toLowerCase(), String.valueOf(this.bufferedEntitySkinnedImage.hashCode()));
        renderEngine.func_110579_a(this.replacementTexture, (ITextureObject)sto);
    }

    public ResourceLocation preRender() {
        this.checkTexture();
        if (this.replacementTexture != null) {
            return this.replacementTexture;
        }
        return this.normalTexture;
    }

    public ResourceLocation getReplacementTexture() {
        return this.replacementTexture;
    }

    public ResourceLocation postRender() {
        return this.normalTexture;
    }

    private class SkinTextureObject
    extends AbstractTexture {
        private final BufferedImage texture;

        public SkinTextureObject(BufferedImage texture) {
            this.texture = texture;
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
            this.func_110552_b();
            TextureUtil.func_110987_a((int)this.field_110553_a, (BufferedImage)this.texture);
        }
    }
}

