/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.capability.entityskin;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.entity.ISkinnableEntity;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.inventory.ModInventory;
import moe.plushie.armourers_workshop.common.inventory.SkinInventoryContainer;
import moe.plushie.armourers_workshop.common.inventory.WardrobeInventory;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.server.MessageServerSyncSkinCap;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntitySkinCapability
implements IEntitySkinCapability,
ModInventory.IInventoryCallback {
    @CapabilityInject(value=IEntitySkinCapability.class)
    public static final Capability<IEntitySkinCapability> ENTITY_SKIN_CAP = null;
    public static final int MAX_SLOTS_PER_SKIN_TYPE = 10;
    private final Entity entity;
    private ISkinnableEntity skinnableEntity;
    private final ISkinType[] validSkinTypes;
    private final SkinInventoryContainer skinInventoryContainer;
    public boolean hideHead;
    public boolean hideChest;
    public boolean hideArmRight;
    public boolean hideArmLeft;
    public boolean hideLegLeft;
    public boolean hideLegRight;
    public boolean hideHeadOverlay;
    public boolean hideChestOverlay;
    public boolean hideArmRightOverlay;
    public boolean hideArmLeftOverlay;
    public boolean hideLegLeftOverlay;
    public boolean hideLegRightOverlay;

    public EntitySkinCapability(Entity entity, ISkinnableEntity skinnableEntity) {
        this.entity = entity;
        this.skinnableEntity = skinnableEntity;
        ArrayList<ISkinType> skinTypes = new ArrayList<ISkinType>();
        skinnableEntity.getValidSkinTypes(skinTypes);
        this.validSkinTypes = skinTypes.toArray(new ISkinType[skinTypes.size()]);
        this.skinInventoryContainer = new SkinInventoryContainer((ModInventory.IInventoryCallback)this, this.validSkinTypes, skinnableEntity);
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public SkinInventoryContainer getSkinInventoryContainer() {
        return this.skinInventoryContainer;
    }

    @Override
    public ISkinType[] getValidSkinTypes() {
        return this.validSkinTypes;
    }

    @Override
    public boolean canHoldSkinType(ISkinType skinType) {
        for (int i = 0; i < this.validSkinTypes.length; ++i) {
            if (skinType != this.validSkinTypes[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSlotCountForSkinType(ISkinType skinType) {
        if (this.canHoldSkinType(skinType)) {
            return this.skinnableEntity.getSlotsForSkinType(skinType);
        }
        return 0;
    }

    @Override
    public ISkinDescriptor getSkinDescriptor(ISkinType skinType, int slotIndex) {
        WardrobeInventory wardrobeInventory = this.skinInventoryContainer.getSkinTypeInv(skinType);
        if (wardrobeInventory != null) {
            SkinDescriptor skinDescriptor = SkinNBTHelper.getSkinDescriptorFromStack(wardrobeInventory.func_70301_a(slotIndex));
            return skinDescriptor;
        }
        return null;
    }

    @Override
    public ISkinDescriptor setSkinDescriptor(ISkinType skinType, int slotIndex, ISkinDescriptor skinDescriptor) {
        WardrobeInventory wardrobeInventory = this.skinInventoryContainer.getSkinTypeInv(skinType);
        if (wardrobeInventory != null) {
            SkinDescriptor oldSkinDescriptor = SkinNBTHelper.getSkinDescriptorFromStack(wardrobeInventory.func_70301_a(slotIndex));
            ItemStack itemStack = SkinNBTHelper.makeEquipmentSkinStack((SkinDescriptor)skinDescriptor);
            wardrobeInventory.func_70299_a(slotIndex, itemStack);
            return oldSkinDescriptor;
        }
        return null;
    }

    @Override
    public ItemStack getSkinStack(ISkinType skinType, int slotIndex) {
        WardrobeInventory wardrobeInventory = this.skinInventoryContainer.getSkinTypeInv(skinType);
        if (wardrobeInventory != null) {
            return wardrobeInventory.func_70301_a(slotIndex);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack setSkinStack(ISkinType skinType, int slotIndex, ItemStack skinStack) {
        WardrobeInventory wardrobeInventory = this.skinInventoryContainer.getSkinTypeInv(skinType);
        if (wardrobeInventory != null) {
            ItemStack oldItemStack = wardrobeInventory.func_70301_a(slotIndex);
            wardrobeInventory.func_70299_a(slotIndex, skinStack);
            return oldItemStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean setStackInNextFreeSlot(ItemStack stack) {
        IPlayerWardrobeCap wardrobeCap;
        SkinDescriptor descriptor = SkinNBTHelper.getSkinDescriptorFromStack(stack);
        if (descriptor == null) {
            return false;
        }
        ISkinType skinType = descriptor.getIdentifier().getSkinType();
        WardrobeInventory wardrobeInventory = this.skinInventoryContainer.getSkinTypeInv(skinType);
        if (wardrobeInventory == null) {
            return false;
        }
        int maxSlot = wardrobeInventory.func_70302_i_();
        if (this.entity instanceof EntityPlayer && (wardrobeCap = PlayerWardrobeCap.get((EntityPlayer)this.entity)) != null) {
            maxSlot = wardrobeCap.getUnlockedSlotsForSkinType(skinType);
        }
        for (int i = 0; i < maxSlot; ++i) {
            if (!wardrobeInventory.func_70301_a(i).func_190926_b()) continue;
            wardrobeInventory.func_70299_a(i, stack);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.skinInventoryContainer.clear();
    }

    @Override
    public void clearSkin(ISkinType skinType, int slotIndex) {
        WardrobeInventory wardrobeInventory = this.skinInventoryContainer.getSkinTypeInv(skinType);
        if (wardrobeInventory != null) {
            wardrobeInventory.func_70304_b(slotIndex);
        }
    }

    @Override
    public void setInventorySlotContents(IInventory inventory, int slotId, ItemStack stack) {
    }

    @Override
    public void dirty() {
        if (!this.entity.func_130014_f_().field_72995_K) {
            this.syncToAllTracking();
        }
    }

    private MessageServerSyncSkinCap getUpdateMessage() {
        NBTTagCompound compound = (NBTTagCompound)ENTITY_SKIN_CAP.getStorage().writeNBT(ENTITY_SKIN_CAP, (Object)this, null);
        return new MessageServerSyncSkinCap(this.entity.func_145782_y(), compound);
    }

    @Override
    public void syncToPlayer(EntityPlayerMP entityPlayer) {
        PacketHandler.networkWrapper.sendTo((IMessage)this.getUpdateMessage(), entityPlayer);
    }

    @Override
    public void syncToAllTracking() {
        PacketHandler.networkWrapper.sendToAllTracking((IMessage)this.getUpdateMessage(), this.entity);
    }

    public static IEntitySkinCapability get(Entity entity) {
        return (IEntitySkinCapability)entity.getCapability(ENTITY_SKIN_CAP, null);
    }
}

