/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.capability.wardrobe;

import java.util.Arrays;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;

public class ExtraColours
implements IExtraColours {
    public static final int COLOUR_NONE = 0;
    public static final ExtraColours EMPTY_COLOUR = new ExtraColours();
    public final int[] extraColoursArray = new int[IExtraColours.ExtraColourType.values().length];

    public ExtraColours(IExtraColours extraColours) {
        for (int i = 0; i < IExtraColours.ExtraColourType.values().length; ++i) {
            this.setColour(IExtraColours.ExtraColourType.values()[i], extraColours.getColour(IExtraColours.ExtraColourType.values()[i]));
        }
    }

    public ExtraColours() {
        for (IExtraColours.ExtraColourType type : IExtraColours.ExtraColourType.values()) {
            this.setColour(type, 0);
        }
    }

    @Override
    public int getColour(IExtraColours.ExtraColourType type) {
        return this.extraColoursArray[type.ordinal()];
    }

    @Override
    public byte[] getColourBytes(IExtraColours.ExtraColourType type) {
        return PaintingHelper.intToBytes(this.extraColoursArray[type.ordinal()]);
    }

    @Override
    public void setColour(IExtraColours.ExtraColourType type, int trgb) {
        this.extraColoursArray[type.ordinal()] = trgb;
    }

    @Override
    public void setColourBytes(IExtraColours.ExtraColourType type, byte[] rgbt) {
        this.extraColoursArray[type.ordinal()] = PaintingHelper.bytesToInt(rgbt);
    }

    public int hashCode() {
        int prime = 193;
        return 193 * Arrays.hashCode(this.extraColoursArray);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtraColours other = (ExtraColours)obj;
        return Arrays.equals(this.extraColoursArray, other.extraColoursArray);
    }

    static {
        for (int i = 0; i < IExtraColours.ExtraColourType.values().length; ++i) {
            EMPTY_COLOUR.setColour(IExtraColours.ExtraColourType.values()[i], 0);
        }
    }
}

