/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.blocks;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import java.util.UUID;
import moe.plushie.armourers_workshop.client.render.item.RenderItemMannequin;
import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.Contributors;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import moe.plushie.armourers_workshop.common.init.blocks.AbstractModBlockContainer;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.init.items.block.ItemBlockMannequin;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityMannequin;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.UtilItems;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockMannequin
extends AbstractModBlockContainer {
    public static final PropertyEnum<EnumPartType> STATE_PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    public static final PropertyInteger STATE_ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    private static final AxisAlignedBB MANNEQUIN_AABB = new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, (double)0.9f, (double)0.9f);
    private static final DamageSource VIC_DAMAGE = new DamageSource("victorious");
    private static final GameProfile VIC_PROFILE = new GameProfile(UUID.fromString("b027a4f4-d480-426c-84a3-a9cb029f4b72"), "VicNightfall");
    private static final GameProfile GAROAM_PROFILE = new GameProfile(UUID.fromString("31873a23-125e-4752-8607-0f1c3cb22c84"), "Garoam");
    private static final String TAG_OWNER = "owner";
    private static final String TAG_IMAGE_URL = "imageUrl";
    private final boolean isValentins;

    public BlockMannequin() {
        super("mannequin", Material.field_151594_q, SoundType.field_185852_e, true);
        this.func_149713_g(0);
        this.isValentins = ModHolidays.VALENTINES.isHolidayActive();
        this.setSortPriority(199);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(STATE_PART, (Comparable)((Object)EnumPartType.BOTTOM)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE_PART, STATE_ROTATION});
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177229_b(STATE_PART) == EnumPartType.TOP) {
            return 1;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            case 0: {
                return this.field_176227_L.func_177621_b().func_177226_a(STATE_PART, (Comparable)((Object)EnumPartType.BOTTOM));
            }
            case 1: {
                return this.field_176227_L.func_177621_b().func_177226_a(STATE_PART, (Comparable)((Object)EnumPartType.TOP));
            }
        }
        return this.func_176223_P();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityMannequin te = this.getTileEntity(worldIn, pos, TileEntityMannequin.class);
        if (te != null) {
            state = state.func_177226_a((IProperty)STATE_ROTATION, (Comparable)te.PROP_ROTATION.get());
        }
        return state;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityMannequin te;
        if (!worldIn.field_72995_K && (te = this.getTileEntity((IBlockAccess)worldIn, pos, TileEntityMannequin.class)) != null) {
            te.disableSync();
            BlockUtils.dropInventoryBlocks(worldIn, te, pos);
            UtilItems.spawnItemInWorld(worldIn, pos, this.createItemStackFromTile(te));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ItemStack getStackWithTexture(PlayerTexture playerTexture) {
        ItemStack result = new ItemStack((Block)this);
        result.func_77982_d(new NBTTagCompound());
        playerTexture.writeToNBT(result.func_77978_p());
        return result;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(STATE_PART) == EnumPartType.BOTTOM) {
            return new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, (double)1.9f, (double)0.9f);
        }
        if (state.func_177229_b(STATE_PART) == EnumPartType.TOP) {
            return new AxisAlignedBB((double)0.1f, -1.0, (double)0.1f, (double)0.9f, (double)0.9f, (double)0.9f);
        }
        return MANNEQUIN_AABB;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityMannequin te = this.getTileEntity((IBlockAccess)worldIn, pos, TileEntityMannequin.class);
        if (te != null) {
            int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            te.PROP_ROTATION.set(l);
            if (!worldIn.field_72995_K && stack.func_77942_o()) {
                NBTTagCompound compound = stack.func_77978_p();
                GameProfile gameProfile = null;
                if (compound.func_150297_b(TAG_OWNER, 10)) {
                    gameProfile = NBTUtil.func_152459_a((NBTTagCompound)compound.func_74775_l(TAG_OWNER));
                    te.PROP_OWNER.set(gameProfile);
                }
                if (compound.func_150297_b(TAG_IMAGE_URL, 8)) {
                    te.PROP_IMAGE_URL.set(compound.func_74779_i(TAG_IMAGE_URL));
                }
            }
        }
        worldIn.func_175656_a(pos.func_177972_a(EnumFacing.UP), state.func_177226_a(STATE_PART, (Comparable)((Object)EnumPartType.TOP)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        block6: {
            Contributors.Contributor contributor;
            TileEntityMannequin te;
            if (this.isTopOfMannequin((IBlockAccess)worldIn, pos)) break block6;
            ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
            if (this.isValentins && rand.nextFloat() * 100.0f > 75.0f) {
                Particle particle = particleManager.func_178927_a(EnumParticleTypes.HEART.func_179348_c(), (double)((float)pos.func_177958_n() - 0.2f + rand.nextFloat() * 0.6f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() - 0.2f + rand.nextFloat() * 0.6f), 0.0, 0.0, 0.0, null);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
            }
            if ((te = this.getTileEntity((IBlockAccess)worldIn, pos, TileEntityMannequin.class)) != null && te.PROP_RENDER_EXTRAS.get().booleanValue() && (contributor = Contributors.INSTANCE.getContributor(te.PROP_OWNER.get())) != null & te.PROP_VISIBLE.get()) {
                if (contributor.uuid.equals(GAROAM_PROFILE.getId())) {
                    for (int i = 0; i < 10; ++i) {
                        Particle particle = particleManager.func_178927_a(EnumParticleTypes.HEART.func_179348_c(), (double)((float)(pos.func_177958_n() - 1) + rand.nextFloat() * 3.0f), (double)pos.func_177956_o(), (double)((float)(pos.func_177952_p() - 1) + rand.nextFloat() * 3.0f), 0.0, 0.0, 0.0, null);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
                    }
                } else {
                    for (int i = 0; i < 6; ++i) {
                        Particle particle = particleManager.func_178927_a(EnumParticleTypes.SPELL.func_179348_c(), (double)((float)(pos.func_177958_n() - 1) + rand.nextFloat() * 3.0f), (double)pos.func_177956_o(), (double)((float)(pos.func_177952_p() - 1) + rand.nextFloat() * 3.0f), 0.0, 0.0, 0.0, null);
                        particle.func_70538_b((float)(contributor.r & 0xFF) / 255.0f, (float)(contributor.g & 0xFF) / 255.0f, (float)(contributor.b & 0xFF) / 255.0f);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
                    }
                }
            }
        }
    }

    public void convertToEntity(World world, BlockPos pos) {
        if (this.isTopOfMannequin((IBlockAccess)world, pos)) {
            IBlockState state = world.func_180495_p(pos = pos.func_177972_a(EnumFacing.DOWN));
            if (state.func_177230_c() == this) {
                ((BlockMannequin)state.func_177230_c()).convertToEntity(world, pos);
            }
            return;
        }
        TileEntityMannequin tileEntity = this.getTileEntity((IBlockAccess)world, pos, TileEntityMannequin.class);
        if (tileEntity != null) {
            EntityMannequin.TextureData textureData = new EntityMannequin.TextureData();
            if (tileEntity.PROP_OWNER.get() != null && tileEntity.PROP_TEXTURE_TYPE.get() == TextureType.USER) {
                textureData = new EntityMannequin.TextureData(tileEntity.PROP_OWNER.get());
            }
            if (!StringUtils.func_151246_b((String)tileEntity.PROP_IMAGE_URL.get()) && tileEntity.PROP_TEXTURE_TYPE.get() == TextureType.URL) {
                textureData = new EntityMannequin.TextureData(tileEntity.PROP_IMAGE_URL.get());
            }
            float offsetX = tileEntity.PROP_OFFSET_X.get().floatValue();
            float offsetY = tileEntity.PROP_OFFSET_Y.get().floatValue();
            float offsetZ = tileEntity.PROP_OFFSET_Z.get().floatValue();
            EntityMannequin entityMannequin = new EntityMannequin(world);
            entityMannequin.func_70107_b((float)pos.func_177958_n() + 0.5f + offsetX, (float)pos.func_177956_o() + offsetY, (float)pos.func_177952_p() + 0.5f + offsetZ);
            entityMannequin.setRotation((float)tileEntity.PROP_ROTATION.get().intValue() * 22.5f + 180.0f);
            world.func_72838_d((Entity)entityMannequin);
            entityMannequin.setTextureData(textureData, true);
            world.func_175713_t(pos);
            world.func_175698_g(pos);
            if (world.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c() == this) {
                world.func_175698_g(pos.func_177972_a(EnumFacing.UP));
            }
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        TileEntityMannequin te = this.getTileEntity(worldIn, pos, TileEntityMannequin.class);
        if (te != null && te instanceof TileEntityMannequin && te.PROP_NOCLIP.get().booleanValue()) {
            return field_185506_k;
        }
        return blockState.func_185900_c(worldIn, pos);
    }

    public boolean isTopOfMannequin(IBlockAccess blockAccess, BlockPos pos) {
        IBlockState state = blockAccess.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return false;
        }
        return state.func_177229_b(STATE_PART) == EnumPartType.TOP;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntityMannequin te = this.getTileEntity((IBlockAccess)world, pos, TileEntityMannequin.class);
        if (te != null) {
            int rotation = te.PROP_ROTATION.get();
            if (++rotation > 15) {
                rotation = 0;
            }
            te.PROP_ROTATION.set(rotation);
        }
        return true;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
        if (!this.isTopOfMannequin((IBlockAccess)worldIn, pos)) {
            return;
        }
        if (entityLiving.field_70163_u != (double)pos.func_177956_o() + (double)0.9f) {
            return;
        }
        if (entityLiving.field_70165_t < (double)((float)pos.func_177958_n() + 0.2f) | entityLiving.field_70165_t > (double)((float)pos.func_177958_n() + 0.8f)) {
            return;
        }
        if (entityLiving.field_70161_v < (double)((float)pos.func_177952_p() + 0.2f) | entityLiving.field_70161_v > (double)((float)pos.func_177952_p() + 0.8f)) {
            return;
        }
        TileEntityMannequin te = this.getTileEntity((IBlockAccess)worldIn, pos, TileEntityMannequin.class);
        if (te != null && te.PROP_OWNER.get() != null && te.PROP_OWNER.get().getId() != null && te.PROP_OWNER.get().getId().equals(VIC_PROFILE.getId())) {
            entityLiving.func_70097_a(VIC_DAMAGE, 2.0f);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityMannequin te = this.getTileEntity((IBlockAccess)world, pos, TileEntityMannequin.class);
        return this.createItemStackFromTile(te);
    }

    private ItemStack createItemStackFromTile(TileEntityMannequin te) {
        ItemStack stack = new ItemStack((Block)this, 1);
        if (te != null) {
            if (te.PROP_OWNER.get() != null) {
                NBTTagCompound profileTag = new NBTTagCompound();
                NBTUtil.func_180708_a((NBTTagCompound)profileTag, (GameProfile)te.PROP_OWNER.get());
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74782_a(TAG_OWNER, (NBTBase)profileTag);
            }
            if (!StringUtils.func_151246_b((String)te.PROP_IMAGE_URL.get())) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74778_a(TAG_IMAGE_URL, te.PROP_IMAGE_URL.get());
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.isTopOfMannequin((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(EnumFacing.DOWN);
        }
        if (!playerIn.func_175151_a(pos, facing, playerIn.func_184586_b(hand))) {
            return false;
        }
        this.openGui(playerIn, EnumGuiId.MANNEQUIN, worldIn, pos, state, facing);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.isTopOfMannequin((IBlockAccess)worldIn, pos)) {
            if (worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c() != this) {
            worldIn.func_175698_g(pos);
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state.func_177229_b(STATE_PART) == EnumPartType.BOTTOM) {
            return new TileEntityMannequin();
        }
        return null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void registerItemBlock(IForgeRegistry<Item> registry) {
        registry.register(new ItemBlockMannequin((Block)this).setRegistryName(this.getRegistryName()));
    }

    @Override
    public <T extends TileEntity> T getTileEntity(IBlockAccess blockAccess, BlockPos pos, Class<T> type) {
        if (this.isTopOfMannequin(blockAccess, pos)) {
            pos = pos.func_177972_a(EnumFacing.DOWN);
        }
        return super.getTileEntity(blockAccess, pos, type);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        super.registerModels();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{STATE_ROTATION, STATE_PART}).func_178441_a());
        Item.func_150898_a((Block)this).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RenderItemMannequin());
    }

    public static enum EnumPartType implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

