/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items.paintingtool;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.init.sounds.ModSounds;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientToolPaintBlock;
import moe.plushie.armourers_workshop.common.painting.IBlockPainter;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.tool.IConfigurableTool;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOption;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOptions;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import moe.plushie.armourers_workshop.common.world.undo.UndoManager;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.UtilColour;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShadeNoiseTool
extends AbstractModItem
implements IConfigurableTool,
IBlockPainter {
    public ItemShadeNoiseTool() {
        super("shade-noise-tool");
        this.func_77637_a(ArmourersWorkshop.TAB_PAINTING_TOOLS);
        this.setSortPriority(16);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (state.func_177230_c() instanceof IPantableBlock) {
            if (!worldIn.field_72995_K) {
                UndoManager.begin(player);
            }
            if (((Boolean)ToolOptions.FULL_BLOCK_MODE.getValue(stack)).booleanValue()) {
                for (int i = 0; i < 6; ++i) {
                    this.usedOnBlockSide(stack, player, worldIn, pos, state.func_177230_c(), EnumFacing.values()[i], facing == EnumFacing.values()[i]);
                }
            } else {
                this.usedOnBlockSide(stack, player, worldIn, pos, state.func_177230_c(), facing, true);
            }
            if (!worldIn.field_72995_K) {
                UndoManager.end(player);
                if (((Boolean)ToolOptions.FULL_BLOCK_MODE.getValue(stack)).booleanValue()) {
                    worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.NOISE, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.2f + 0.9f);
                } else {
                    worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.NOISE, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.2f + 1.5f);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (state.func_177230_c() == ModBlocks.ARMOURER & player.func_70093_af()) {
            TileEntity te;
            if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileEntityArmourer) {
                ((TileEntityArmourer)te).toolUsedOnArmourer(this, worldIn, stack, player);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void usedOnBlockSide(ItemStack stack, EntityPlayer player, World world, BlockPos pos, Block block, EnumFacing face, boolean spawnParticles) {
        int intensity = (Integer)ToolOptions.INTENSITY.getValue(stack);
        IPantableBlock worldColourable = (IPantableBlock)block;
        if (worldColourable.isRemoteOnly((IBlockAccess)world, pos, face) & world.field_72995_K) {
            byte[] rgbt = new byte[4];
            int oldColour = worldColourable.getColour((IBlockAccess)world, pos, face);
            IPaintType oldPaintType = worldColourable.getPaintType((IBlockAccess)world, pos, face);
            Color c = UtilColour.addShadeNoise(new Color(oldColour), intensity);
            rgbt[0] = (byte)c.getRed();
            rgbt[1] = (byte)c.getGreen();
            rgbt[2] = (byte)c.getBlue();
            rgbt[3] = (byte)oldPaintType.getId();
            if (block == ModBlocks.BOUNDING_BOX && oldPaintType == PaintTypeRegistry.PAINT_TYPE_NONE) {
                rgbt[3] = (byte)PaintTypeRegistry.PAINT_TYPE_NORMAL.getId();
            }
            MessageClientToolPaintBlock message = new MessageClientToolPaintBlock(pos, face, rgbt);
            PacketHandler.networkWrapper.sendToServer((IMessage)message);
        } else if (!worldColourable.isRemoteOnly((IBlockAccess)world, pos, face) & !world.field_72995_K) {
            int oldColour = worldColourable.getColour((IBlockAccess)world, pos, face);
            byte oldPaintType = (byte)worldColourable.getPaintType((IBlockAccess)world, pos, face).getId();
            int newColour = UtilColour.addShadeNoise(new Color(oldColour), intensity).getRGB();
            UndoManager.blockPainted(player, world, pos, oldColour, oldPaintType, face);
            ((IPantableBlock)block).setColour((IBlockAccess)world, pos, newColour, face);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af()) {
            if (worldIn.field_72995_K) {
                playerIn.openGui((Object)ArmourersWorkshop.getInstance(), EnumGuiId.TOOL_OPTIONS.ordinal(), worldIn, 0, 0, 0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int intensity = (Integer)ToolOptions.INTENSITY.getValue(stack);
        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.intensity", intensity));
        tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.openSettings"));
    }

    @Override
    public void getToolOptions(ArrayList<ToolOption<?>> toolOptionList) {
        toolOptionList.add(ToolOptions.FULL_BLOCK_MODE);
        toolOptionList.add(ToolOptions.INTENSITY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (((Boolean)ToolOptions.FULL_BLOCK_MODE.getValue(stack)).booleanValue()) {
                    return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemShadeNoiseTool.this.func_77658_a()), "normal");
                }
                return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemShadeNoiseTool.this.func_77658_a() + "-small"), "normal");
            }
        });
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a()), "normal"), new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a() + "-small"), "normal")});
    }
}

