/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.inventory;

import java.awt.Point;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinProperty;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartTypeTextured;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.init.items.ItemSkin;
import moe.plushie.armourers_workshop.common.inventory.ModTileContainer;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotOutput;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotSkin;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiButton;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperty;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityOutfitMaker;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerOutfitMaker
extends ModTileContainer<TileEntityOutfitMaker>
implements MessageClientGuiButton.IButtonPress {
    private int indexSkinsStart = 0;
    private int indexSkinsEnd = 0;

    public ContainerOutfitMaker(EntityPlayer entityPlayer, TileEntityOutfitMaker tileEntity) {
        super(entityPlayer.field_71071_by, tileEntity);
        ISkinType[] skinTypes = new ISkinType[]{SkinTypeRegistry.skinHead, SkinTypeRegistry.skinChest, SkinTypeRegistry.skinLegs, SkinTypeRegistry.skinFeet, SkinTypeRegistry.skinWings};
        this.addPlayerSlots(8, 158);
        this.func_75146_a(new SlotOutput(tileEntity, 1, 148, 88));
        this.indexSkinsEnd = this.indexSkinsStart = this.getPlayerInvEndIndex() + 1;
        for (int skinIndex = 0; skinIndex < skinTypes.length; ++skinIndex) {
            for (int i = 0; i < 4; ++i) {
                this.func_75146_a(new SlotSkin(skinTypes[skinIndex], tileEntity, skinIndex + i * 5 + 2, 36 + skinIndex * 20, 58 + i * 20));
                ++this.indexSkinsEnd;
            }
        }
    }

    private void loadOutfit() {
    }

    private void saveOutfit(EntityPlayer player) {
        ArrayList<SkinPart> skinParts = new ArrayList<SkinPart>();
        SkinProperties skinProperties = new SkinProperties();
        String partIndexs = "";
        int[] paintData = null;
        int skinIndex = 0;
        for (int i = 2; i < ((TileEntityOutfitMaker)this.tileEntity).func_70302_i_(); ++i) {
            Object part;
            int partIndex;
            Skin skin;
            ItemStack stack = ((TileEntityOutfitMaker)this.tileEntity).func_70301_a(i);
            SkinDescriptor descriptor = SkinNBTHelper.getSkinDescriptorFromStack(stack);
            if (descriptor == null || (skin = CommonSkinCache.INSTANCE.getSkin(descriptor)) == null) continue;
            for (partIndex = 0; partIndex < skin.getPartCount(); ++partIndex) {
                part = skin.getParts().get(partIndex);
                skinParts.add((SkinPart)part);
            }
            if (skin.hasPaintData()) {
                if (paintData == null) {
                    paintData = new int[2048];
                }
                for (partIndex = 0; partIndex < skin.getSkinType().getSkinParts().size(); ++partIndex) {
                    part = skin.getSkinType().getSkinParts().get(partIndex);
                    if (!(part instanceof ISkinPartTypeTextured)) continue;
                    ISkinPartTypeTextured texType = (ISkinPartTypeTextured)part;
                    paintData = this.paintPart(texType, paintData, skin.getPaintData());
                }
            }
            partIndexs = partIndexs.isEmpty() ? String.valueOf(skinParts.size()) : partIndexs + ":" + String.valueOf(skinParts.size());
            for (ISkinProperty<?> prop : skin.getSkinType().getProperties()) {
                SkinProperty p = (SkinProperty)prop;
                if (p.getKey().startsWith("wings")) {
                    p.setValue(skinProperties, p.getValue(skin.getProperties()), skinIndex);
                    continue;
                }
                p.setValue(skinProperties, p.getValue(skin.getProperties()));
            }
            ++skinIndex;
        }
        if (!skinParts.isEmpty()) {
            SkinProperties.PROP_OUTFIT_PART_INDEXS.setValue(skinProperties, partIndexs);
            SkinProperties.PROP_ALL_AUTHOR_NAME.setValue(skinProperties, player.func_70005_c_());
            if (player.func_146103_bH() != null && player.func_146103_bH().getId() != null) {
                SkinProperties.PROP_ALL_AUTHOR_UUID.setValue(skinProperties, player.func_146103_bH().getId().toString());
            }
            SkinProperties.PROP_ALL_CUSTOM_NAME.setValue(skinProperties, ((TileEntityOutfitMaker)this.tileEntity).PROP_OUTFIT_NAME.get());
            SkinProperties.PROP_ALL_FLAVOUR_TEXT.setValue(skinProperties, ((TileEntityOutfitMaker)this.tileEntity).PROP_OUTFIT_FLAVOUR.get());
            Skin skin = new Skin(skinProperties, SkinTypeRegistry.skinOutfit, paintData, skinParts);
            CommonSkinCache.INSTANCE.addEquipmentDataToCache(skin, null);
            ItemStack skinStack = SkinNBTHelper.makeEquipmentSkinStack(new SkinDescriptor(skin));
            ((TileEntityOutfitMaker)this.tileEntity).func_70299_a(1, skinStack);
        }
    }

    private int[] paintPart(ISkinPartTypeTextured texType, int[] desPaint, int[] srcPaint) {
        int textureWidth = 64;
        int textureHeight = 32;
        Point pos = texType.getTextureSkinPos();
        int width = texType.getTextureModelSize().getX() * 2 + texType.getTextureModelSize().getZ() * 2;
        int height = texType.getTextureModelSize().getY() + texType.getTextureModelSize().getZ();
        for (int ix = 0; ix < width; ++ix) {
            for (int iy = 0; iy < height; ++iy) {
                int x = pos.x + ix;
                int y = pos.y + iy;
                byte[] rgbt = PaintingHelper.intToBytes(srcPaint[x + y * textureWidth]);
                if ((rgbt[3] & 0xFF) == PaintTypeRegistry.PAINT_TYPE_NONE.getId()) continue;
                desPaint[x + y * textureWidth] = srcPaint[x + y * textureWidth];
            }
        }
        return desPaint;
    }

    @Override
    protected ItemStack transferStackFromPlayer(EntityPlayer playerIn, int index) {
        Slot slot = this.func_75139_a(index);
        if (slot.func_75216_d()) {
            Slot targetSlot;
            int i;
            ItemStack stack = slot.func_75211_c();
            ItemStack result = stack.func_77946_l();
            boolean slotted = false;
            if (stack.func_77973_b() instanceof ItemSkin & SkinNBTHelper.stackHasSkinData(stack)) {
                for (i = this.indexSkinsStart; i < this.indexSkinsEnd; ++i) {
                    targetSlot = this.func_75139_a(i);
                    if (!targetSlot.func_75214_a(stack) || !this.func_75135_a(stack, i, i + 1, false)) continue;
                    slotted = true;
                    break;
                }
            }
            if (stack.func_77973_b() instanceof ItemSkin & SkinNBTHelper.stackHasSkinData(stack)) {
                for (i = this.getPlayerInvEndIndex(); i < this.getPlayerInvEndIndex() + 1; ++i) {
                    targetSlot = this.func_75139_a(i);
                    if (!targetSlot.func_75214_a(stack) || !this.func_75135_a(stack, i, i + 1, false)) continue;
                    slotted = true;
                    break;
                }
            }
            if (!slotted) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_190901_a(playerIn, stack);
            return result;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void buttonPressed(EntityPlayer player, byte buttonId) {
        if (buttonId == 0) {
            this.loadOutfit();
        }
        if (buttonId == 1) {
            this.saveOutfit(player);
        }
    }
}

