/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.inventory.slot;

import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.inventory.ContainerDyeTable;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotHidable;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotDyeBottle
extends SlotHidable {
    private static final ResourceLocation BACKGROUND_IMAGE = new ResourceLocation("armourers_workshop", "textures/items/slot/dye-bottle.png");
    private final ContainerDyeTable container;
    private boolean locked;

    public SlotDyeBottle(IInventory inventory, int slotIndex, int xPosition, int yPosition) {
        this(inventory, slotIndex, xPosition, yPosition, null);
    }

    public SlotDyeBottle(IInventory inventory, int slotIndex, int xPosition, int yPosition, ContainerDyeTable container) {
        super(inventory, slotIndex, xPosition, yPosition);
        this.container = container;
        this.locked = false;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean func_75214_a(ItemStack stack) {
        ItemStack skinStack;
        if (this.container != null && !SkinNBTHelper.stackHasSkinData(skinStack = this.field_75224_c.func_70301_a(0))) {
            return false;
        }
        return stack.func_77973_b() == ModItems.DYE_BOTTLE && PaintingHelper.getToolHasPaint(stack);
    }

    public boolean func_82869_a(EntityPlayer player) {
        if (this.container != null) {
            if (!ConfigHandler.lockDyesOnSkins | player.field_71075_bZ.field_75098_d) {
                return true;
            }
            return !this.locked;
        }
        return true;
    }

    public void func_75218_e() {
        if (this.container != null) {
            ItemStack stack = this.func_75211_c();
            if (stack.func_190926_b()) {
                this.container.dyeRemoved(this.getSlotIndex() - 1);
            } else if (stack.func_77973_b() == ModItems.DYE_BOTTLE) {
                this.container.dyeAdded(stack, this.getSlotIndex() - 1);
            }
        }
        super.func_75218_e();
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBackgroundLocation() {
        return BACKGROUND_IMAGE;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBackgroundSprite() {
        return new DummySprite("");
    }

    @SideOnly(value=Side.CLIENT)
    private class DummySprite
    extends TextureAtlasSprite {
        protected DummySprite(String spriteName) {
            super(spriteName);
        }

        public float func_94212_f() {
            return 1.0f;
        }

        public float func_94210_h() {
            return 1.0f;
        }

        public float func_94209_e() {
            return 0.0f;
        }

        public float func_94206_g() {
            return 0.0f;
        }
    }
}

