/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.client;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.common.inventory.ContainerArmourer;
import moe.plushie.armourers_workshop.common.inventory.ContainerColourMixer;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityColourMixer;
import moe.plushie.armourers_workshop.utils.UtilColour;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageClientGuiButton
implements IMessage,
IMessageHandler<MessageClientGuiButton, IMessage> {
    byte buttonId;

    public MessageClientGuiButton() {
    }

    public MessageClientGuiButton(byte buttonId) {
        this.buttonId = buttonId;
    }

    public void fromBytes(ByteBuf buf) {
        this.buttonId = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.buttonId);
    }

    public IMessage onMessage(MessageClientGuiButton message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player == null) {
            return null;
        }
        Container container = player.field_71070_bA;
        if (container != null && container instanceof ContainerArmourer) {
            ContainerArmourer containerArmourer = (ContainerArmourer)container;
            TileEntityArmourer armourerBrain = (TileEntityArmourer)containerArmourer.getTileEntity();
            if (message.buttonId == 14) {
                containerArmourer.loadArmourItem(player);
            }
            if (message.buttonId == 7) {
                armourerBrain.toggleGuides();
            }
            if (message.buttonId == 6) {
                armourerBrain.toggleHelper();
            }
            if (message.buttonId == 11) {
                // empty if block
            }
            if (message.buttonId == 12) {
                // empty if block
            }
        }
        if (container != null && container instanceof ContainerColourMixer) {
            TileEntityColourMixer colourMixer = ((ContainerColourMixer)container).getTileEntity();
            colourMixer.setColourFamily(UtilColour.ColourFamily.values()[message.buttonId]);
        }
        if (container instanceof IButtonPress) {
            ((IButtonPress)container).buttonPressed((EntityPlayer)ctx.getServerHandler().field_147369_b, message.buttonId);
        }
        return null;
    }

    public static interface IButtonPress {
        public void buttonPressed(EntityPlayer var1, byte var2);
    }
}

