/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.server;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.common.network.ByteBufHelper;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageServerLibrarySendSkin
implements IMessage,
IMessageHandler<MessageServerLibrarySendSkin, IMessage> {
    private String fileName;
    private String filePath;
    private Skin skin;
    private SendType sendType;

    public MessageServerLibrarySendSkin() {
    }

    public MessageServerLibrarySendSkin(String fileName, String filePath, Skin skin, SendType sendType) {
        this.fileName = fileName;
        this.filePath = filePath;
        this.skin = skin;
        this.sendType = sendType;
    }

    public void toBytes(ByteBuf buf) {
        if (this.fileName != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.fileName);
        } else {
            buf.writeBoolean(false);
        }
        if (this.filePath != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filePath);
        } else {
            buf.writeBoolean(false);
        }
        this.skin.requestId = new SkinIdentifier(this.skin);
        ByteBufHelper.writeSkinToByteBuf(buf, this.skin);
        buf.writeByte(this.sendType.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.fileName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        if (buf.readBoolean()) {
            this.filePath = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.skin = ByteBufHelper.readSkinFromByteBuf(buf);
        this.sendType = SendType.values()[buf.readByte()];
    }

    public IMessage onMessage(MessageServerLibrarySendSkin message, MessageContext ctx) {
        ArmourersWorkshop.getProxy().receivedSkinFromLibrary(message.fileName, message.filePath, message.skin, message.sendType);
        return null;
    }

    public static enum SendType {
        LIBRARY_SAVE,
        GLOBAL_UPLOAD;

    }
}

