/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.network.messages.server;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.network.messages.client.DelayedMessageHandler;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class MessageServerSyncPlayerWardrobeCap
implements IMessage,
IMessageHandler<MessageServerSyncPlayerWardrobeCap, IMessage>,
DelayedMessageHandler.IDelayedMessage {
    private int entityId;
    private NBTTagCompound compound;

    public MessageServerSyncPlayerWardrobeCap(int entityId, NBTTagCompound compound) {
        this.entityId = entityId;
        this.compound = compound;
    }

    public MessageServerSyncPlayerWardrobeCap() {
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public IMessage onMessage(MessageServerSyncPlayerWardrobeCap message, MessageContext ctx) {
        DelayedMessageHandler.addDelayedMessage(message);
        return null;
    }

    @Override
    public boolean isReady() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            return Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId) != null;
        }
        return false;
    }

    @Override
    public void onDelayedMessage() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            if (entity != null && entity instanceof EntityPlayer) {
                IPlayerWardrobeCap wardrobeCapability = PlayerWardrobeCap.get((EntityPlayer)entity);
                if (wardrobeCapability != null) {
                    PlayerWardrobeCap.PLAYER_WARDROBE_CAP.getStorage().readNBT(PlayerWardrobeCap.PLAYER_WARDROBE_CAP, (Object)wardrobeCapability, null, (NBTBase)this.compound);
                }
            } else {
                ModLogger.log(Level.WARN, String.format("Failed to get entity with %d when updating IWardrobeCapability.", this.entityId));
            }
        }
    }
}

