/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.painting;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.IExtraColours;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PaintType
implements IPaintType {
    public static final ArrayList<IPaintType> PAINT_TYPES = new ArrayList();
    private final int id;
    private final int markerIndex;
    private final String name;
    private boolean hasColourChannel;
    private int channelIndex;
    private IExtraColours.ExtraColourType colourType;
    private float textureU;
    private float textureV;

    public PaintType(int id, int markerIndex, boolean hasColourChannel, String name) {
        this.id = id;
        this.markerIndex = markerIndex;
        this.hasColourChannel = hasColourChannel;
        this.name = name;
        this.textureU = 0.0f;
        this.textureV = 0.0f;
        PAINT_TYPES.add(this);
    }

    public PaintType(int id, int markerIndex, String name) {
        this(id, markerIndex, false, name);
    }

    @Override
    public IExtraColours.ExtraColourType getColourType() {
        return this.colourType;
    }

    public PaintType setExtraColourType(IExtraColours.ExtraColourType colourType) {
        this.colourType = colourType;
        return this;
    }

    @Override
    public float getU() {
        return this.textureU;
    }

    @Override
    public float getV() {
        return this.textureV;
    }

    public PaintType setTextureUV(float u, float v) {
        this.textureU = u;
        this.textureV = v;
        return this;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getMarkerIndex() {
        return this.markerIndex;
    }

    @Override
    public boolean hasAverageColourChannel() {
        return this.hasColourChannel;
    }

    @Override
    public int getChannelIndex() {
        return this.channelIndex;
    }

    @Override
    public void setColourChannelIndex(int channelIndex) {
        this.channelIndex = channelIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnlocalizedName() {
        String unlocalizedText = "paintType." + "armourers_workshop".toLowerCase() + ":";
        unlocalizedText = unlocalizedText + this.name.toLowerCase() + ".name";
        return unlocalizedText;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return TranslateUtils.translate(this.getUnlocalizedName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaintType other = (PaintType)obj;
        return this.id == other.id;
    }
}

