/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientGuiUpdateTileProperties;
import moe.plushie.armourers_workshop.common.tileentities.property.IPropertyHolder;
import moe.plushie.armourers_workshop.common.tileentities.property.TileProperty;
import moe.plushie.armourers_workshop.common.tileentities.property.TilePropertyManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class ModTileEntity
extends TileEntity
implements IPropertyHolder {
    protected final ArrayList<TileProperty<?>> tileProperties = new ArrayList();
    private boolean sync = true;

    @Override
    public void registerProperty(TileProperty<?> property) {
        this.tileProperties.add(property);
    }

    @Override
    public void onPropertyChanged(TileProperty<?> property) {
        this.func_70296_d();
        if (property.isSync()) {
            this.syncWithClients();
        }
    }

    public void readPropsFromCompound(NBTTagCompound compound) {
        for (TileProperty<?> property : this.tileProperties) {
            TilePropertyManager.INSTANCE.readPropFromCompound(property, compound);
        }
    }

    public NBTTagCompound writePropsToCompound(NBTTagCompound compound) {
        for (TileProperty<?> property : this.tileProperties) {
            TilePropertyManager.INSTANCE.writePropToCompound(property, compound);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.readPropsFromCompound(compound);
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writePropsToCompound(compound);
        return super.func_189515_b(compound);
    }

    public void enableSync() {
        this.sync = true;
    }

    public void disableSync() {
        this.sync = false;
    }

    public void syncWithClients() {
        if (!this.sync) {
            return;
        }
        if (this.func_145831_w() == null) {
            return;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.syncWithNearbyPlayers(this);
        } else {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public void dirtySync() {
        this.func_70296_d();
        this.syncWithClients();
    }

    public void syncWithNearbyPlayers(TileEntity tileEntity) {
        SPacketUpdateTileEntity packet;
        if (tileEntity.func_145831_w() == null) {
            return;
        }
        if (!(tileEntity.func_145831_w() instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)tileEntity.func_145831_w();
        PlayerChunkMapEntry chunk = worldServer.func_184164_w().func_187301_b(tileEntity.func_174877_v().func_177958_n() >> 4, tileEntity.func_174877_v().func_177952_p() >> 4);
        if (chunk != null & (packet = tileEntity.func_189518_D_()) != null) {
            chunk.func_187267_a((Packet)packet);
        }
    }

    public void updateProperty(TileProperty<?> ... property) {
        MessageClientGuiUpdateTileProperties message = new MessageClientGuiUpdateTileProperties(property);
        PacketHandler.networkWrapper.sendToServer((IMessage)message);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

