/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.skin.Rectangle3D;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.gui.GuiSkinnable;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.init.blocks.BlockSkinnable;
import moe.plushie.armourers_workshop.common.inventory.ContainerSkinnable;
import moe.plushie.armourers_workshop.common.inventory.IGuiFactory;
import moe.plushie.armourers_workshop.common.inventory.ModInventory;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.tileentities.ModTileEntity;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TileEntitySkinnable
extends ModTileEntity
implements IGuiFactory {
    private static final String TAG_HAS_SKIN = "hasSkin";
    private static final String TAG_RELATED_BLOCKS = "relatedBlocks";
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final String TAG_BLOCK_INVENTORY = "blockInventory";
    private static final String TAG_BLOCK_INVENTORY_SIZE = "blockInventorySize";
    private static final String TAG_LINKED_BLOCK = "linkedBlock";
    private static final int NBT_VERSION = 1;
    private int nbtVersion;
    private ISkinDescriptor descriptor;
    private boolean haveBlockBounds = false;
    private ArrayList<BlockPos> relatedBlocks;
    private boolean bedOccupied;
    private ModInventory inventory;
    private boolean blockInventory;
    private BlockPos linkedBlock = null;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderBounds;
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public boolean hasSkin() {
        return this.descriptor != null;
    }

    public ISkinDescriptor getSkinPointer() {
        return this.descriptor;
    }

    public void setSkinPointer(Skin skin, ISkinDescriptor descriptor) {
        this.descriptor = descriptor;
        if (skin != null & this.isParent()) {
            SkinProperties skinProps = skin.getProperties();
            if (SkinProperties.PROP_BLOCK_INVENTORY.getValue(skin.getProperties()).booleanValue()) {
                this.blockInventory = true;
                int size = SkinProperties.PROP_BLOCK_INVENTORY_WIDTH.getValue(skin.getProperties()) * SkinProperties.PROP_BLOCK_INVENTORY_HEIGHT.getValue(skin.getProperties());
                this.inventory = new ModInventory("skinnable", size, this);
            }
        }
        this.dirtySync();
    }

    public BlockPos getLinkedBlock() {
        return this.linkedBlock;
    }

    public boolean hasLinkedBlock() {
        return this.linkedBlock != null;
    }

    public void setLinkedBlock(BlockPos linkedBlock) {
        this.linkedBlock = linkedBlock;
        this.dirtySync();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.haveBlockBounds = false;
    }

    public AxisAlignedBB getBoundsForBlock(Block block, int xOffset, int yOffset, int zOffset) {
        if (this.haveBlockBounds) {
            // empty if block
        }
        if (block != null && !(block instanceof BlockSkinnable)) {
            ModLogger.log(Level.ERROR, String.format("Tile entity at X:%d Y:%d Z:%d has an invalid block.", xOffset, yOffset, zOffset));
            if (this.func_145831_w() != null) {
                // empty if block
            }
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        if (this.hasSkin()) {
            BlockSkinnable blockSkinnable = (BlockSkinnable)block;
            Skin skin = null;
            skin = this.getSkin(this.descriptor);
            if (skin != null) {
                EnumFacing dir = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockSkinnable.STATE_FACING);
                float[] bounds = TileEntitySkinnable.getBlockBounds(skin, xOffset, yOffset, zOffset, dir);
                if (bounds != null) {
                    this.minX = bounds[0];
                    this.minY = bounds[1];
                    this.minZ = bounds[2];
                    this.maxX = bounds[3];
                    this.maxY = bounds[4];
                    this.maxZ = bounds[5];
                    this.haveBlockBounds = true;
                }
                return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
            }
        }
        if (this.haveBlockBounds) {
            return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public static float[] getBlockBounds(Skin skin, int gridX, int gridY, int gridZ, EnumFacing dir) {
        float[] bounds = new float[6];
        float scale = 0.0625f;
        SkinPart skinPart = skin.getParts().get(0);
        gridX = MathHelper.func_76125_a((int)gridX, (int)0, (int)2);
        gridY = MathHelper.func_76125_a((int)gridY, (int)0, (int)2);
        gridZ = MathHelper.func_76125_a((int)gridZ, (int)0, (int)2);
        Rectangle3D rec = skinPart.getBlockBounds(gridX, gridY, gridZ);
        switch (dir) {
            case NORTH: {
                break;
            }
            case EAST: {
                rec = skinPart.getBlockBounds(2 - gridZ, gridY, gridX);
                break;
            }
            case SOUTH: {
                rec = skinPart.getBlockBounds(2 - gridX, gridY, 2 - gridZ);
                break;
            }
            case WEST: {
                rec = skinPart.getBlockBounds(gridZ, gridY, 2 - gridX);
                break;
            }
        }
        if (rec == null) {
            return null;
        }
        int x = 8 + rec.getX();
        int y = 8 - rec.getHeight() - rec.getY();
        int z = 8 - rec.getDepth() - rec.getZ();
        bounds[0] = (float)x * scale;
        bounds[1] = (float)y * scale;
        bounds[2] = (float)z * scale;
        bounds[3] = (float)(x + rec.getWidth()) * scale;
        bounds[4] = (float)(y + rec.getHeight()) * scale;
        bounds[5] = (float)(z + rec.getDepth()) * scale;
        bounds = TileEntitySkinnable.rotateBlockBounds(bounds, dir);
        return bounds;
    }

    private static float[] rotateBlockBounds(float[] bounds, EnumFacing dir) {
        float[] rotatedBounds = new float[6];
        for (int i = 0; i < bounds.length; ++i) {
            rotatedBounds[i] = bounds[i];
        }
        switch (dir) {
            case NORTH: {
                rotatedBounds[0] = 1.0f - bounds[3];
                rotatedBounds[2] = 1.0f - bounds[5];
                rotatedBounds[3] = 1.0f - bounds[0];
                rotatedBounds[5] = 1.0f - bounds[2];
                break;
            }
            case EAST: {
                rotatedBounds[0] = bounds[2];
                rotatedBounds[2] = 1.0f - bounds[3];
                rotatedBounds[3] = bounds[5];
                rotatedBounds[5] = 1.0f - bounds[0];
                break;
            }
            case WEST: {
                rotatedBounds[0] = 1.0f - bounds[5];
                rotatedBounds[2] = bounds[0];
                rotatedBounds[3] = 1.0f - bounds[2];
                rotatedBounds[5] = bounds[3];
                break;
            }
        }
        return rotatedBounds;
    }

    public boolean isBedOccupied() {
        return this.bedOccupied;
    }

    public void setBedOccupied(boolean bedOccupied) {
        this.bedOccupied = bedOccupied;
    }

    public Skin getSkin(ISkinDescriptor skinPointer) {
        if (this.func_145831_w().field_72995_K) {
            return this.getSkinClient(skinPointer);
        }
        return this.getSkinServer(skinPointer);
    }

    @SideOnly(value=Side.CLIENT)
    private Skin getSkinClient(ISkinDescriptor skinPointer) {
        return ClientSkinCache.INSTANCE.getSkin(skinPointer);
    }

    private Skin getSkinServer(ISkinDescriptor skinPointer) {
        return CommonSkinCache.INSTANCE.softGetSkin(skinPointer.getIdentifier());
    }

    public void setRelatedBlocks(ArrayList<BlockPos> relatedBlocks) {
        this.relatedBlocks = relatedBlocks;
    }

    public ArrayList<BlockPos> getRelatedBlocks() {
        return this.relatedBlocks;
    }

    public TileEntitySkinnable getParent() {
        return this;
    }

    public boolean isParent() {
        return this.getClass() == TileEntitySkinnable.class;
    }

    public ModInventory getInventory() {
        return this.inventory;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return compound;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a(TAG_HAS_SKIN, this.hasSkin());
        compound.func_74768_a("nbtVersion", 1);
        if (this.hasLinkedBlock()) {
            compound.func_74783_a(TAG_LINKED_BLOCK, new int[]{this.linkedBlock.func_177958_n(), this.linkedBlock.func_177956_o(), this.linkedBlock.func_177952_p()});
        }
        if (this.hasSkin()) {
            ((SkinDescriptor)this.descriptor).writeToCompound(compound);
            if (this.relatedBlocks != null) {
                NBTTagList list = new NBTTagList();
                for (int i = 0; i < this.relatedBlocks.size(); ++i) {
                    NBTTagCompound blockCompound = new NBTTagCompound();
                    BlockPos blockLoc = this.relatedBlocks.get(i);
                    blockCompound.func_74768_a(TAG_X, blockLoc.func_177958_n());
                    blockCompound.func_74768_a(TAG_Y, blockLoc.func_177956_o());
                    blockCompound.func_74768_a(TAG_Z, blockLoc.func_177952_p());
                    list.func_74742_a((NBTBase)blockCompound);
                }
                compound.func_74782_a(TAG_RELATED_BLOCKS, (NBTBase)list);
            }
            if (this.isParent() & this.blockInventory & this.inventory != null) {
                compound.func_74757_a(TAG_BLOCK_INVENTORY, true);
                compound.func_74768_a(TAG_BLOCK_INVENTORY_SIZE, this.inventory.func_70302_i_());
                this.inventory.saveItemsToNBT(compound);
            } else {
                compound.func_74757_a(TAG_BLOCK_INVENTORY, false);
            }
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        boolean hasSkin = compound.func_74767_n(TAG_HAS_SKIN);
        this.nbtVersion = 0;
        if (compound.func_150297_b("nbtVersion", 3)) {
            this.nbtVersion = compound.func_74762_e("nbtVersion");
        }
        if (compound.func_150297_b(TAG_LINKED_BLOCK, 11)) {
            int[] loc = compound.func_74759_k(TAG_LINKED_BLOCK);
            this.linkedBlock = new BlockPos(loc[0], loc[1], loc[2]);
        } else {
            this.linkedBlock = null;
        }
        if (hasSkin) {
            this.descriptor = new SkinDescriptor();
            ((SkinDescriptor)this.descriptor).readFromCompound(compound);
            if (compound.func_150297_b(TAG_RELATED_BLOCKS, 9)) {
                NBTTagList list = compound.func_150295_c(TAG_RELATED_BLOCKS, 10);
                this.relatedBlocks = new ArrayList();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound blockCompound = list.func_150305_b(i);
                    int x = blockCompound.func_74762_e(TAG_X);
                    int y = blockCompound.func_74762_e(TAG_Y);
                    int z = blockCompound.func_74762_e(TAG_Z);
                    BlockPos blockLoc = new BlockPos(x, y, z);
                    this.relatedBlocks.add(blockLoc);
                }
            } else {
                this.relatedBlocks = null;
            }
            this.blockInventory = false;
            this.inventory = null;
            if (this.isParent() && compound.func_150297_b(TAG_BLOCK_INVENTORY, 1) && compound.func_74767_n(TAG_BLOCK_INVENTORY)) {
                int size = 36;
                if (compound.func_150297_b(TAG_BLOCK_INVENTORY_SIZE, 3)) {
                    size = compound.func_74762_e(TAG_BLOCK_INVENTORY_SIZE);
                }
                this.blockInventory = true;
                this.inventory = new ModInventory("skinnable", size, this);
                this.inventory.loadItemsFromNBT(compound);
            }
        } else {
            this.descriptor = null;
            this.relatedBlocks = null;
            ModLogger.log(Level.WARN, String.format("Skinnable tile at X:%d Y:%d Z:%d has no skin data.", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBounds != null) return this.renderBounds;
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        if (!this.hasSkin()) return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.func_174877_v());
        Skin skin = this.getSkin(this.getSkinPointer());
        if (skin == null) return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.func_174877_v());
        if (!SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(skin.getProperties()).booleanValue()) return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.func_174877_v());
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockSkinnable)) return this.renderBounds;
        this.renderBounds = new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 3.0, 2.0).func_186670_a(this.func_174877_v());
        EnumFacing dir = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockSkinnable.STATE_FACING);
        this.renderBounds = this.renderBounds.func_72317_d((double)(-dir.func_82601_c()), 0.0, (double)(-dir.func_82599_e()));
        return this.renderBounds;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return ConfigHandlerClient.renderDistanceBlockSkin;
    }

    public void killChildren(World world) {
        if (this.relatedBlocks != null) {
            for (BlockPos pos : this.relatedBlocks) {
                ModLogger.log("Removing child: " + pos.toString());
                world.func_175698_g(pos);
            }
        }
    }

    public boolean hasCustomName() {
        Skin skin;
        if (this.hasSkin() && (skin = this.getSkin(this.getSkinPointer())) != null) {
            return !StringUtils.func_151246_b((String)skin.getCustomName());
        }
        return false;
    }

    public String getCustomName() {
        Skin skin;
        if (this.hasSkin() && (skin = this.getSkin(this.getSkinPointer())) != null) {
            return skin.getCustomName();
        }
        return "";
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, World world, BlockPos pos) {
        Skin skin = this.getSkin(this.getSkinPointer());
        if (skin != null) {
            return new ContainerSkinnable(player.field_71071_by, this, skin);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(EntityPlayer player, World world, BlockPos pos) {
        Skin skin = this.getSkin(this.getSkinPointer());
        if (skin != null) {
            return new GuiSkinnable(player.field_71071_by, this, skin);
        }
        return null;
    }
}

