/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.world.undo;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.world.undo.UndoData;
import moe.plushie.armourers_workshop.common.world.undo.UndoStep;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class PlayerUndoData {
    private ArrayList<UndoStep> undoSteps = new ArrayList();
    private boolean isPainting;
    private UndoStep currentStep = null;

    public PlayerUndoData(EntityPlayer player) {
    }

    public void begin() {
        if (this.isPainting) {
            ModLogger.log(Level.ERROR, "Last tool undo did not end correctly.");
        }
        this.isPainting = true;
        this.currentStep = new UndoStep();
    }

    public void end() {
        if (!this.isPainting) {
            ModLogger.log(Level.ERROR, "Tool ended painting with out marking the start.");
            StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
            for (int i = 1; i < stElements.length; ++i) {
                ModLogger.log(Level.ERROR, stElements[i]);
            }
        }
        this.isPainting = false;
        if (this.currentStep != null) {
            this.undoSteps.add(this.currentStep);
            if (this.undoSteps.size() > ConfigHandler.maxUndos) {
                this.undoSteps.remove(0);
            }
        }
    }

    public void addUndoData(UndoData undoData) {
        if (!this.isPainting) {
            ModLogger.log(Level.ERROR, "Tool painting with out marking the start.");
        }
        if (this.currentStep != null) {
            this.currentStep.addUndo(undoData);
        } else {
            ModLogger.log(Level.ERROR, "No undo step. Something is wrong!");
        }
    }

    public void playerPressedUndo(World world) {
        if (this.undoSteps.isEmpty()) {
            return;
        }
        UndoStep undoStep = this.undoSteps.get(this.undoSteps.size() - 1);
        undoStep.undo(world);
        this.undoSteps.remove(this.undoSteps.size() - 1);
    }

    public int getAvalableUndos() {
        return this.undoSteps.size();
    }
}

