/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.proxies;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.ArmourersWorkshopClientApi;
import moe.plushie.armourers_workshop.api.common.painting.IPantable;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.client.gui.style.GuiResourceManager;
import moe.plushie.armourers_workshop.client.handler.BlockHighlightRenderHandler;
import moe.plushie.armourers_workshop.client.handler.ClientWardrobeHandler;
import moe.plushie.armourers_workshop.client.handler.DebugTextHandler;
import moe.plushie.armourers_workshop.client.handler.ItemTooltipHandler;
import moe.plushie.armourers_workshop.client.handler.MannequinPlacementHandler;
import moe.plushie.armourers_workshop.client.handler.ModClientFMLEventHandler;
import moe.plushie.armourers_workshop.client.handler.PlayerTextureHandler;
import moe.plushie.armourers_workshop.client.handler.RehostedJarHandler;
import moe.plushie.armourers_workshop.client.handler.SkinPreviewHandler;
import moe.plushie.armourers_workshop.client.handler.SkinRenderHandlerApi;
import moe.plushie.armourers_workshop.client.library.ClientLibraryManager;
import moe.plushie.armourers_workshop.client.model.ICustomModel;
import moe.plushie.armourers_workshop.client.model.bake.ModelBakery;
import moe.plushie.armourers_workshop.client.render.RenderBridge;
import moe.plushie.armourers_workshop.client.render.SkinModelRenderHelper;
import moe.plushie.armourers_workshop.client.render.entity.EntitySkinRenderHandler;
import moe.plushie.armourers_workshop.client.render.entity.RenderEntityMannequin;
import moe.plushie.armourers_workshop.client.render.item.RenderItemEquipmentSkin;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockAdvancedSkinBuilder;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockArmourer;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockBoundingBox;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockColourable;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockGlobalSkinLibrary;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockHologramProjector;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockMannequin;
import moe.plushie.armourers_workshop.client.render.tileentities.RenderBlockSkinnable;
import moe.plushie.armourers_workshop.client.settings.Keybindings;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinPaintCache;
import moe.plushie.armourers_workshop.client.skin.cache.FastCache;
import moe.plushie.armourers_workshop.client.texture.PlayerTextureDownloader;
import moe.plushie.armourers_workshop.common.addons.ModAddonManager;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.init.items.ItemGiftSack;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.library.LibraryFile;
import moe.plushie.armourers_workshop.common.library.LibraryFileType;
import moe.plushie.armourers_workshop.common.network.messages.server.MessageServerClientCommand;
import moe.plushie.armourers_workshop.common.network.messages.server.MessageServerLibrarySendSkin;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.common.skin.SkinExtractor;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityAdvancedSkinBuilder;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityBoundingBox;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityColourable;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityGlobalSkinLibrary;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityHologramProjector;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityMannequin;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnable;
import moe.plushie.armourers_workshop.proxies.CommonProxy;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="armourers_workshop", value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy
implements ModelBakery.IBakedSkinReceiver {
    public static ClientWardrobeHandler wardrobeHandler;
    public static PlayerTextureHandler playerTextureHandler;
    public static PlayerTextureDownloader playerTextureDownloader;

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        int i;
        for (i = 0; i < ModBlocks.BLOCK_LIST.size(); ++i) {
            Block block = ModBlocks.BLOCK_LIST.get(i);
            if (!(block instanceof ICustomModel)) continue;
            ((ICustomModel)block).registerModels();
        }
        for (i = 0; i < ModItems.ITEM_LIST.size(); ++i) {
            Item item = ModItems.ITEM_LIST.get(i);
            if (!(item instanceof ICustomModel)) continue;
            ((ICustomModel)item).registerModels();
        }
        ModItems.SKIN.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RenderItemEquipmentSkin());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ConfigHandlerClient.init(new File(this.getModConfigDirectory(), "client.cfg"));
        this.enableCrossModSupport();
        new RehostedJarHandler(event.getSourceFile(), "Armourers-Workshop-1.12.2-0.50.3.jar");
        new GuiResourceManager();
        ReflectionHelper.setPrivateValue(ArmourersWorkshopClientApi.class, null, (Object)SkinRenderHandlerApi.INSTANCE, (String[])new String[]{"skinRenderHandler"});
        RenderingRegistry.registerEntityRenderingHandler(EntityMannequin.class, (IRenderFactory)new IRenderFactory(){

            public Render createRenderFor(RenderManager manager) {
                return new RenderEntityMannequin(manager);
            }
        });
    }

    @Override
    public void initLibraryManager() {
        this.libraryManager = new ClientLibraryManager();
    }

    @Override
    public void initRenderers() {
        SkinModelRenderHelper.init();
        EntitySkinRenderHandler.init();
        new BlockHighlightRenderHandler();
        new MannequinPlacementHandler();
        new ItemTooltipHandler();
        new SkinPreviewHandler();
        RenderBridge.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityArmourer.class, (TileEntitySpecialRenderer)new RenderBlockArmourer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMannequin.class, (TileEntitySpecialRenderer)new RenderBlockMannequin());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySkinnable.class, (TileEntitySpecialRenderer)new RenderBlockSkinnable());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityColourable.class, (TileEntitySpecialRenderer)new RenderBlockColourable());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBoundingBox.class, (TileEntitySpecialRenderer)new RenderBlockBoundingBox());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGlobalSkinLibrary.class, (TileEntitySpecialRenderer)new RenderBlockGlobalSkinLibrary());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHologramProjector.class, (TileEntitySpecialRenderer)new RenderBlockHologramProjector());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAdvancedSkinBuilder.class, (TileEntitySpecialRenderer)new RenderBlockAdvancedSkinBuilder());
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColour(), new Item[]{ModItems.PAINT_BRUSH});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColour(), new Item[]{ModItems.PAINT_ROLLER});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColour(), new Item[]{ModItems.COLOUR_PICKER});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColour(), new Item[]{ModItems.DYE_BOTTLE});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColour(), new Item[]{ModItems.HUE_TOOL});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColour(), new Item[]{ModItems.SOAP});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemColour(), new Item[]{ModItems.GIFT_SACK});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColour(), new Block[]{ModBlocks.SKIN_CUBE});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColour(), new Block[]{ModBlocks.SKIN_CUBE_GLASS});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColour(), new Block[]{ModBlocks.SKIN_CUBE_GLOWING});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColour(), new Block[]{ModBlocks.SKIN_CUBE_GLASS_GLOWING});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColour(), new Block[]{ModBlocks.COLOUR_MIXER});
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        wardrobeHandler = new ClientWardrobeHandler();
        playerTextureHandler = new PlayerTextureHandler();
        playerTextureDownloader = new PlayerTextureDownloader();
        ClientSkinCache.init();
        FMLCommonHandler.instance().bus().register((Object)new ModClientFMLEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DebugTextHandler());
        FastCache.INSTANCE.loadCacheData();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ModAddonManager.initRenderers();
        EntitySkinRenderHandler.INSTANCE.initRenderer();
        if (ModHolidays.VALENTINES.isHolidayActive()) {
            this.enableValentinesClouds();
        }
        this.loadErrorSkin();
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            public String call() throws Exception {
                int bakeQueue = ModelBakery.INSTANCE.getBakingQueueSize();
                String error = "\n";
                error = error + "\t\tBaking Queue: " + bakeQueue + "\n";
                error = error + "\t\tRequest Queue: " + (ClientSkinCache.INSTANCE.getRequestQueueSize() - bakeQueue) + "\n";
                error = error + "\t\tTexture Paint Type: " + ClientProxy.getTexturePaintType().toString() + "\n";
                error = error + "\t\tMultipass Skin Rendering: " + ClientProxy.useMultipassSkinRendering() + "\n";
                error = error + "\tRender Layers:";
                for (RenderPlayer playerRender : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
                    error = error + "\n\t\t Render Class: " + playerRender.getClass().getName();
                    Object object = ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)playerRender, (String[])new String[]{"field_177097_h", "layerRenderers"});
                    if (object == null) continue;
                    List layerRenderers = (List)object;
                    for (LayerRenderer layerRenderer : layerRenderers) {
                        error = error + "\n\t\t\t" + layerRenderer.getClass().getName();
                    }
                }
                return error;
            }

            public String getLabel() {
                return "Armourer's Workshop";
            }
        });
    }

    private void enableValentinesClouds() {
        ModLogger.log("Love is in the air!");
        try {
            Object o = ReflectionHelper.getPrivateValue(RenderGlobal.class, null, (String[])new String[]{"CLOUDS_TEXTURES", "field_110925_j"});
            Field f = ReflectionHelper.findField(ResourceLocation.class, (String[])new String[]{"namespace", "field_110626_a"});
            f.setAccessible(true);
            f.set(o, "armourers_workshop".toLowerCase());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void enableCrossModSupport() {
        if (ModAddonManager.addonMorePlayerModels.isModLoaded() & ModAddonManager.addonSmartMoving.isModLoaded()) {
            ModLogger.log(Level.WARN, "Smart Moving and More Player Models are both installed. Armourer's Workshop can not support this.");
        }
        if (ModAddonManager.addonColoredLights.isModLoaded() & ModAddonManager.addonSmartMoving.isModLoaded()) {
            ModLogger.log(Level.WARN, "Colored Lights and Smart Moving are both installed. Armourer's Workshop can not support this.");
        }
    }

    public static TexturePaintType getTexturePaintType() {
        if (ConfigHandlerClient.texturePaintingType < 0) {
            return TexturePaintType.DISABLED;
        }
        if (ConfigHandlerClient.texturePaintingType == 0) {
            return TexturePaintType.TEXTURE_REPLACE;
        }
        return TexturePaintType.values()[ConfigHandlerClient.texturePaintingType];
    }

    public static boolean useMultipassSkinRendering() {
        return ConfigHandlerClient.multipassSkinRendering;
    }

    public static int getNumberOfRenderLayers() {
        if (ClientProxy.useMultipassSkinRendering()) {
            return 4;
        }
        return 2;
    }

    @Override
    public void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.KEY_UNDO);
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.OPEN_WARDROBE);
    }

    @Override
    public void receivedCommandFromSever(MessageServerClientCommand.CommandType command) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        switch (command) {
            case CLEAR_MODEL_CACHE: {
                ClientSkinCache.INSTANCE.clearCache();
                CommonSkinCache.INSTANCE.clearAll();
                ClientSkinPaintCache.INSTANCE.clear();
            }
        }
    }

    @Override
    public void receivedSkinFromLibrary(String fileName, String filePath, Skin skin, MessageServerLibrarySendSkin.SendType sendType) {
        switch (sendType) {
            case LIBRARY_SAVE: {
                SkinIOUtils.saveSkinFromFileName(filePath, fileName + ".armour", skin);
                ArmourersWorkshop.getProxy().libraryManager.addFileToListType(new LibraryFile(fileName, filePath, skin.getSkinType()), LibraryFileType.LOCAL, null);
                break;
            }
            case GLOBAL_UPLOAD: {
                GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
                if (!(screen instanceof GuiGlobalLibrary)) break;
                ((GuiGlobalLibrary)screen).gotSkinFromServer(skin);
            }
        }
    }

    @Override
    public boolean isLocalPlayer(String username) {
        GameProfile gameProfile = this.getLocalGameProfile();
        return gameProfile != null && !StringUtils.func_151246_b((String)gameProfile.getName()) && username.equals(gameProfile.getName());
    }

    @Override
    public boolean haveFullLocalProfile() {
        GameProfile gameProfile = this.getLocalGameProfile();
        return gameProfile.isComplete() && gameProfile.getProperties().containsKey((Object)"textures");
    }

    @Override
    public GameProfile getLocalGameProfile() {
        return Minecraft.func_71410_x().field_71439_g.func_146103_bH();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadErrorSkin() {
        ModLogger.log("Loading error model.");
        InputStream inputStream = null;
        try {
            inputStream = SkinExtractor.class.getClassLoader().getResourceAsStream("assets/armourers_workshop/skins/error.armour");
            Skin skin = SkinIOUtils.loadSkinFromStream(inputStream);
            SkinIdentifier identifier = new SkinIdentifier(skin);
            ModelBakery.INSTANCE.receivedUnbakedModel(skin, identifier, identifier, this);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    @Override
    public void onBakedSkin(ModelBakery.BakedSkin bakedSkin) {
        ClientSkinCache.errorSkin = bakedSkin.getSkin();
        ModLogger.log("Error skin loaded.");
    }

    @Override
    public MinecraftServer getServer() {
        return Minecraft.func_71410_x().func_71401_C();
    }

    private static class ItemColour
    implements IItemColor {
        private ItemColour() {
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (stack.func_77973_b() == ModItems.GIFT_SACK) {
                return ((ItemGiftSack)stack.func_77973_b()).colorMultiplier(stack, tintIndex);
            }
            if (stack.func_77973_b() == ModItems.DYE_BOTTLE) {
                if (tintIndex == 0) {
                    return PaintingHelper.getToolDisplayColourRGB(stack);
                }
                return -1;
            }
            if (stack.func_77973_b() == ModItems.COLOUR_PICKER) {
                if (tintIndex == 0) {
                    return PaintingHelper.getToolDisplayColourRGB(stack);
                }
                return -1;
            }
            if (tintIndex == 1) {
                return PaintingHelper.getToolDisplayColourRGB(stack);
            }
            return -1;
        }
    }

    private static class BlockColour
    implements IBlockColor {
        private BlockColour() {
        }

        public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity != null && tileEntity instanceof IPantable) {
                return ((IPantable)tileEntity).getColour(tintIndex);
            }
            return -1;
        }
    }

    public static enum TexturePaintType {
        DISABLED,
        TEXTURE_REPLACE,
        MODEL_REPLACE_MC,
        MODEL_REPLACE_AW;

    }
}

