/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public final class NBTHelper {
    private static final String TAG_POS_X = "posX";
    private static final String TAG_POS_Y = "posY";
    private static final String TAG_POS_Z = "posZ";

    private NBTHelper() {
    }

    public static NBTTagCompound getNBTForStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean stackHasKey(ItemStack stack, String key) {
        if (stack == null) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(key);
    }

    public static void writeStackToNBT(NBTTagCompound compound, String key, ItemStack itemStack) {
        NBTTagCompound stackCompund = new NBTTagCompound();
        itemStack.func_77955_b(stackCompund);
        compound.func_74782_a(key, (NBTBase)stackCompund);
    }

    public static ItemStack readStackfromNBT(NBTTagCompound compound, String key) {
        ItemStack returnStack = ItemStack.field_190927_a;
        if (compound.func_150297_b(key, 10)) {
            returnStack = new ItemStack(compound.func_74775_l(key));
        }
        return returnStack;
    }

    public static void writeStackArrayToNBT(NBTTagCompound compound, String key, NonNullList<ItemStack> itemStacks) {
        NBTTagCompound items = new NBTTagCompound();
        ItemStackHelper.func_191282_a((NBTTagCompound)items, itemStacks);
        compound.func_74782_a(key, (NBTBase)items);
    }

    public static void readStackArrayFromNBT(NBTTagCompound compound, String key, NonNullList<ItemStack> itemStacks) {
        NBTTagCompound items = compound.func_74775_l(key);
        ItemStackHelper.func_191283_b((NBTTagCompound)items, itemStacks);
    }

    public static void writeBlockPosToNBT(NBTTagCompound compound, String key, BlockPos pos) {
        if (pos == null) {
            return;
        }
        compound.func_74768_a(TAG_POS_X + key, pos.func_177958_n());
        compound.func_74768_a(TAG_POS_Y + key, pos.func_177956_o());
        compound.func_74768_a(TAG_POS_Z + key, pos.func_177952_p());
    }

    public static BlockPos readBlockPosFromNBT(NBTTagCompound compound, String key) {
        return NBTHelper.readBlockPosFromNBT(compound, key, null);
    }

    public static BlockPos readBlockPosFromNBT(NBTTagCompound compound, String key, BlockPos defaultReturn) {
        if (compound.func_150297_b(TAG_POS_X + key, 3) & compound.func_150297_b(TAG_POS_Y + key, 3) & compound.func_150297_b(TAG_POS_Z + key, 3)) {
            return new BlockPos(compound.func_74762_e(TAG_POS_X + key), compound.func_74762_e(TAG_POS_Y + key), compound.func_74762_e(TAG_POS_Z + key));
        }
        return defaultReturn;
    }
}

