/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinIdentifier;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.init.items.ItemArmourContainerItem;
import moe.plushie.armourers_workshop.common.init.items.ItemSkinTemplate;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SkinNBTHelper {
    public static boolean stackHasSkinData(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound itemCompound = stack.func_77978_p();
        return itemCompound.func_74764_b("armourersWorkshop");
    }

    public static boolean compoundHasSkinData(NBTTagCompound compound) {
        if (compound == null) {
            return false;
        }
        return compound.func_74764_b("armourersWorkshop");
    }

    public static void removeSkinDataFromStack(ItemStack stack) {
        if (!SkinNBTHelper.stackHasSkinData(stack)) {
            return;
        }
        NBTTagCompound itemCompound = stack.func_77978_p();
        if (itemCompound.func_74764_b("armourersWorkshop")) {
            itemCompound.func_82580_o("armourersWorkshop");
        }
    }

    public static void removeSkinData(NBTTagCompound compound) {
        if (!SkinNBTHelper.compoundHasSkinData(compound)) {
            return;
        }
        if (compound.func_74764_b("armourersWorkshop")) {
            compound.func_82580_o("armourersWorkshop");
        }
    }

    public static SkinDescriptor getSkinDescriptorFromStack(ItemStack stack) {
        if (!SkinNBTHelper.stackHasSkinData(stack)) {
            return null;
        }
        SkinDescriptor skinData = new SkinDescriptor();
        skinData.readFromCompound(stack.func_77978_p());
        return skinData;
    }

    public static SkinDescriptor getSkinDescriptork(NBTTagCompound compound) {
        if (!SkinNBTHelper.compoundHasSkinData(compound)) {
            return null;
        }
        SkinDescriptor skinData = new SkinDescriptor();
        skinData.readFromCompound(compound);
        return skinData;
    }

    public static ISkinType getSkinTypeFromStack(ItemStack stack) {
        if (!SkinNBTHelper.stackHasSkinData(stack)) {
            return null;
        }
        SkinDescriptor skinData = new SkinDescriptor();
        skinData.readFromCompound(stack.func_77978_p());
        return skinData.getIdentifier().getSkinType();
    }

    @Deprecated
    public static void addSkinDataToStack(ItemStack stack, ISkinIdentifier identifier, ISkinDye skinDye) {
        SkinDescriptor skinData = new SkinDescriptor(identifier, skinDye);
        SkinNBTHelper.addSkinDataToStack(stack, skinData);
    }

    public static void addSkinDataToStack(ItemStack stack, SkinDescriptor descriptor) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        descriptor.writeToCompound(stack.func_77978_p());
    }

    public static void addSkinDataToStack(NBTTagCompound compound, SkinDescriptor descriptor) {
        descriptor.writeToCompound(compound);
    }

    public static ItemStack makeEquipmentSkinStack(SkinDescriptor descriptor) {
        return ((ItemSkinTemplate)ModItems.SKIN_TEMPLATE).makeSkinStack(descriptor);
    }

    public static ItemStack makeArmouerContainerStack(SkinDescriptor descriptor) {
        return ((ItemArmourContainerItem)ModItems.ARMOUR_CONTAINER_ITEM).makeSkinStack(descriptor);
    }
}

