/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.awt.Color;
import java.util.Random;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.util.math.MathHelper;

public class UtilColour {
    public static int[] PALETTE_MINECRAFT = new int[]{0xFFFFFF, 0xFFFF55, 0xFF55FF, 0xFF5555, 0x55FFFF, 0x55FF55, 0x5555FF, 0x555555, 0xAAAAAA, 0xFFAA00, 0xAA00AA, 0xAA0000, 43690, 43520, 170, 0, 0xDDDDDD, 14384446, 11751612, 7047881, 11642407, 4304440, 13665433, 0x404040, 0x9AA1A1, 3042953, 8273333, 3029133, 5190175, 3491355, 9843760, 0x191616};
    public static int[] PALETTE_SHADES = new int[0];

    public static Color makeColourBighter(Color c, int amount) {
        int r = c.getRed() + amount;
        int g = c.getGreen() + amount;
        int b = c.getBlue() + amount;
        r = MathHelper.func_76125_a((int)r, (int)0, (int)255);
        g = MathHelper.func_76125_a((int)g, (int)0, (int)255);
        b = MathHelper.func_76125_a((int)b, (int)0, (int)255);
        return new Color(r, g, b);
    }

    public static Color makeColourDarker(Color c, int amount) {
        int r = c.getRed() - amount;
        int g = c.getGreen() - amount;
        int b = c.getBlue() - amount;
        r = MathHelper.func_76125_a((int)r, (int)0, (int)255);
        g = MathHelper.func_76125_a((int)g, (int)0, (int)255);
        b = MathHelper.func_76125_a((int)b, (int)0, (int)255);
        return new Color(r, g, b);
    }

    public static Color addColourNoise(Color c, int amount) {
        Random rnd = new Random();
        int r = c.getRed() - amount + rnd.nextInt(amount * 2);
        int g = c.getGreen() - amount + rnd.nextInt(amount * 2);
        int b = c.getBlue() - amount + rnd.nextInt(amount * 2);
        r = MathHelper.func_76125_a((int)r, (int)0, (int)255);
        g = MathHelper.func_76125_a((int)g, (int)0, (int)255);
        b = MathHelper.func_76125_a((int)b, (int)0, (int)255);
        return new Color(r, g, b);
    }

    public static Color addShadeNoise(Color c, int amount) {
        Random rnd = new Random();
        int shadeAmount = rnd.nextInt(amount * 2);
        int r = c.getRed() - amount + shadeAmount;
        int g = c.getGreen() - amount + shadeAmount;
        int b = c.getBlue() - amount + shadeAmount;
        r = MathHelper.func_76125_a((int)r, (int)0, (int)255);
        g = MathHelper.func_76125_a((int)g, (int)0, (int)255);
        b = MathHelper.func_76125_a((int)b, (int)0, (int)255);
        return new Color(r, g, b);
    }

    public static int getMinecraftColor(int meta, ColourFamily colourFamily) {
        switch (colourFamily) {
            case MINECRAFT: {
                if (meta < 0 || meta >= PALETTE_MINECRAFT.length) break;
                return PALETTE_MINECRAFT[meta];
            }
            case SHADES: {
                if (meta < 0 || meta >= PALETTE_SHADES.length) break;
                return PALETTE_SHADES[meta];
            }
        }
        return 0;
    }

    static {
        PALETTE_SHADES = new int[32];
        UtilColour.PALETTE_SHADES[0] = -1;
        for (int i = 1; i < PALETTE_SHADES.length + 1; ++i) {
            Color c = new Color(8 * i - 1, 8 * i - 1, 8 * i - 1);
            UtilColour.PALETTE_SHADES[i - 1] = c.getRGB();
        }
    }

    public static enum ColourFamily {
        MINECRAFT("minecraft"),
        SHADES("shades");

        public final String name;

        private ColourFamily(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getLocalizedName() {
            String unlocalizedText = "colourFamily." + "armourers_workshop".toLowerCase() + ":";
            unlocalizedText = unlocalizedText + this.name.toLowerCase() + ".name";
            return TranslateUtils.translate(unlocalizedText);
        }
    }
}

