/*
 * Decompiled with CFR 0.152.
 */
package net.casinocraft.mod.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.casinocraft.mod.container.ContainerMeanMinos;
import net.casinocraft.mod.tileentity.TileEntityCasino;
import net.casinocraft.mod.util.Vector2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumDyeColor;

public class TileEntityMeanMinos
extends TileEntityCasino {
    public boolean active_hold;
    public String[] container_next = new String[2];
    public String[] container_hold = new String[2];
    public String[] container_current = new String[2];
    public double time_last;
    public double time_break;
    public int timer;
    public int score_level;
    public int score_lives;
    public int score_points;
    public boolean[][] grid_base = new boolean[10][15];
    public String[][] grid_color = new String[10][15];
    public Vector2[] tetromino = new Vector2[2];
    public List<Vector2> clear = new ArrayList<Vector2>();
    public boolean won;
    public int alpha;
    public EnumDyeColor color;
    List<Vector2> clear_temp = new ArrayList<Vector2>();

    public TileEntityMeanMinos() {
        this.start();
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerMeanMinos(playerInventory, this);
    }

    public void start() {
        this.active_hold = true;
        this.container_next[0] = this.Domino_Roll();
        this.container_next[1] = this.Domino_Roll();
        this.container_hold[0] = "empty";
        this.container_hold[1] = "empty";
        this.container_current[0] = this.Domino_Roll();
        this.container_current[1] = this.Domino_Roll();
        this.Domino_Create();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.grid_base[i][j] = false;
                this.grid_color[i][j] = "empty";
            }
        }
        this.time_break = 200.0;
        this.time_last = 0.0;
        this.won = false;
        this.clear.clear();
        this.alpha = 255;
    }

    @Override
    public void func_73660_a() {
        this.timer += 15;
        if (this.alpha == 255) {
            if ((double)this.timer > this.time_last + this.time_break - (double)(this.score_level * 5) && !this.won) {
                this.Domino_Fall();
                this.time_last = this.timer;
            }
        } else {
            this.alpha -= 10;
            if (this.alpha <= 0) {
                this.alpha = 255;
                for (int y = 0; y < 15; ++y) {
                    for (int x = 0; x < 10; ++x) {
                        if (!this.IsCleared(x, y)) continue;
                        this.grid_base[x][y] = false;
                        this.grid_color[x][y] = "empty";
                    }
                }
                this.Command_Collapse();
            }
        }
    }

    private String IntToMino(int i) {
        if (i == 0) {
            return "fire";
        }
        if (i == 1) {
            return "air";
        }
        if (i == 2) {
            return "thunder";
        }
        if (i == 3) {
            return "water";
        }
        if (i == 4) {
            return "ice";
        }
        if (i == 5) {
            return "earth";
        }
        if (i == 6) {
            return "metal";
        }
        if (i == 7) {
            return "nature";
        }
        if (i == 8) {
            return "light";
        }
        if (i == 9) {
            return "dark";
        }
        return "blank";
    }

    private void Domino_Drop() {
        int tempPoints = this.score_points;
        while (this.score_points == tempPoints) {
            this.Domino_Fall();
        }
    }

    private boolean IsCleared(int x, int y) {
        for (int i = 0; i < this.clear.size(); ++i) {
            if (this.clear.get((int)i).X != x || this.clear.get((int)i).Y != y) continue;
            return true;
        }
        return false;
    }

    private void Command_Collapse() {
        int temp = 0;
        for (int y = 13; y >= 0; --y) {
            for (int x = 0; x < 10; ++x) {
                if (!this.grid_base[x][y]) continue;
                temp = 0;
                while (y + temp + 1 < 15 && !this.grid_base[x][y + temp + 1]) {
                    ++temp;
                }
                if (temp == 0) continue;
                this.grid_base[x][y + temp] = true;
                this.grid_base[x][y] = false;
                this.grid_color[x][y + temp] = this.grid_color[x][y];
                this.grid_color[x][y] = "empty";
            }
        }
        this.clear.clear();
        this.alpha = 255;
        this.Check_Field();
    }

    public void Command_Strafe(String _direction) {
        int dir = 0;
        if (_direction == "left") {
            dir = -1;
            if (this.tetromino[0].X > 0 && this.tetromino[1].X > 0 && !this.grid_base[this.tetromino[0].X + dir][this.tetromino[0].Y] && !this.grid_base[this.tetromino[1].X + dir][this.tetromino[1].Y]) {
                this.tetromino[0].X += dir;
                this.tetromino[1].X += dir;
            }
        }
        if (_direction == "right") {
            dir = 1;
            if (this.tetromino[0].X < 9 && this.tetromino[1].X < 9 && !this.grid_base[this.tetromino[0].X + dir][this.tetromino[0].Y] && !this.grid_base[this.tetromino[1].X + dir][this.tetromino[1].Y]) {
                this.tetromino[0].X += dir;
                this.tetromino[1].X += dir;
            }
        }
    }

    public void Command_Turn(String _direction) {
        int pos = 0;
        if (this.tetromino[0].Y > this.tetromino[1].Y) {
            pos = 1;
        }
        if (this.tetromino[0].X > this.tetromino[1].X) {
            pos = 2;
        }
        if (this.tetromino[0].Y < this.tetromino[1].Y) {
            pos = 3;
        }
        if (this.tetromino[0].X < this.tetromino[1].X) {
            pos = 4;
        }
        if (_direction == "left") {
            if (pos == 1 && this.tetromino[0].X - 1 >= 0 && !this.grid_base[this.tetromino[0].X - 1][this.tetromino[0].Y]) {
                this.tetromino[1] = new Vector2(this.tetromino[0].X - 1, this.tetromino[0].Y);
            }
            if (pos == 2 && this.tetromino[0].Y + 1 <= 14 && !this.grid_base[this.tetromino[0].X][this.tetromino[0].Y + 1]) {
                this.tetromino[1] = new Vector2(this.tetromino[0].X, this.tetromino[0].Y + 1);
            }
            if (pos == 3 && this.tetromino[0].X + 1 <= 9 && !this.grid_base[this.tetromino[0].X + 1][this.tetromino[0].Y]) {
                this.tetromino[1] = new Vector2(this.tetromino[0].X + 1, this.tetromino[0].Y);
            }
            if (pos == 4 && this.tetromino[0].Y - 1 >= 0 && !this.grid_base[this.tetromino[0].X][this.tetromino[0].Y - 1]) {
                this.tetromino[1] = new Vector2(this.tetromino[0].X, this.tetromino[0].Y - 1);
            }
        }
        if (_direction == "right") {
            if (pos == 1 && this.tetromino[0].X + 1 <= 9 && !this.grid_base[this.tetromino[0].X + 1][this.tetromino[0].Y]) {
                this.tetromino[1] = new Vector2(this.tetromino[0].X + 1, this.tetromino[0].Y);
            }
            if (pos == 2 && this.tetromino[0].Y - 1 >= 0 && !this.grid_base[this.tetromino[0].X][this.tetromino[0].Y - 1]) {
                this.tetromino[1] = new Vector2(this.tetromino[0].X, this.tetromino[0].Y - 1);
            }
            if (pos == 3 && this.tetromino[0].X - 1 >= 0 && !this.grid_base[this.tetromino[0].X - 1][this.tetromino[0].Y]) {
                this.tetromino[1] = new Vector2(this.tetromino[0].X - 1, this.tetromino[0].Y);
            }
            if (pos == 4 && this.tetromino[0].Y + 1 <= 14 && !this.grid_base[this.tetromino[0].X][this.tetromino[0].Y + 1]) {
                this.tetromino[1] = new Vector2(this.tetromino[0].X, this.tetromino[0].Y + 1);
            }
        }
    }

    public void Command_Hold() {
        if (this.active_hold) {
            this.active_hold = false;
            if (this.container_hold[0] == "empty") {
                this.container_hold = this.container_current;
                this.container_hold = this.container_current;
                this.container_current = this.container_next;
                this.container_current = this.container_next;
                this.container_next[0] = this.Domino_Roll();
                this.container_next[1] = this.Domino_Roll();
            } else {
                String[] temp = new String[]{this.container_hold[0], this.container_hold[1]};
                this.container_hold[0] = this.container_current[0];
                this.container_hold[1] = this.container_current[1];
                this.container_current[0] = temp[0];
                this.container_current[1] = temp[1];
            }
            this.Domino_Create();
        }
    }

    private String Domino_Roll() {
        return this.IntToMino(this.rand.nextInt(8));
    }

    private void Domino_Create() {
        this.tetromino[0] = new Vector2(4, 1);
        this.tetromino[1] = new Vector2(4, 0);
    }

    public void Domino_Fall() {
        if (this.tetromino[0].Y < 14 && this.tetromino[1].Y < 14) {
            if (!this.grid_base[this.tetromino[0].X][this.tetromino[0].Y + 1] && !this.grid_base[this.tetromino[1].X][this.tetromino[1].Y + 1]) {
                ++this.tetromino[0].Y;
                ++this.tetromino[1].Y;
            } else {
                this.Domino_Place();
            }
        } else {
            this.Domino_Place();
        }
    }

    private void Domino_Place() {
        this.active_hold = true;
        this.grid_base[this.tetromino[0].X][this.tetromino[0].Y] = true;
        this.grid_base[this.tetromino[1].X][this.tetromino[1].Y] = true;
        this.grid_color[this.tetromino[0].X][this.tetromino[0].Y] = this.container_current[0];
        this.grid_color[this.tetromino[1].X][this.tetromino[1].Y] = this.container_current[1];
        this.score_points += 4;
        if (this.tetromino[1].Y == 0) {
            this.won = true;
        }
        this.container_current[0] = this.container_next[0];
        this.container_current[1] = this.container_next[1];
        this.container_next[0] = this.Domino_Roll();
        this.container_next[1] = this.Domino_Roll();
        this.Domino_Create();
        this.Check_Field();
    }

    private void Check_Field() {
        int points = 0;
        int bonus = 0;
        this.clear_temp.clear();
        for (int y = 14; y >= 0; --y) {
            for (int x = 0; x < 10; ++x) {
                if (this.IsCleared(x, y)) continue;
                this.Pathfinder(x, y);
                if (this.clear_temp.size() >= 4) {
                    points += this.clear_temp.size() * 10;
                    ++bonus;
                    this.clear.addAll(this.clear_temp);
                }
                this.clear_temp.clear();
            }
        }
        if (points > 0) {
            this.alpha -= 5;
            this.score_points += points * 2 * bonus * (this.score_level + 1);
            ++this.score_lives;
            if (this.score_lives > (1 + this.score_level) * 10) {
                ++this.score_level;
            }
        }
    }

    private void Pathfinder(int x, int y) {
        this.clear_temp.add(new Vector2(x, y));
        if (y - 1 >= 0 && this.grid_color[x][y].compareTo("empty") != 0 && this.grid_color[x][y].compareTo(this.grid_color[x][y - 1]) == 0 && !this.IsClearedTemp(x, y - 1)) {
            this.Pathfinder(x, y - 1);
        }
        if (y + 1 <= 14 && this.grid_color[x][y].compareTo("empty") != 0 && this.grid_color[x][y].compareTo(this.grid_color[x][y + 1]) == 0 && !this.IsClearedTemp(x, y + 1)) {
            this.Pathfinder(x, y + 1);
        }
        if (x - 1 >= 0 && this.grid_color[x][y].compareTo("empty") != 0 && this.grid_color[x][y].compareTo(this.grid_color[x - 1][y]) == 0 && !this.IsClearedTemp(x - 1, y)) {
            this.Pathfinder(x - 1, y);
        }
        if (x + 1 <= 9 && this.grid_color[x][y].compareTo("empty") != 0 && this.grid_color[x][y].compareTo(this.grid_color[x + 1][y]) == 0 && !this.IsClearedTemp(x + 1, y)) {
            this.Pathfinder(x + 1, y);
        }
    }

    private boolean IsClearedTemp(int x, int y) {
        for (int i = 0; i < this.clear_temp.size(); ++i) {
            if (this.clear_temp.get((int)i).X != x || this.clear_temp.get((int)i).Y != y) continue;
            return true;
        }
        return false;
    }
}

