/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.NBTTagCompound;

public class LogicCardLightGray
extends LogicBase {
    public Card[][] cards = new Card[5][6];
    public boolean[] folded = new boolean[6];
    public int pot = 0;
    public int raisedPlayer = -1;
    public boolean[] dropped = new boolean[5];
    public int round = 0;

    public LogicCardLightGray(int tableID) {
        super(tableID);
    }

    @Override
    public void start2() {
        int i;
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 5; ++y) {
                this.cards[y][x] = new Card(-1, -1);
            }
        }
        for (i = 0; i < 5; ++i) {
            this.dropped[i] = false;
        }
        for (i = 0; i < 6; ++i) {
            this.folded[i] = false;
        }
        this.pot = 0;
        this.raisedPlayer = -1;
        this.round = 0;
    }

    @Override
    public void command(int action) {
        if (action == 0) {
            this.call();
        }
        if (action == 1) {
            this.raise();
        }
        if (action == 2) {
            this.check();
        }
        if (action == 3) {
            this.fold();
        }
        if (action >= 4) {
            this.dropped[action - 4] = !this.dropped[action - 4];
        }
    }

    @Override
    public void updateLogic() {
        ++this.timeout;
        if (this.turnstate == 2 && this.timeout >= CasinoKeeper.config_timeout || this.getFirstFreePlayerSlot() == (this.tableID == 1 ? 4 : 6)) {
            this.draw();
        }
        if (this.turnstate == 3) {
            if (this.folded[this.activePlayer]) {
                this.drawAnother();
            }
            if (this.timeout == CasinoKeeper.config_timeout) {
                this.fold();
            }
            if (this.lastStanding() != -1) {
                this.result();
            }
        }
    }

    @Override
    public void updateMotion() {
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 5; ++y) {
                this.cards[y][x].update();
            }
        }
    }

    @Override
    public void load2(NBTTagCompound compound) {
        this.cards[0] = this.loadCardArray(compound, 0);
        this.cards[1] = this.loadCardArray(compound, 1);
        this.cards[2] = this.loadCardArray(compound, 2);
        this.cards[3] = this.loadCardArray(compound, 3);
        this.cards[4] = this.loadCardArray(compound, 4);
        this.folded[0] = compound.func_74767_n("folded0");
        this.folded[1] = compound.func_74767_n("folded1");
        this.folded[2] = compound.func_74767_n("folded2");
        this.folded[3] = compound.func_74767_n("folded3");
        this.folded[4] = compound.func_74767_n("folded4");
        this.dropped[0] = compound.func_74767_n("dropped0");
        this.dropped[1] = compound.func_74767_n("dropped1");
        this.dropped[2] = compound.func_74767_n("dropped2");
        this.dropped[3] = compound.func_74767_n("dropped3");
        this.dropped[4] = compound.func_74767_n("dropped4");
        this.pot = compound.func_74762_e("pot");
        this.raisedPlayer = compound.func_74762_e("raisedplayer");
    }

    @Override
    public NBTTagCompound save2(NBTTagCompound compound) {
        this.saveCardArray(compound, 0, this.cards[0]);
        this.saveCardArray(compound, 1, this.cards[1]);
        this.saveCardArray(compound, 2, this.cards[2]);
        this.saveCardArray(compound, 3, this.cards[3]);
        this.saveCardArray(compound, 4, this.cards[4]);
        compound.func_74757_a("folded0", this.folded[0]);
        compound.func_74757_a("folded1", this.folded[1]);
        compound.func_74757_a("folded2", this.folded[2]);
        compound.func_74757_a("folded3", this.folded[3]);
        compound.func_74757_a("folded4", this.folded[4]);
        compound.func_74757_a("folded0", this.folded[0]);
        compound.func_74757_a("dropped1", this.dropped[1]);
        compound.func_74757_a("dropped2", this.dropped[2]);
        compound.func_74757_a("dropped3", this.dropped[3]);
        compound.func_74757_a("dropped4", this.dropped[4]);
        compound.func_74768_a("pot", this.pot);
        compound.func_74768_a("raisedplayer", this.raisedPlayer);
        return compound;
    }

    private void draw() {
        int x;
        int y;
        this.turnstate = 3;
        this.timeout = 0;
        this.pot = this.getFirstFreePlayerSlot();
        if (this.tableID == 1) {
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < this.pot; ++x) {
                    this.cards[y][x] = new Card(this.RANDOM, x == 1 ? 24 : (x == 3 ? -24 : 0), x == 0 ? -24 : (x == 2 ? 24 : 0), 8 * x + 32 * y, false);
                }
            }
        } else {
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < this.pot; ++x) {
                    this.cards[y][x] = new Card(this.RANDOM, x == 1 ? 24 : (x == 4 ? -24 : 0), x == 0 || x == 5 ? -24 : (x == 2 || x == 3 ? 24 : 0), 8 * x + 48 * y, false);
                }
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (i < this.getFirstFreePlayerSlot()) continue;
            this.folded[i] = true;
        }
    }

    private void drawAnother() {
        for (int y = 0; y < 5; ++y) {
            if (!this.dropped[y]) continue;
            if (this.tableID == 1) {
                this.cards[y][this.activePlayer] = new Card(this.RANDOM, this.activePlayer == 1 ? 24 : (this.activePlayer == 3 ? -24 : 0), this.activePlayer == 0 ? -24 : (this.activePlayer == 2 ? 24 : 0), 0, false);
            }
            if (this.tableID == 2) {
                this.cards[y][this.activePlayer] = new Card(this.RANDOM, this.activePlayer == 1 ? 24 : (this.activePlayer == 4 ? -24 : 0), this.activePlayer == 0 || this.activePlayer == 5 ? -24 : (this.activePlayer == 2 || this.activePlayer == 3 ? 24 : 0), 0, false);
            }
            this.dropped[y] = false;
        }
        this.timeout = 0;
        this.activePlayer = (this.activePlayer + 1) % this.getFirstFreePlayerSlot();
        if (this.activePlayer == 0 && this.raisedPlayer == -1) {
            ++this.round;
            if (this.round == 3) {
                this.result();
            }
        }
        if (this.activePlayer == this.raisedPlayer) {
            this.raisedPlayer = -1;
        }
    }

    private int lastStanding() {
        int count = 0;
        int pos = -1;
        for (int i = 0; i < 6; ++i) {
            if (this.folded[i]) continue;
            ++count;
            pos = i;
        }
        return count == 1 ? pos : -1;
    }

    private void call() {
        ++this.pot;
        this.drawAnother();
    }

    private void raise() {
        ++this.pot;
        this.raisedPlayer = this.activePlayer;
        this.drawAnother();
    }

    private void check() {
        this.drawAnother();
    }

    private void fold() {
        this.folded[this.activePlayer] = true;
        this.drawAnother();
    }

    private void result() {
        this.turnstate = 4;
        int lastPlayer = this.lastStanding();
        if (lastPlayer != -1) {
            this.reward[lastPlayer] = this.pot;
        } else {
            int[] finalHand = new int[]{0, 0, 0, 0, 0, 0};
            for (int i = 0; i < 6; ++i) {
                finalHand[i] = this.folded[i] ? 0 : this.sortAndClear(this.cards[0][i], this.cards[1][i], this.cards[2][i], this.cards[3][i], this.cards[4][i]);
            }
            int winner = 0;
            for (int i = 0; i < 6; ++i) {
                if (finalHand[i] <= finalHand[winner]) continue;
                winner = i;
            }
            this.reward[winner] = this.pot;
        }
    }

    private int sortAndClear(Card card0, Card card1, Card card2, Card card3, Card card4) {
        boolean sorted = false;
        Card[] tempCards = new Card[]{new Card(card0), new Card(card1), new Card(card2), new Card(card3), new Card(card4)};
        Card temp = new Card(-1, -1);
        while (!sorted) {
            sorted = true;
            for (int i = 0; i < 3; ++i) {
                if (tempCards[i].sortedNumber() <= tempCards[i + 1].sortedNumber()) continue;
                temp.set(tempCards[i]);
                tempCards[i].set(tempCards[i + 1]);
                tempCards[i + 1].set(temp);
                sorted = false;
            }
        }
        return this.clear(tempCards);
    }

    private int clear(Card[] c) {
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number == c[3].number && c[0].number == c[4].number) {
            return 100000 + c[0].sortedNumber();
        }
        if (c[0].number == 9 && c[1].number == 10 && c[2].number == 11 && c[3].number == 12 && c[4].number == 0 && c[0].suit == c[1].suit && c[0].suit == c[2].suit && c[0].suit == c[3].suit && c[0].suit == c[4].suit) {
            return 90000 + c[0].suit;
        }
        if (c[0].number <= 9 && c[0].number + 1 == c[1].number && c[0].number + 2 == c[2].number && c[0].number + 3 == c[3].number && c[0].number + 4 == c[4].number && c[0].suit == c[1].suit && c[0].suit == c[2].suit && c[0].suit == c[3].suit && c[0].suit == c[4].suit) {
            return 80000 + c[0].sortedNumber();
        }
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number == c[3].number && c[0].number != c[4].number) {
            return 70000 + c[0].sortedNumber();
        }
        if (c[1].number == c[2].number && c[1].number == c[3].number && c[1].number == c[4].number && c[1].number != c[0].number) {
            return 70000 + c[1].sortedNumber();
        }
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number != c[3].number && c[3].number == c[4].number) {
            return 60000 + c[3].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[2].number == c[3].number && c[2].number == c[4].number && c[0].number != c[3].number && c[0].number == c[1].number) {
            return 60000 + c[0].sortedNumber() * 100 + c[3].sortedNumber();
        }
        if (c[0].suit == c[1].suit && c[0].suit == c[2].suit && c[0].suit == c[3].suit && c[0].suit == c[4].suit) {
            return 50000 + c[0].sortedNumber();
        }
        if (c[0].number <= 9 && c[0].number + 1 == c[1].number && c[0].number + 2 == c[2].number && c[0].number + 3 == c[3].number && c[0].number + 4 == c[4].number) {
            return 40000 + c[0].sortedNumber();
        }
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number != c[3].number && c[0].number != c[4].number) {
            return 30000 + c[1].sortedNumber() * 100 + c[4].sortedNumber();
        }
        if (c[1].number == c[2].number && c[1].number == c[3].number && c[1].number != c[0].number && c[1].number != c[4].number) {
            return 30000 + c[2].sortedNumber() * 100 + c[4].sortedNumber();
        }
        if (c[2].number == c[3].number && c[2].number == c[4].number && c[2].number != c[0].number && c[2].number != c[1].number) {
            return 30000 + c[3].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[0].number == c[1].number && c[2].number == c[3].number) {
            return 20000 + c[2].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[0].number == c[1].number && c[3].number == c[4].number) {
            return 20000 + c[3].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[1].number == c[2].number && c[3].number == c[4].number) {
            return 20000 + c[3].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[0].number == c[1].number) {
            return 10000 + c[0].sortedNumber() + c[4].sortedNumber();
        }
        if (c[1].number == c[2].number) {
            return 10000 + c[1].sortedNumber() + c[4].sortedNumber();
        }
        if (c[2].number == c[3].number) {
            return 10000 + c[2].sortedNumber() + c[4].sortedNumber();
        }
        if (c[3].number == c[4].number) {
            return 10000 + c[3].sortedNumber() + c[2].sortedNumber();
        }
        int highestNumber = 0;
        for (int i = 0; i < 5; ++i) {
            if (c[i].sortedNumber() <= highestNumber) continue;
            highestNumber = c[i].sortedNumber();
        }
        return highestNumber;
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return true;
    }

    @Override
    public int getID() {
        return 7;
    }
}

