/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.chip;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.shared.util.Vector2;
import net.minecraft.nbt.NBTTagCompound;

public class LogicChipLightBlue
extends LogicBase {
    public boolean active_hold;
    public int[] container_next = new int[2];
    public int[] container_hold = new int[2];
    public int[] container_current = new int[2];
    public double time_last;
    public double time_break;
    public int timer;
    public Vector2[] domino = new Vector2[]{new Vector2(-1, -1), new Vector2(-1, -1)};
    public List<Vector2> clear = new ArrayList<Vector2>();
    public int alpha;
    private List<Vector2> clear_temp = new ArrayList<Vector2>();

    public LogicChipLightBlue(int tableID) {
        super(tableID, 6, 15);
    }

    @Override
    public void start2() {
        this.active_hold = true;
        this.container_next[0] = this.dominoRoll();
        this.container_next[1] = this.dominoRoll();
        this.container_hold[0] = -1;
        this.container_hold[1] = -1;
        this.container_current[0] = this.dominoRoll();
        this.container_current[1] = this.dominoRoll();
        this.dominoCreate();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.grid[i][j] = -1;
            }
        }
        this.time_break = 200.0;
        this.time_last = 0.0;
        this.clear.clear();
        this.alpha = 255;
    }

    @Override
    public void command(int action) {
        if (action == 0) {
            this.commandTurn(true);
        }
        if (action == 1) {
            this.dominoDrop();
        }
        if (action == 2) {
            this.commandStrafe(true);
        }
        if (action == 3) {
            this.commandStrafe(false);
        }
        if (action == 4) {
            this.commandTurn(true);
        }
        if (action == 5) {
            this.commandTurn(false);
        }
        if (action == 6) {
            this.commandHold();
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void updateLogic() {
        this.timer += 15;
        if (this.alpha == 255) {
            if ((double)this.timer > this.time_last + this.time_break && this.turnstate == 2) {
                this.dominoFall();
                this.time_last = this.timer;
            }
        } else {
            this.alpha -= 10;
            if (this.alpha <= 0) {
                this.alpha = 255;
                for (int y = 0; y < 15; ++y) {
                    for (int x = 0; x < 10; ++x) {
                        if (!this.isCleared(x, y)) continue;
                        this.grid[x][y] = -1;
                    }
                }
                this.commandCollapse();
            }
        }
    }

    @Override
    public void load2(NBTTagCompound compound) {
        this.active_hold = compound.func_74767_n("activehold");
        this.container_next[0] = compound.func_74762_e("containernext0");
        this.container_next[1] = compound.func_74762_e("containernext1");
        this.container_hold[0] = compound.func_74762_e("containerhold0");
        this.container_hold[1] = compound.func_74762_e("containerhold1");
        this.container_current[0] = compound.func_74762_e("containercurrent0");
        this.container_current[1] = compound.func_74762_e("containercurrent1");
        this.time_last = compound.func_74769_h("timelast");
        this.time_break = compound.func_74769_h("timebreak");
        this.timer = compound.func_74762_e("timer");
        this.domino[0].set(compound.func_74762_e("domino0x"), compound.func_74762_e("domino0y"));
        this.domino[1].set(compound.func_74762_e("domino1x"), compound.func_74762_e("domino1y"));
        this.alpha = compound.func_74762_e("alpha");
    }

    @Override
    public NBTTagCompound save2(NBTTagCompound compound) {
        compound.func_74757_a("activehold", this.active_hold);
        compound.func_74768_a("container_next0", this.container_next[0]);
        compound.func_74768_a("container_next1", this.container_next[1]);
        compound.func_74768_a("container_hold0", this.container_hold[0]);
        compound.func_74768_a("container_hold1", this.container_hold[1]);
        compound.func_74768_a("container_current0", this.container_current[0]);
        compound.func_74768_a("container_current1", this.container_current[1]);
        compound.func_74780_a("timelast", this.time_last);
        compound.func_74780_a("timebreak", this.time_break);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("domino0x", this.domino[0].X);
        compound.func_74768_a("domino0y", this.domino[0].Y);
        compound.func_74768_a("domino1x", this.domino[1].X);
        compound.func_74768_a("domino1y", this.domino[1].Y);
        compound.func_74768_a("alpha", this.alpha);
        return compound;
    }

    public boolean inLine(int x, int y) {
        for (Vector2 v : this.clear) {
            if (!v.matches(x, y)) continue;
            return true;
        }
        return false;
    }

    private void dominoDrop() {
        int tempPoint = this.scorePoint;
        while (this.scorePoint == tempPoint) {
            this.dominoFall();
        }
    }

    private boolean isCleared(int x, int y) {
        for (int i = 0; i < this.clear.size(); ++i) {
            if (this.clear.get((int)i).X != x || this.clear.get((int)i).Y != y) continue;
            return true;
        }
        return false;
    }

    private void commandCollapse() {
        int temp = 0;
        for (int y = 13; y >= 0; --y) {
            for (int x = 0; x < 6; ++x) {
                if (this.grid[x][y] == -1) continue;
                temp = 0;
                while (y + temp + 1 < 15 && this.grid[x][y + temp + 1] == -1) {
                    ++temp;
                }
                if (temp == 0) continue;
                this.grid[x][y + temp] = this.grid[x][y];
                this.grid[x][y] = -1;
            }
        }
        this.clear.clear();
        this.alpha = 255;
        this.checkField();
    }

    private void commandStrafe(boolean totheleft) {
        int dir = 0;
        if (totheleft) {
            dir = -1;
            if (this.domino[0].X > 0 && this.domino[1].X > 0 && this.grid[this.domino[0].X + dir][this.domino[0].Y] == -1 && this.grid[this.domino[1].X + dir][this.domino[1].Y] == -1) {
                this.domino[0].X += dir;
                this.domino[1].X += dir;
            }
        } else {
            dir = 1;
            if (this.domino[0].X < 5 && this.domino[1].X < 5 && this.grid[this.domino[0].X + dir][this.domino[0].Y] == -1 && this.grid[this.domino[1].X + dir][this.domino[1].Y] == -1) {
                this.domino[0].X += dir;
                this.domino[1].X += dir;
            }
        }
    }

    private void commandTurn(boolean totheleft) {
        int pos = 0;
        if (this.domino[0].Y > this.domino[1].Y) {
            pos = 1;
        }
        if (this.domino[0].X > this.domino[1].X) {
            pos = 2;
        }
        if (this.domino[0].Y < this.domino[1].Y) {
            pos = 3;
        }
        if (this.domino[0].X < this.domino[1].X) {
            pos = 4;
        }
        if (totheleft) {
            if (pos == 1 && this.domino[0].X - 1 >= 0 && this.grid[this.domino[0].X - 1][this.domino[0].Y] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X - 1, this.domino[0].Y);
            }
            if (pos == 2 && this.domino[0].Y + 1 <= 14 && this.grid[this.domino[0].X][this.domino[0].Y + 1] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X, this.domino[0].Y + 1);
            }
            if (pos == 3 && this.domino[0].X + 1 <= 5 && this.grid[this.domino[0].X + 1][this.domino[0].Y] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X + 1, this.domino[0].Y);
            }
            if (pos == 4 && this.domino[0].Y - 1 >= 0 && this.grid[this.domino[0].X][this.domino[0].Y - 1] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X, this.domino[0].Y - 1);
            }
        } else {
            if (pos == 1 && this.domino[0].X + 1 <= 5 && this.grid[this.domino[0].X + 1][this.domino[0].Y] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X + 1, this.domino[0].Y);
            }
            if (pos == 2 && this.domino[0].Y - 1 >= 0 && this.grid[this.domino[0].X][this.domino[0].Y - 1] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X, this.domino[0].Y - 1);
            }
            if (pos == 3 && this.domino[0].X - 1 >= 0 && this.grid[this.domino[0].X - 1][this.domino[0].Y] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X - 1, this.domino[0].Y);
            }
            if (pos == 4 && this.domino[0].Y + 1 <= 14 && this.grid[this.domino[0].X][this.domino[0].Y + 1] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X, this.domino[0].Y + 1);
            }
        }
    }

    private void commandHold() {
        if (this.active_hold) {
            this.active_hold = false;
            if (this.container_hold[0] == -1) {
                this.container_hold[0] = this.container_current[0];
                this.container_hold[1] = this.container_current[1];
                this.container_current[0] = this.container_next[0];
                this.container_current[1] = this.container_next[1];
                this.container_next[0] = this.dominoRoll();
                this.container_next[1] = this.dominoRoll();
            } else {
                int[] temp = new int[]{this.container_hold[0], this.container_hold[1]};
                this.container_hold[0] = this.container_current[0];
                this.container_hold[1] = this.container_current[1];
                this.container_current[0] = temp[0];
                this.container_current[1] = temp[1];
            }
            this.dominoCreate();
        }
    }

    private int dominoRoll() {
        int r = this.RANDOM.nextInt(6) + 1;
        return r >= 3 ? r + 1 : r;
    }

    private void dominoCreate() {
        this.domino[0] = new Vector2(2, 1);
        this.domino[1] = new Vector2(2, 0);
    }

    private void dominoFall() {
        if (this.domino[0].Y < 14 && this.domino[1].Y < 14) {
            if (this.grid[this.domino[0].X][this.domino[0].Y + 1] == -1 && this.grid[this.domino[1].X][this.domino[1].Y + 1] == -1) {
                ++this.domino[0].Y;
                ++this.domino[1].Y;
            } else {
                this.dominoPlace();
            }
        } else {
            this.dominoPlace();
        }
    }

    private void dominoPlace() {
        this.active_hold = true;
        this.grid[this.domino[0].X][this.domino[0].Y] = this.container_current[0];
        this.grid[this.domino[1].X][this.domino[1].Y] = this.container_current[1];
        this.scorePoint += 4;
        if (this.domino[1].Y == 0) {
            this.turnstate = 4;
        }
        this.container_current[0] = this.container_next[0];
        this.container_current[1] = this.container_next[1];
        this.container_next[0] = this.dominoRoll();
        this.container_next[1] = this.dominoRoll();
        this.commandCollapse();
        this.dominoCreate();
        this.checkField();
    }

    private void checkField() {
        int points = 0;
        int bonus = 0;
        this.clear_temp.clear();
        for (int y = 14; y >= 0; --y) {
            for (int x = 0; x < 6; ++x) {
                if (this.isCleared(x, y)) continue;
                this.pathfinder(x, y);
                if (this.clear_temp.size() >= 4) {
                    points += this.clear_temp.size() * 10;
                    ++bonus;
                    this.clear.addAll(this.clear_temp);
                }
                this.clear_temp.clear();
            }
        }
        if (points > 0) {
            this.alpha -= 5;
            this.scorePoint += points * 2 * bonus * (this.scoreLevel + 1);
            ++this.scoreLives;
            if (this.scoreLives > (1 + this.scoreLevel) * 10) {
                ++this.scoreLevel;
                this.time_break -= this.time_break / 10.0;
            }
        }
    }

    private void pathfinder(int x, int y) {
        this.clear_temp.add(new Vector2(x, y));
        if (y - 1 >= 0 && this.grid[x][y] != -1 && this.grid[x][y] == this.grid[x][y - 1] && !this.isClearedTemp(x, y - 1)) {
            this.pathfinder(x, y - 1);
        }
        if (y + 1 <= 14 && this.grid[x][y] != -1 && this.grid[x][y] == this.grid[x][y + 1] && !this.isClearedTemp(x, y + 1)) {
            this.pathfinder(x, y + 1);
        }
        if (x - 1 >= 0 && this.grid[x][y] != -1 && this.grid[x][y] == this.grid[x - 1][y] && !this.isClearedTemp(x - 1, y)) {
            this.pathfinder(x - 1, y);
        }
        if (x + 1 <= 5 && this.grid[x][y] != -1 && this.grid[x][y] == this.grid[x + 1][y] && !this.isClearedTemp(x + 1, y)) {
            this.pathfinder(x + 1, y);
        }
    }

    private boolean isClearedTemp(int x, int y) {
        for (Vector2 vector2 : this.clear_temp) {
            if (vector2.X != x || vector2.Y != y) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 22;
    }
}

