/*
 * Decompiled with CFR 0.152.
 */
package mod.shared.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPillar
extends Block {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);

    public BlockPillar(String name, Material material, float hardness, float resistance) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149713_g(16);
        this.func_149715_a(0.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149675_a(false);
        if (material == Material.field_151573_f) {
            this.func_149672_a(SoundType.field_185852_e);
        } else if (material == Material.field_151592_s) {
            this.func_149672_a(SoundType.field_185853_f);
        } else if (material == Material.field_151595_p) {
            this.func_149672_a(SoundType.field_185855_h);
        } else if (material == Material.field_151576_e) {
            this.func_149672_a(SoundType.field_185851_d);
        } else if (material == Material.field_151575_d) {
            this.func_149672_a(SoundType.field_185848_a);
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("axis")) continue;
            world.func_175656_a(pos, state.func_177231_a(prop));
            return true;
        }
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Y;
        int i = meta & 0xC;
        if (i == 4) {
            enumfacing$axis = EnumFacing.Axis.X;
        } else if (i == 8) {
            enumfacing$axis = EnumFacing.Axis.Z;
        }
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)enumfacing$axis);
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            i |= 4;
        } else if (enumfacing$axis == EnumFacing.Axis.Z) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(AXIS, (Comparable)facing.func_176740_k());
    }
}

