/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.gui.minigames;

import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.gui.GuiCasino;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class Gui2048
extends GuiCasino {
    boolean placing;
    boolean active_timer;
    int timer;
    int direction;

    public Gui2048(InventoryPlayer playerInv, IInventory furnaceInv, int table) {
        super(playerInv, furnaceInv, table, CasinoKeeper.MODULE_2048);
        this.tc.gridI = new int[4][4];
        this.tc.gridB = new boolean[4][4];
    }

    @Override
    protected void mouseClicked2(double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    protected void keyTyped2(int keyCode) {
        if (!this.getFlag(17)) {
            if (keyCode == 265) {
                this.actionTouch(0);
            }
            if (keyCode == 264) {
                this.actionTouch(1);
            }
            if (keyCode == 263) {
                this.actionTouch(2);
            }
            if (keyCode == 262) {
                this.actionTouch(3);
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer2(int mouseX, int mouseY) {
        if (this.tc.turnstate >= 2) {
            this.field_146289_q.func_211126_b("" + this.tc.scorePoint, 32.0f, 232.0f, 9999999);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer2(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_ARCADEDUMMY);
        this.func_73729_b(this.field_147003_i, this.field_147009_r + this.intro, 0, 0, this.field_146999_f, this.field_147000_g - this.intro);
        if (this.tc.turnstate == 1 && this.intro < 176) {
            this.intro = 0;
            this.tc.turnstate = 2;
        }
        if (this.tc.turnstate >= 2) {
            if (this.tc.turnstate == 5) {
                GlStateManager.func_179131_c((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            }
            this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_2048);
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    int shiftX;
                    if (this.getValue(y * 4 + x) == 0) continue;
                    int n = this.getFlag(y * 4 + x) ? (this.getValue(17) == 4 ? this.getValue(16) : (this.getValue(17) == 3 ? -this.getValue(16) : 0)) : (shiftX = 0);
                    int shiftY = this.getFlag(y * 4 + x) ? (this.getValue(17) == 2 ? this.getValue(16) : (this.getValue(17) == 1 ? -this.getValue(16) : 0)) : 0;
                    this.func_73729_b(this.field_147003_i + 48 * x + 32 + shiftX, this.field_147009_r + 48 * y + 16 + shiftY, this.Get_Spritesheet(true, this.getValue(y * 4 + x)) * 48, this.Get_Spritesheet(false, this.getValue(y * 4 + x)) * 48, 48, 48);
                }
            }
            if (this.tc.turnstate == 5) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private int Get_Spritesheet(boolean x, int id) {
        if (x) {
            if (id == 1) {
                return 0;
            }
            if (id == 2) {
                return 1;
            }
            if (id == 3) {
                return 2;
            }
            if (id == 4) {
                return 3;
            }
            if (id == 5) {
                return 0;
            }
            if (id == 6) {
                return 1;
            }
            if (id == 7) {
                return 2;
            }
            if (id == 8) {
                return 3;
            }
            if (id == 9) {
                return 0;
            }
            if (id == 10) {
                return 1;
            }
            if (id == 11) {
                return 2;
            }
            if (id == 12) {
                return 3;
            }
        } else {
            if (id == 1) {
                return 0;
            }
            if (id == 2) {
                return 0;
            }
            if (id == 3) {
                return 0;
            }
            if (id == 4) {
                return 0;
            }
            if (id == 5) {
                return 1;
            }
            if (id == 6) {
                return 1;
            }
            if (id == 7) {
                return 1;
            }
            if (id == 8) {
                return 1;
            }
            if (id == 9) {
                return 2;
            }
            if (id == 10) {
                return 2;
            }
            if (id == 11) {
                return 2;
            }
            if (id == 12) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void start2() {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.tc.gridI[x][y] = 0;
                this.tc.gridB[x][y] = false;
            }
        }
        this.placing = false;
        this.tc.gridI[0][0] = this.tc.rand.nextInt(1) + 1;
        this.tc.gridI[3][0] = this.tc.rand.nextInt(1) + 1;
        this.tc.gridI[0][3] = this.tc.rand.nextInt(1) + 1;
        this.tc.gridI[3][3] = this.tc.rand.nextInt(1) + 1;
        this.active_timer = false;
        this.timer = 0;
        this.direction = 0;
    }

    @Override
    public void actionTouch(int action) {
        if (action == 0) {
            this.Move(1);
        }
        if (action == 1) {
            this.Move(2);
        }
        if (action == 2) {
            this.Move(3);
        }
        if (action == 3) {
            this.Move(4);
        }
    }

    @Override
    public void update() {
        if (this.active_timer) {
            this.timer += 6;
            if (this.timer == 48) {
                this.active_timer = false;
                this.timer = 0;
                this.Change();
                this.Move(this.direction);
                this.placing = true;
            }
        } else {
            if (this.placing) {
                this.Place();
                this.placing = false;
            }
            this.direction = 0;
        }
    }

    @Override
    public int getValue(int index) {
        if (index == 16) {
            return this.timer;
        }
        if (index == 17) {
            return this.direction;
        }
        return this.tc.gridI[index % 4][index / 4];
    }

    @Override
    public boolean getFlag(int index) {
        if (index == 16) {
            return this.placing;
        }
        if (index == 17) {
            return this.active_timer;
        }
        return this.tc.gridB[index % 4][index / 4];
    }

    private void Move(int s) {
        int y;
        int x;
        int x2;
        int y2;
        if (s == 1) {
            for (y2 = 1; y2 < 4; ++y2) {
                for (x2 = 0; x2 < 4; ++x2) {
                    if (this.tc.gridI[x2][y2] == 0 || this.tc.gridI[x2][y2 - 1] != 0 && this.tc.gridI[x2][y2 - 1] != this.tc.gridI[x2][y2]) continue;
                    this.tc.gridB[x2][y2] = true;
                    this.active_timer = true;
                    this.direction = s;
                }
            }
        }
        if (s == 2) {
            for (y2 = 2; y2 > -1; --y2) {
                for (x2 = 3; x2 > -1; --x2) {
                    if (this.tc.gridI[x2][y2] == 0 || this.tc.gridI[x2][y2 + 1] != 0 && this.tc.gridI[x2][y2 + 1] != this.tc.gridI[x2][y2]) continue;
                    this.tc.gridB[x2][y2] = true;
                    this.active_timer = true;
                    this.direction = s;
                }
            }
        }
        if (s == 3) {
            for (x = 1; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    if (this.tc.gridI[x][y] == 0 || this.tc.gridI[x - 1][y] != 0 && this.tc.gridI[x - 1][y] != this.tc.gridI[x][y]) continue;
                    this.tc.gridB[x][y] = true;
                    this.active_timer = true;
                    this.direction = s;
                }
            }
        }
        if (s == 4) {
            for (x = 2; x > -1; --x) {
                for (y = 3; y > -1; --y) {
                    if (this.tc.gridI[x][y] == 0 || this.tc.gridI[x + 1][y] != 0 && this.tc.gridI[x + 1][y] != this.tc.gridI[x][y]) continue;
                    this.tc.gridB[x][y] = true;
                    this.active_timer = true;
                    this.direction = s;
                }
            }
        }
    }

    private void Change() {
        int y;
        int x;
        int x2;
        int y2;
        if (this.direction == 1) {
            for (y2 = 1; y2 < 4; ++y2) {
                for (x2 = 0; x2 < 4; ++x2) {
                    if (!this.tc.gridB[x2][y2]) continue;
                    if (this.tc.gridI[x2][y2 - 1] == 0) {
                        this.tc.gridI[x2][y2 - 1] = this.tc.gridI[x2][y2];
                    } else {
                        int[] nArray = this.tc.gridI[x2];
                        int n = y2 - 1;
                        nArray[n] = nArray[n] + 1;
                        this.Add_Points(this.tc.gridI[x2][y2 - 1]);
                    }
                    this.tc.gridI[x2][y2] = 0;
                }
            }
        }
        if (this.direction == 2) {
            for (y2 = 2; y2 > -1; --y2) {
                for (x2 = 3; x2 > -1; --x2) {
                    if (!this.tc.gridB[x2][y2]) continue;
                    if (this.tc.gridI[x2][y2 + 1] == 0) {
                        this.tc.gridI[x2][y2 + 1] = this.tc.gridI[x2][y2];
                    } else {
                        int[] nArray = this.tc.gridI[x2];
                        int n = y2 + 1;
                        nArray[n] = nArray[n] + 1;
                        this.Add_Points(this.tc.gridI[x2][y2 + 1]);
                    }
                    this.tc.gridI[x2][y2] = 0;
                }
            }
        }
        if (this.direction == 3) {
            for (x = 1; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    if (!this.tc.gridB[x][y]) continue;
                    if (this.tc.gridI[x - 1][y] == 0) {
                        this.tc.gridI[x - 1][y] = this.tc.gridI[x][y];
                    } else {
                        int[] nArray = this.tc.gridI[x - 1];
                        int n = y;
                        nArray[n] = nArray[n] + 1;
                        this.Add_Points(this.tc.gridI[x - 1][y]);
                    }
                    this.tc.gridI[x][y] = 0;
                }
            }
        }
        if (this.direction == 4) {
            for (x = 2; x > -1; --x) {
                for (y = 3; y > -1; --y) {
                    if (!this.tc.gridB[x][y]) continue;
                    if (this.tc.gridI[x + 1][y] == 0) {
                        this.tc.gridI[x + 1][y] = this.tc.gridI[x][y];
                    } else {
                        int[] nArray = this.tc.gridI[x + 1];
                        int n = y;
                        nArray[n] = nArray[n] + 1;
                        this.Add_Points(this.tc.gridI[x + 1][y]);
                    }
                    this.tc.gridI[x][y] = 0;
                }
            }
        }
        for (y2 = 0; y2 < 4; ++y2) {
            for (x2 = 0; x2 < 4; ++x2) {
                this.tc.gridB[x2][y2] = false;
            }
        }
    }

    private void Place() {
        for (int i = 0; i < 24; ++i) {
            int y;
            int x = this.tc.rand.nextInt(4);
            if (this.tc.gridI[x][y = this.tc.rand.nextInt(4)] != 0) continue;
            this.tc.gridI[x][y] = 1;
            break;
        }
        this.Check();
    }

    private void Check() {
        int y;
        int x;
        int x2;
        int y2;
        boolean b = false;
        for (y2 = 1; y2 < 4; ++y2) {
            for (x2 = 0; x2 < 4; ++x2) {
                if (this.tc.gridI[x2][y2] == 0 || this.tc.gridI[x2][y2 - 1] != 0 && this.tc.gridI[x2][y2 - 1] != this.tc.gridI[x2][y2]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (y2 = 2; y2 > -1; --y2) {
            for (x2 = 3; x2 > -1; --x2) {
                if (this.tc.gridI[x2][y2] == 0 || this.tc.gridI[x2][y2 + 1] != 0 && this.tc.gridI[x2][y2 + 1] != this.tc.gridI[x2][y2]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (x = 1; x < 4; ++x) {
            for (y = 0; y < 4; ++y) {
                if (this.tc.gridI[x][y] == 0 || this.tc.gridI[x - 1][y] != 0 && this.tc.gridI[x - 1][y] != this.tc.gridI[x][y]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (x = 2; x > -1; --x) {
            for (y = 3; y > -1; --y) {
                if (this.tc.gridI[x][y] == 0 || this.tc.gridI[x + 1][y] != 0 && this.tc.gridI[x + 1][y] != this.tc.gridI[x][y]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        if (!b) {
            this.tc.turnstate = 4;
        }
    }

    private int Get_Direction(boolean horizontal, int x, int y) {
        if (this.direction == 0) {
            return 0;
        }
        if (horizontal && this.direction == 3 && this.tc.gridB[x][y]) {
            return -this.timer;
        }
        if (horizontal && this.direction == 4 && this.tc.gridB[x][y]) {
            return this.timer;
        }
        if (!horizontal && this.direction == 1 && this.tc.gridB[x][y]) {
            return -this.timer;
        }
        if (!horizontal && this.direction == 2 && this.tc.gridB[x][y]) {
            return this.timer;
        }
        return 0;
    }

    private void Add_Points(int i) {
        if (i == 1) {
            this.tc.scorePoint += 2;
        }
        if (i == 2) {
            this.tc.scorePoint += 4;
        }
        if (i == 3) {
            this.tc.scorePoint += 8;
        }
        if (i == 4) {
            this.tc.scorePoint += 16;
        }
        if (i == 5) {
            this.tc.scorePoint += 32;
        }
        if (i == 6) {
            this.tc.scorePoint += 64;
        }
        if (i == 7) {
            this.tc.scorePoint += 128;
        }
        if (i == 8) {
            this.tc.scorePoint += 256;
        }
        if (i == 9) {
            this.tc.scorePoint += 512;
        }
        if (i == 10) {
            this.tc.scorePoint += 1024;
        }
        if (i == 11) {
            this.tc.scorePoint += 2048;
        }
        if (i == 12) {
            this.tc.scorePoint += 4096;
        }
        if (i == 13) {
            this.tc.scorePoint += 8192;
        }
        if (i == 14) {
            this.tc.scorePoint += 16384;
        }
        if (i == 15) {
            this.tc.scorePoint += 32768;
        }
        if (i == 16) {
            this.tc.scorePoint += 65536;
        }
    }
}

