/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.gui.minigames;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.gui.GuiCasino;
import mod.casinocraft.util.Card;
import mod.shared.util.Vector2;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class GuiFreeCell
extends GuiCasino {
    List<Card>[] cards_field = new ArrayList[8];
    List<Card>[] cards_finish = new ArrayList[4];
    Card[] cards_freecell = new Card[4];
    float compress;
    float compressDisplay;
    int timer;

    public GuiFreeCell(InventoryPlayer playerInv, IInventory furnaceInv, int table) {
        super(playerInv, furnaceInv, table, CasinoKeeper.MODULE_FREECELL);
    }

    @Override
    protected void mouseClicked2(double mouseX, double mouseY, int mouseButton) {
        if (this.tc.turnstate == 2 && mouseButton == 0) {
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 20; ++y) {
                    if (!this.mouseRect(0 + 32 * x, 64 + (24 - this.getValue(0)) * y, 32, 24, mouseX, mouseY)) continue;
                    this.actionTouch(x + y * 8);
                }
                if (!this.mouseRect(0 + 32 * x, 16, 32, 48, mouseX, mouseY)) continue;
                this.actionTouch((x + 1) * -1);
            }
        }
    }

    @Override
    protected void keyTyped2(int keyCode) {
        if (this.tc.turnstate == 2 && keyCode == 257) {
            this.actionTouch(-9);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer2(int mouseX, int mouseY) {
    }

    @Override
    protected void drawGuiContainerBackgroundLayer2(float partialTicks, int mouseX, int mouseY) {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < this.getCardStack(x).size(); ++y) {
                this.drawCard(x * 32, 64 + y * (24 - this.getValue(0)), this.getCardStack(x).get(y));
            }
        }
        this.drawCardBack(0, 16, 12);
        this.drawCardBack(32, 16, 12);
        this.drawCardBack(64, 16, 12);
        this.drawCardBack(96, 16, 12);
        this.drawCardBack(128, 16, 7);
        this.drawCardBack(160, 16, 7);
        this.drawCardBack(192, 16, 7);
        this.drawCardBack(224, 16, 7);
        this.drawCard(0, 16, this.getCard(0));
        this.drawCard(32, 16, this.getCard(1));
        this.drawCard(64, 16, this.getCard(2));
        this.drawCard(96, 16, this.getCard(3));
        if (this.getCardStack(8).size() > 0) {
            this.drawCard(128, 16, this.getCardStack(8).get(this.getCardStack(8).size() - 1));
        }
        if (this.getCardStack(9).size() > 0) {
            this.drawCard(160, 16, this.getCardStack(9).get(this.getCardStack(9).size() - 1));
        }
        if (this.getCardStack(10).size() > 0) {
            this.drawCard(192, 16, this.getCardStack(10).get(this.getCardStack(10).size() - 1));
        }
        if (this.getCardStack(11).size() > 0) {
            this.drawCard(224, 16, this.getCardStack(11).get(this.getCardStack(11).size() - 1));
        }
        if (this.tc.selector.Y == -2) {
            this.drawCardBack(this.tc.selector.X * 32, 16, 9);
        } else if (this.tc.selector.Y >= 0) {
            this.drawCardBack(this.tc.selector.X * 32, 64 + this.tc.selector.Y * (24 - this.getValue(0)), 9);
        }
    }

    @Override
    public void start2() {
        List<Card> deck = this.ShuffleDeck();
        this.cards_field[0] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[0], deck, 0, 7);
        this.cards_field[1] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[1], deck, 0, 7);
        this.cards_field[2] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[2], deck, 0, 7);
        this.cards_field[3] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[3], deck, 0, 7);
        this.cards_field[4] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[4], deck, 0, 6);
        this.cards_field[5] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[5], deck, 0, 6);
        this.cards_field[6] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[6], deck, 0, 6);
        this.cards_field[7] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[7], deck, 0, 6);
        this.cards_finish[0] = new ArrayList<Card>();
        this.cards_finish[1] = new ArrayList<Card>();
        this.cards_finish[2] = new ArrayList<Card>();
        this.cards_finish[3] = new ArrayList<Card>();
        this.cards_freecell[0] = new Card(-1, -1);
        this.cards_freecell[1] = new Card(-1, -1);
        this.cards_freecell[2] = new Card(-1, -1);
        this.cards_freecell[3] = new Card(-1, -1);
        this.tc.selector = new Vector2(-1, -1);
        this.compress = 4.0f;
        this.compressDisplay = 4.0f;
        this.timer = -1;
        for (int x = 0; x < 8; ++x) {
            int y = 0;
            for (Card c : this.cards_field[x]) {
                c.setShift(0, -20 * y, 60 - 10 * y + x * 3);
                ++y;
            }
        }
    }

    @Override
    public void actionTouch(int action) {
        if (this.timer == -1) {
            if (action == -1) {
                this.Free_Cell(0);
            }
            if (action == -2) {
                this.Free_Cell(1);
            }
            if (action == -3) {
                this.Free_Cell(2);
            }
            if (action == -4) {
                this.Free_Cell(3);
            }
            if (action == -5) {
                this.TouchFinish(0);
            }
            if (action == -6) {
                this.TouchFinish(1);
            }
            if (action == -7) {
                this.TouchFinish(2);
            }
            if (action == -8) {
                this.TouchFinish(3);
            }
            if (action == -9) {
                this.timer = 1;
            }
            if (action >= 0) {
                this.TouchField(action % 8, action / 8);
            }
        }
    }

    @Override
    public void update() {
        int x;
        if (this.timer == 0) {
            int x2;
            int x1;
            --this.timer;
            boolean[] done = new boolean[4];
            done[3] = false;
            done[2] = false;
            done[1] = false;
            done[0] = false;
            for (x1 = 0; x1 < 4; ++x1) {
                if (this.cards_freecell[x1].suit == -1) continue;
                for (x2 = 0; x2 < 4; ++x2) {
                    if (this.cards_finish[x2].size() == 0) {
                        if (this.cards_freecell[x1].number != 0 || done[x2]) continue;
                        this.cards_freecell[x1].setShift(0, 16, 0);
                        this.cards_finish[x2].add(new Card(this.cards_freecell[x1]));
                        this.cards_freecell[x1].set(-1, -1);
                        this.tc.selector.set(-1, -1);
                        this.timer = 16;
                        done[x2] = true;
                        continue;
                    }
                    if (this.cards_freecell[x1].number - 1 != this.cards_finish[x2].get((int)(this.cards_finish[x2].size() - 1)).number || this.cards_finish[x2].get((int)(this.cards_finish[x2].size() - 1)).suit != this.cards_freecell[x1].suit || done[x2]) continue;
                    this.cards_freecell[x1].setShift(0, 16, 0);
                    this.cards_finish[x2].add(this.cards_freecell[x1]);
                    this.cards_freecell[x1].set(-1, -1);
                    this.tc.selector.set(-1, -1);
                    this.timer = 16;
                    done[x2] = true;
                }
            }
            for (x1 = 0; x1 < 8; ++x1) {
                for (x2 = 0; x2 < 4; ++x2) {
                    if (this.cards_field[x1].size() <= 0) continue;
                    if (this.cards_finish[x2].size() == 0) {
                        if (this.cards_field[x1].get((int)(this.cards_field[x1].size() - 1)).number != 0 || done[x2]) continue;
                        this.cards_field[x1].get(this.cards_field[x1].size() - 1).setShift(0, 16, 0);
                        this.cards_finish[x2].add(this.cards_field[x1].get(this.cards_field[x1].size() - 1));
                        this.cards_field[x1].remove(this.cards_field[x1].size() - 1);
                        this.tc.selector.set(-1, -1);
                        this.timer = 16;
                        done[x2] = true;
                        continue;
                    }
                    if (this.cards_field[x1].get((int)(this.cards_field[x1].size() - 1)).number - 1 != this.cards_finish[x2].get((int)(this.cards_finish[x2].size() - 1)).number || this.cards_finish[x2].get((int)(this.cards_finish[x2].size() - 1)).suit != this.cards_field[x1].get((int)(this.cards_field[x1].size() - 1)).suit || done[x2]) continue;
                    this.cards_field[x1].get(this.cards_field[x1].size() - 1).setShift(0, 16, 0);
                    this.cards_finish[x2].add(this.cards_field[x1].get(this.cards_field[x1].size() - 1));
                    this.cards_field[x1].remove(this.cards_field[x1].size() - 1);
                    this.tc.selector.set(-1, -1);
                    this.timer = 16;
                    done[x2] = true;
                }
            }
            this.Compress();
        } else if (this.timer > 0) {
            --this.timer;
        }
        for (x = 0; x < 8; ++x) {
            if (this.cards_field[x].size() <= 0) continue;
            for (Card c : this.cards_field[x]) {
                c.update();
            }
        }
        for (x = 0; x < 4; ++x) {
            if (this.cards_finish[x].size() <= 0) continue;
            for (Card c : this.cards_finish[x]) {
                c.update();
            }
        }
        for (x = 0; x < 4; ++x) {
            this.cards_freecell[x].update();
        }
        if (this.tc.turnstate == 2 && this.cards_finish[0].size() == 13 && this.cards_finish[1].size() == 13 && this.cards_finish[2].size() == 13 && this.cards_finish[3].size() == 13 && this.tc.turnstate < 4) {
            this.tc.scorePoint = 100;
            this.tc.turnstate = 4;
        }
        if (this.compressDisplay > this.compress) {
            this.compressDisplay -= 0.25f;
            if (this.compressDisplay < this.compress) {
                this.compressDisplay = this.compress;
            }
        }
        if (this.compressDisplay < this.compress) {
            this.compressDisplay += 0.25f;
            if (this.compressDisplay > this.compress) {
                this.compressDisplay = this.compress;
            }
        }
    }

    @Override
    public int getValue(int index) {
        return (int)this.compressDisplay;
    }

    @Override
    public Card getCard(int index) {
        return this.cards_freecell[index];
    }

    @Override
    public List<Card> getCardStack(int index) {
        if (index >= 8) {
            return this.cards_finish[index - 8];
        }
        return this.cards_field[index];
    }

    private void TransferCards(List<Card> cards_field2, List<Card> deck, int position, int count) {
        for (int i = position; i < position + count; ++i) {
            cards_field2.add(deck.get(position));
            deck.remove(position);
        }
    }

    private void TransferCards(List<Card> cards_field2, List<Card> deck, int position, int count, int shiftX, int shiftY) {
        for (int i = position; i < position + count; ++i) {
            deck.get(position).setShift(shiftX, shiftY, 0);
            cards_field2.add(deck.get(position));
            deck.remove(position);
        }
    }

    private List<Card> ShuffleDeck() {
        ArrayList<Card> stack = new ArrayList<Card>();
        ArrayList<Card> deck = new ArrayList<Card>();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 13; ++x) {
                stack.add(new Card(x, y));
            }
        }
        while (stack.size() > 1) {
            int r = this.tc.rand.nextInt(stack.size() - 1);
            deck.add((Card)stack.get(r));
            stack.remove(r);
        }
        deck.add((Card)stack.get(0));
        return deck;
    }

    private void Free_Cell(int cell) {
        if (this.tc.selector.matches(-1, -1)) {
            if (!this.cards_freecell[cell].equals(-1, -1)) {
                this.tc.selector.set(cell, -2);
            }
        } else if (this.tc.selector.Y >= 0 && this.cards_freecell[cell].suit == -1 && this.tc.selector.Y == this.cards_field[this.tc.selector.X].size() - 1) {
            this.cards_field[this.tc.selector.X].get(this.cards_field[this.tc.selector.X].size() - 1).setShift(0, 16, 0);
            this.cards_freecell[cell] = this.cards_field[this.tc.selector.X].get(this.cards_field[this.tc.selector.X].size() - 1);
            this.cards_field[this.tc.selector.X].remove(this.cards_field[this.tc.selector.X].size() - 1);
            this.tc.selector.set(-1, -1);
        }
    }

    private void TouchFinish(int slot) {
        if (!this.tc.selector.matches(-1, -1)) {
            if (this.tc.selector.Y == -2) {
                if (this.cards_finish[slot].size() == 0) {
                    if (this.cards_freecell[this.tc.selector.X].number == 0) {
                        this.cards_freecell[this.tc.selector.X].setShift(0, 16, 0);
                        this.cards_finish[slot].add(new Card(this.cards_freecell[this.tc.selector.X]));
                        this.cards_freecell[this.tc.selector.X].set(-1, -1);
                        this.tc.selector.set(-1, -1);
                    }
                } else if (this.cards_freecell[this.tc.selector.X].number - 1 == this.cards_finish[slot].get((int)(this.cards_finish[slot].size() - 1)).number && this.cards_finish[slot].get((int)(this.cards_finish[slot].size() - 1)).suit == this.cards_freecell[this.tc.selector.X].suit) {
                    this.cards_freecell[this.tc.selector.X].setShift(0, 16, 0);
                    this.cards_finish[slot].add(new Card(this.cards_freecell[this.tc.selector.X]));
                    this.cards_freecell[this.tc.selector.X].set(-1, -1);
                    this.tc.selector.set(-1, -1);
                }
            } else if (this.tc.selector.Y == this.cards_field[this.tc.selector.X].size() - 1) {
                if (this.cards_finish[slot].size() == 0) {
                    if (this.cards_field[this.tc.selector.X].get((int)(this.cards_field[this.tc.selector.X].size() - 1)).number == 0) {
                        this.cards_field[this.tc.selector.X].get(this.cards_field[this.tc.selector.X].size() - 1).setShift(0, 16, 0);
                        this.cards_finish[slot].add(this.cards_field[this.tc.selector.X].get(this.cards_field[this.tc.selector.X].size() - 1));
                        this.cards_field[this.tc.selector.X].remove(this.cards_field[this.tc.selector.X].size() - 1);
                        this.tc.selector.set(-1, -1);
                    }
                } else if (this.cards_field[this.tc.selector.X].get((int)this.tc.selector.Y).number - 1 == this.cards_finish[slot].get((int)(this.cards_finish[slot].size() - 1)).number && this.cards_finish[slot].get((int)(this.cards_finish[slot].size() - 1)).suit == this.cards_field[this.tc.selector.X].get((int)this.tc.selector.Y).suit) {
                    this.cards_field[this.tc.selector.X].get(this.cards_field[this.tc.selector.X].size() - 1).setShift(0, 16, 0);
                    this.cards_finish[slot].add(this.cards_field[this.tc.selector.X].get(this.cards_field[this.tc.selector.X].size() - 1));
                    this.cards_field[this.tc.selector.X].remove(this.cards_field[this.tc.selector.X].size() - 1);
                    this.tc.selector.set(-1, -1);
                }
            }
        }
        this.Compress();
    }

    private void TouchField(int x, int y) {
        int x2 = x;
        int y2 = y;
        if (this.tc.selector.Y == -2) {
            if (!this.MoveStack(x, y)) {
                this.tc.selector.set(-1, -1);
            }
        } else if (this.cards_field[x2].size() >= y2 - 1) {
            if (this.tc.selector.matches(-1, -1)) {
                y2 = this.cards_field[x2].size() <= y2 ? this.cards_field[x2].size() - 1 : y2;
                float tempCard = this.cards_field[x2].get((int)y2).number;
                float tempSuit = this.cards_field[x2].get((int)y2).suit;
                for (int i = y2; i < this.cards_field[x2].size(); ++i) {
                    if (i == this.cards_field[x2].size() - 1 || (this.cards_field[x2].get((int)i).number - 1 == this.cards_field[x2].get((int)(i + 1)).number || this.cards_field[x2].get((int)i).number == 1 && this.cards_field[x2].get((int)(i + 1)).number == 13) && this.DifferentColors(this.cards_field[x2].get((int)i).suit, this.cards_field[x2].get((int)(i + 1)).suit)) continue;
                    return;
                }
                this.tc.selector.set(x2, y2);
            } else if (!this.MoveStack(x, y)) {
                this.tc.selector.set(-1, -1);
            }
        }
        this.Compress();
    }

    private boolean MoveStack(int x, int y) {
        int x2 = x;
        int y2 = this.cards_field[x2].size() - 1;
        if (this.tc.selector.Y != -2) {
            if (this.cards_field[x2].size() == 0) {
                this.TransferCards(this.cards_field[x2], this.cards_field[this.tc.selector.X], this.tc.selector.Y, this.cards_field[this.tc.selector.X].size() - this.tc.selector.Y, 0, 16);
                this.tc.selector.set(-1, -1);
                return true;
            }
            if (this.cards_field[this.tc.selector.X].get((int)this.tc.selector.Y).number + 1 == this.cards_field[x2].get((int)y2).number && this.DifferentColors(this.cards_field[x2].get((int)y2).suit, this.cards_field[this.tc.selector.X].get((int)this.tc.selector.Y).suit)) {
                this.TransferCards(this.cards_field[x2], this.cards_field[this.tc.selector.X], this.tc.selector.Y, this.cards_field[this.tc.selector.X].size() - this.tc.selector.Y, 0, 16);
                this.tc.selector.set(-1, -1);
                return true;
            }
        } else {
            if (this.cards_field[x2].size() == 0) {
                this.cards_freecell[this.tc.selector.X].setShift(0, 16, 0);
                this.cards_field[x2].add(new Card(this.cards_freecell[this.tc.selector.X]));
                this.cards_freecell[this.tc.selector.X].set(-1, -1);
                this.tc.selector.set(-1, -1);
                return true;
            }
            if (this.cards_freecell[this.tc.selector.X].number + 1 == this.cards_field[x2].get((int)y2).number && this.DifferentColors(this.cards_field[x2].get((int)y2).suit, this.cards_freecell[this.tc.selector.X].suit)) {
                this.cards_freecell[this.tc.selector.X].setShift(0, 16, 0);
                this.cards_field[x2].add(new Card(this.cards_freecell[this.tc.selector.X]));
                this.cards_freecell[this.tc.selector.X].set(-1, -1);
                this.tc.selector.set(-1, -1);
                return true;
            }
        }
        return false;
    }

    private void Compress() {
        int i = 0;
        for (int x = 0; x < 8; ++x) {
            if (this.cards_field[x].size() <= i) continue;
            i = this.cards_field[x].size();
        }
        this.compress = i > 6 ? (float)(i - 3) : 0.0f;
    }

    private boolean DifferentColors(float a, float b) {
        if (!(a != 0.0f && a != 1.0f || b != 2.0f && b != 3.0f)) {
            return true;
        }
        if (a == 2.0f || a == 3.0f) {
            return b == 0.0f || b == 1.0f;
        }
        return false;
    }
}

