/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.gui.minigames;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.gui.GuiCasino;
import mod.shared.util.Vector2;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class GuiMeanMinos
extends GuiCasino {
    public boolean active_hold;
    public int[] container_next = new int[2];
    public int[] container_hold = new int[2];
    public int[] container_current = new int[2];
    public double time_last;
    public double time_break;
    public int timer;
    public Vector2[] domino = new Vector2[2];
    public List<Vector2> clear = new ArrayList<Vector2>();
    public int alpha;
    List<Vector2> clear_temp = new ArrayList<Vector2>();

    public GuiMeanMinos(InventoryPlayer playerInv, IInventory furnaceInv, int table) {
        super(playerInv, furnaceInv, table, CasinoKeeper.MODULE_MEANMINOS);
        this.tc.gridI = new int[6][15];
    }

    @Override
    protected void mouseClicked2(double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    protected void keyTyped2(int keyCode) {
        if (keyCode == 265) {
            this.actionTouch(0);
        }
        if (keyCode == 264) {
            this.actionTouch(1);
        }
        if (keyCode == 263) {
            this.actionTouch(2);
        }
        if (keyCode == 262) {
            this.actionTouch(3);
        }
        if (keyCode == 77) {
            this.actionTouch(4);
        }
        if (keyCode == 78) {
            this.actionTouch(5);
        }
        if (keyCode == 257) {
            this.actionTouch(6);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer2(int mouseX, int mouseY) {
        if (this.tc.turnstate >= 2) {
            this.field_146289_q.func_211126_b("" + this.tc.scorePoint, 164.0f, 20.0f, 9999999);
            this.field_146289_q.func_211126_b("" + this.tc.scoreLives, 164.0f, 36.0f, 9999999);
            this.field_146289_q.func_211126_b("" + this.tc.scoreLevel, 164.0f, 52.0f, 9999999);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer2(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_MEANMINOS);
        this.func_73729_b(this.field_147003_i, this.field_147009_r + this.intro, 0, 0, this.field_146999_f, this.field_147000_g - this.intro);
        if (this.tc.turnstate >= 2) {
            this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_OCTAGAMES);
            for (int y = 0; y < 15; ++y) {
                for (int x = 0; x < 6; ++x) {
                    if (this.getValue(y * 6 + x) == -1) continue;
                    this.func_73729_b(this.field_147003_i + 16 + 8 + 16 + 16 * x, this.field_147009_r + 8 + 16 * y, this.tc.turnstate >= 4 ? 128 : 16 * this.getValue(y * 6 + x), 216, 16, 16);
                }
            }
            this.func_73729_b(this.field_147003_i + 8 + 16 + 16 + 16 * this.getValue(200), this.field_147009_r + 8 + 16 * this.getValue(201), this.tc.turnstate >= 4 ? 128 : 16 * this.getValue(210), 216, 16, 16);
            this.func_73729_b(this.field_147003_i + 8 + 16 + 16 + 16 * this.getValue(202), this.field_147009_r + 8 + 16 * this.getValue(203), this.tc.turnstate >= 4 ? 128 : 16 * this.getValue(211), 216, 16, 16);
            if (this.getValue(212) > -1) {
                this.drawTetromino(this.getValue(212), this.getValue(213), 156, 80);
            }
            if (this.getValue(214) > -1) {
                this.drawTetromino(this.getValue(214), this.getValue(215), 156, 160);
            }
        }
    }

    private void drawTetromino(int mino0, int mino1, int x, int y) {
        this.func_73729_b(this.field_147003_i + x + 24, this.field_147009_r + y + 16, this.tc.turnstate >= 4 ? 128 : 16 * mino1, 216, 16, 16);
        this.func_73729_b(this.field_147003_i + x + 24, this.field_147009_r + y + 32, this.tc.turnstate >= 4 ? 128 : 16 * mino0, 216, 16, 16);
    }

    @Override
    public void start2() {
        this.active_hold = true;
        this.container_next[0] = this.Domino_Roll();
        this.container_next[1] = this.Domino_Roll();
        this.container_hold[0] = -1;
        this.container_hold[1] = -1;
        this.container_current[0] = this.Domino_Roll();
        this.container_current[1] = this.Domino_Roll();
        this.Domino_Create();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.tc.gridI[i][j] = -1;
            }
        }
        this.time_break = 500.0;
        this.time_last = 0.0;
        this.clear.clear();
        this.alpha = 255;
    }

    @Override
    public void actionTouch(int action) {
        if (action == 0) {
            this.Domino_Drop();
        }
        if (action == 1) {
            this.Domino_Fall();
        }
        if (action == 2) {
            this.Command_Strafe(true);
        }
        if (action == 3) {
            this.Command_Strafe(false);
        }
        if (action == 4) {
            this.Command_Turn(true);
        }
        if (action == 5) {
            this.Command_Turn(false);
        }
        if (action == 6) {
            this.Command_Hold();
        }
    }

    @Override
    public void update() {
        this.timer += 15;
        if (this.alpha == 255) {
            if ((double)this.timer > this.time_last + this.time_break && this.tc.turnstate == 2) {
                this.Domino_Fall();
                this.time_last = this.timer;
            }
        } else {
            this.alpha -= 10;
            if (this.alpha <= 0) {
                this.alpha = 255;
                for (int y = 0; y < 15; ++y) {
                    for (int x = 0; x < 10; ++x) {
                        if (!this.IsCleared(x, y)) continue;
                        this.tc.gridI[x][y] = -1;
                    }
                }
                this.Command_Collapse();
            }
        }
    }

    @Override
    public int getValue(int index) {
        if (index == 200) {
            return this.domino[0].X;
        }
        if (index == 201) {
            return this.domino[0].Y;
        }
        if (index == 202) {
            return this.domino[1].X;
        }
        if (index == 203) {
            return this.domino[1].Y;
        }
        if (index == 210) {
            return this.tc.turnstate >= 4 ? 8 : this.container_current[0];
        }
        if (index == 211) {
            return this.tc.turnstate >= 4 ? 8 : this.container_current[1];
        }
        if (index == 212) {
            return this.tc.turnstate >= 4 ? 8 : this.container_next[0];
        }
        if (index == 213) {
            return this.tc.turnstate >= 4 ? 8 : this.container_next[1];
        }
        if (index == 214) {
            return this.tc.turnstate >= 4 ? -1 : this.container_hold[0];
        }
        if (index == 215) {
            return this.tc.turnstate >= 4 ? -1 : this.container_hold[1];
        }
        if (index == -1) {
            return this.tc.scorePoint;
        }
        if (index == -2) {
            return this.tc.scoreLives;
        }
        if (index == -3) {
            return this.tc.scoreLevel;
        }
        return this.inLine(index % 6, index / 6) && this.alpha / 75 % 2 == 0 ? 7 : this.tc.gridI[index % 6][index / 6];
    }

    private boolean inLine(int x, int y) {
        for (Vector2 v : this.clear) {
            if (!v.matches(x, y)) continue;
            return true;
        }
        return false;
    }

    private void Domino_Drop() {
        int tempPoint = this.tc.scorePoint;
        while (this.tc.scorePoint == tempPoint) {
            this.Domino_Fall();
        }
    }

    private boolean IsCleared(int x, int y) {
        for (int i = 0; i < this.clear.size(); ++i) {
            if (this.clear.get((int)i).X != x || this.clear.get((int)i).Y != y) continue;
            return true;
        }
        return false;
    }

    private void Command_Collapse() {
        int temp = 0;
        for (int y = 13; y >= 0; --y) {
            for (int x = 0; x < 6; ++x) {
                if (this.tc.gridI[x][y] == -1) continue;
                temp = 0;
                while (y + temp + 1 < 15 && this.tc.gridI[x][y + temp + 1] == -1) {
                    ++temp;
                }
                if (temp == 0) continue;
                this.tc.gridI[x][y + temp] = this.tc.gridI[x][y];
                this.tc.gridI[x][y] = -1;
            }
        }
        this.clear.clear();
        this.alpha = 255;
        this.Check_Field();
    }

    public void Command_Strafe(boolean totheleft) {
        int dir = 0;
        if (totheleft) {
            dir = -1;
            if (this.domino[0].X > 0 && this.domino[1].X > 0 && this.tc.gridI[this.domino[0].X + dir][this.domino[0].Y] == -1 && this.tc.gridI[this.domino[1].X + dir][this.domino[1].Y] == -1) {
                this.domino[0].X += dir;
                this.domino[1].X += dir;
            }
        } else {
            dir = 1;
            if (this.domino[0].X < 5 && this.domino[1].X < 5 && this.tc.gridI[this.domino[0].X + dir][this.domino[0].Y] == -1 && this.tc.gridI[this.domino[1].X + dir][this.domino[1].Y] == -1) {
                this.domino[0].X += dir;
                this.domino[1].X += dir;
            }
        }
    }

    public void Command_Turn(boolean totheleft) {
        int pos = 0;
        if (this.domino[0].Y > this.domino[1].Y) {
            pos = 1;
        }
        if (this.domino[0].X > this.domino[1].X) {
            pos = 2;
        }
        if (this.domino[0].Y < this.domino[1].Y) {
            pos = 3;
        }
        if (this.domino[0].X < this.domino[1].X) {
            pos = 4;
        }
        if (totheleft) {
            if (pos == 1 && this.domino[0].X - 1 >= 0 && this.tc.gridI[this.domino[0].X - 1][this.domino[0].Y] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X - 1, this.domino[0].Y);
            }
            if (pos == 2 && this.domino[0].Y + 1 <= 14 && this.tc.gridI[this.domino[0].X][this.domino[0].Y + 1] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X, this.domino[0].Y + 1);
            }
            if (pos == 3 && this.domino[0].X + 1 <= 5 && this.tc.gridI[this.domino[0].X + 1][this.domino[0].Y] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X + 1, this.domino[0].Y);
            }
            if (pos == 4 && this.domino[0].Y - 1 >= 0 && this.tc.gridI[this.domino[0].X][this.domino[0].Y - 1] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X, this.domino[0].Y - 1);
            }
        } else {
            if (pos == 1 && this.domino[0].X + 1 <= 5 && this.tc.gridI[this.domino[0].X + 1][this.domino[0].Y] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X + 1, this.domino[0].Y);
            }
            if (pos == 2 && this.domino[0].Y - 1 >= 0 && this.tc.gridI[this.domino[0].X][this.domino[0].Y - 1] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X, this.domino[0].Y - 1);
            }
            if (pos == 3 && this.domino[0].X - 1 >= 0 && this.tc.gridI[this.domino[0].X - 1][this.domino[0].Y] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X - 1, this.domino[0].Y);
            }
            if (pos == 4 && this.domino[0].Y + 1 <= 14 && this.tc.gridI[this.domino[0].X][this.domino[0].Y + 1] == -1) {
                this.domino[1] = new Vector2(this.domino[0].X, this.domino[0].Y + 1);
            }
        }
    }

    public void Command_Hold() {
        if (this.active_hold) {
            this.active_hold = false;
            if (this.container_hold[0] == -1) {
                this.container_hold[0] = this.container_current[0];
                this.container_hold[1] = this.container_current[1];
                this.container_current[0] = this.container_next[0];
                this.container_current[1] = this.container_next[1];
                this.container_next[0] = this.Domino_Roll();
                this.container_next[1] = this.Domino_Roll();
            } else {
                int[] temp = new int[]{this.container_hold[0], this.container_hold[1]};
                this.container_hold[0] = this.container_current[0];
                this.container_hold[1] = this.container_current[1];
                this.container_current[0] = temp[0];
                this.container_current[1] = temp[1];
            }
            this.Domino_Create();
        }
    }

    private int Domino_Roll() {
        return this.tc.rand.nextInt(7);
    }

    private void Domino_Create() {
        this.domino[0] = new Vector2(2, 1);
        this.domino[1] = new Vector2(2, 0);
    }

    public void Domino_Fall() {
        if (this.domino[0].Y < 14 && this.domino[1].Y < 14) {
            if (this.tc.gridI[this.domino[0].X][this.domino[0].Y + 1] == -1 && this.tc.gridI[this.domino[1].X][this.domino[1].Y + 1] == -1) {
                ++this.domino[0].Y;
                ++this.domino[1].Y;
            } else {
                this.Domino_Place();
            }
        } else {
            this.Domino_Place();
        }
    }

    private void Domino_Place() {
        this.active_hold = true;
        this.tc.gridI[this.domino[0].X][this.domino[0].Y] = this.container_current[0];
        this.tc.gridI[this.domino[1].X][this.domino[1].Y] = this.container_current[1];
        this.tc.scorePoint += 4;
        if (this.domino[1].Y == 0) {
            this.tc.turnstate = 4;
        }
        this.container_current[0] = this.container_next[0];
        this.container_current[1] = this.container_next[1];
        this.container_next[0] = this.Domino_Roll();
        this.container_next[1] = this.Domino_Roll();
        this.Domino_Create();
        this.Check_Field();
    }

    private void Check_Field() {
        int points = 0;
        int bonus = 0;
        this.clear_temp.clear();
        for (int y = 14; y >= 0; --y) {
            for (int x = 0; x < 6; ++x) {
                if (this.IsCleared(x, y)) continue;
                this.Pathfinder(x, y);
                if (this.clear_temp.size() >= 4) {
                    points += this.clear_temp.size() * 10;
                    ++bonus;
                    this.clear.addAll(this.clear_temp);
                }
                this.clear_temp.clear();
            }
        }
        if (points > 0) {
            this.alpha -= 5;
            this.tc.scorePoint += points * 2 * bonus * (this.tc.scoreLevel + 1);
            ++this.tc.scoreLives;
            if (this.tc.scoreLives > (1 + this.tc.scoreLevel) * 10) {
                ++this.tc.scoreLevel;
                this.time_break -= this.time_break / 10.0;
            }
        }
    }

    private void Pathfinder(int x, int y) {
        this.clear_temp.add(new Vector2(x, y));
        if (y - 1 >= 0 && this.tc.gridI[x][y] != -1 && this.tc.gridI[x][y] == this.tc.gridI[x][y - 1] && !this.IsClearedTemp(x, y - 1)) {
            this.Pathfinder(x, y - 1);
        }
        if (y + 1 <= 14 && this.tc.gridI[x][y] != -1 && this.tc.gridI[x][y] == this.tc.gridI[x][y + 1] && !this.IsClearedTemp(x, y + 1)) {
            this.Pathfinder(x, y + 1);
        }
        if (x - 1 >= 0 && this.tc.gridI[x][y] != -1 && this.tc.gridI[x][y] == this.tc.gridI[x - 1][y] && !this.IsClearedTemp(x - 1, y)) {
            this.Pathfinder(x - 1, y);
        }
        if (x + 1 <= 5 && this.tc.gridI[x][y] != -1 && this.tc.gridI[x][y] == this.tc.gridI[x + 1][y] && !this.IsClearedTemp(x + 1, y)) {
            this.Pathfinder(x + 1, y);
        }
    }

    private boolean IsClearedTemp(int x, int y) {
        for (int i = 0; i < this.clear_temp.size(); ++i) {
            if (this.clear_temp.get((int)i).X != x || this.clear_temp.get((int)i).Y != y) continue;
            return true;
        }
        return false;
    }
}

