/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.gui.minigames;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.gui.GuiCasino;
import mod.shared.util.Vector2;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class GuiMinesweeper
extends GuiCasino {
    List<Vector2> FieldList = new ArrayList<Vector2>();
    boolean[][] grid_flag = new boolean[30][14];
    int bombs;

    public GuiMinesweeper(InventoryPlayer playerInv, IInventory furnaceInv, int table) {
        super(playerInv, furnaceInv, table, CasinoKeeper.MODULE_MINESWEEPER);
        this.tc.gridI = new int[26][14];
        this.tc.gridB = new boolean[26][14];
    }

    @Override
    protected void mouseClicked2(double mouseX, double mouseY, int mouseButton) {
        if (this.tc.turnstate == 2 && mouseButton == 0) {
            for (int y = 0; y < 14; ++y) {
                for (int x = 0; x < 26; ++x) {
                    if (!this.mouseRect(-80 + 16 * x, 16 + 16 * y, 16, 16, mouseX, mouseY)) continue;
                    this.actionTouch(x + y * 26);
                }
            }
        }
        if (this.tc.turnstate == 3 && mouseButton == 0) {
            if (this.mouseRect(24, 204, 92, 26, mouseX, mouseY)) {
                this.actionTouch(-1);
            }
            if (this.mouseRect(140, 204, 92, 26, mouseX, mouseY)) {
                this.actionTouch(-2);
            }
        }
    }

    @Override
    protected void keyTyped2(int keyCode) {
    }

    @Override
    protected void drawGuiContainerForegroundLayer2(int mouseX, int mouseY) {
        if (this.table == 1) {
            this.field_146289_q.func_211126_b("POINTS", 25.0f, 25.0f, 0);
            this.field_146289_q.func_211126_b("POINTS", 24.0f, 24.0f, 0xFFFFFF);
            this.field_146289_q.func_211126_b("" + this.tc.scorePoint, 35.0f, 35.0f, 0);
            this.field_146289_q.func_211126_b("" + this.tc.scorePoint, 34.0f, 34.0f, 0xFFFFFF);
            this.field_146289_q.func_211126_b("BOMBS", 205.0f, 25.0f, 0);
            this.field_146289_q.func_211126_b("BOMBS", 205.0f, 24.0f, 0xFFFFFF);
            this.field_146289_q.func_211126_b("" + this.tc.scoreLevel * this.tc.difficulty, 215.0f, 35.0f, 0);
            this.field_146289_q.func_211126_b("" + this.tc.scoreLevel * this.tc.difficulty, 214.0f, 34.0f, 0xFFFFFF);
        } else {
            this.field_146289_q.func_211126_b("POINTS", -67.0f, 25.0f, 0);
            this.field_146289_q.func_211126_b("POINTS", -68.0f, 24.0f, 0xFFFFFF);
            this.field_146289_q.func_211126_b("" + this.tc.scorePoint, -57.0f, 35.0f, 0);
            this.field_146289_q.func_211126_b("" + this.tc.scorePoint, -58.0f, 34.0f, 0xFFFFFF);
            this.field_146289_q.func_211126_b("BOMBS", 297.0f, 25.0f, 0);
            this.field_146289_q.func_211126_b("BOMBS", 296.0f, 24.0f, 0xFFFFFF);
            this.field_146289_q.func_211126_b("" + this.tc.scoreLevel * this.tc.difficulty, 307.0f, 35.0f, 0);
            this.field_146289_q.func_211126_b("" + this.tc.scoreLevel * this.tc.difficulty, 306.0f, 34.0f, 0xFFFFFF);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer2(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_OCTAGAMES);
        for (int y = 0; y < 14; ++y) {
            for (int x = 0; x < 26; ++x) {
                int i = this.getValue(x + y * 26);
                if (this.getFlag(x + y * 26)) {
                    this.func_73729_b(this.field_147003_i - 96 + 16 + 16 * x, this.field_147009_r + 16 + 16 * y, 112, 216, 16, 16);
                    continue;
                }
                if (i == 9) {
                    this.func_73729_b(this.field_147003_i - 96 + 16 + 16 * x, this.field_147009_r + 16 + 16 * y, 192, 216, 16, 16);
                    continue;
                }
                if (i == 10) {
                    this.func_73729_b(this.field_147003_i - 96 + 16 + 16 * x, this.field_147009_r + 16 + 16 * y, 208, 216, 16, 16);
                    continue;
                }
                if (i <= 0) continue;
                GlStateManager.func_179131_c((float)(1.0f - (float)i / 10.0f), (float)1.0f, (float)1.0f, (float)0.5f);
                this.func_73729_b(this.field_147003_i - 96 + 16 + 16 * x, this.field_147009_r + 16 + 16 * y, 240, 64 + 16 * i, 16, 16);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (this.tc.turnstate == 3) {
            this.func_73729_b(this.field_147003_i + 24 + 7, this.field_147009_r + 204 + 2, 0, 0, 78, 22);
            this.func_73729_b(this.field_147003_i + 140 + 7, this.field_147009_r + 204 + 2, 78, 0, 78, 22);
        }
    }

    @Override
    public void start2() {
        this.bombs = 0;
        this.tc.selector = new Vector2(5, 5);
        this.FieldList.clear();
        this.tc.scoreLevel = 1;
        this.Create_Field();
    }

    public void Restart() {
        this.tc.turnstate = 2;
        this.FieldList.clear();
        ++this.tc.scoreLevel;
        this.Create_Field();
    }

    @Override
    public void actionTouch(int action) {
        if (action == -1) {
            this.Restart();
        } else if (action == -2) {
            this.tc.turnstate = 4;
        } else {
            this.tc.selector = new Vector2(action % 26, action / 26);
            this.Command_Grid_Enter();
        }
    }

    @Override
    public void update() {
    }

    @Override
    public int getValue(int index) {
        return this.tc.gridI[index % 26][index / 26];
    }

    @Override
    public boolean getFlag(int index) {
        return this.tc.gridB[index % 26][index / 26];
    }

    private void Create_Field() {
        int y;
        int x;
        for (int i = 0; i < 14; ++i) {
            for (int j = 0; j < 26; ++j) {
                this.tc.gridI[j][i] = 0;
                this.tc.gridB[j][i] = false;
                this.grid_flag[j][i] = false;
            }
        }
        this.bombs = this.tc.scoreLevel * this.tc.difficulty;
        int max = this.tc.difficulty == 2 ? 196 : 364;
        if (this.bombs > (max -= max / 4)) {
            this.bombs = max;
        }
        for (int i = 0; i < this.bombs; ++i) {
            int y2;
            x = this.tc.rand.nextInt(this.tc.difficulty == 2 ? 14 : 26) + (this.tc.difficulty == 2 ? 6 : 0);
            if (this.tc.gridI[x][y2 = this.tc.rand.nextInt(14)] != 9) {
                this.tc.gridI[x][y2] = 9;
                continue;
            }
            --i;
        }
        for (y = 0; y < 14; ++y) {
            for (x = this.tc.difficulty == 2 ? 6 : 0; x < (this.tc.difficulty == 2 ? 20 : 26); ++x) {
                this.tc.gridB[x][y] = true;
                if (this.tc.gridI[x][y] == 9) continue;
                int count = 0;
                if (x > 0 && y > 0 && this.tc.gridI[x - 1][y - 1] == 9) {
                    ++count;
                }
                if (y > 0 && this.tc.gridI[x][y - 1] == 9) {
                    ++count;
                }
                if (x < 25 && y > 0 && this.tc.gridI[x + 1][y - 1] == 9) {
                    ++count;
                }
                if (x < 25 && this.tc.gridI[x + 1][y] == 9) {
                    ++count;
                }
                if (x < 25 && y < 13 && this.tc.gridI[x + 1][y + 1] == 9) {
                    ++count;
                }
                if (y < 13 && this.tc.gridI[x][y + 1] == 9) {
                    ++count;
                }
                if (x > 0 && y < 13 && this.tc.gridI[x - 1][y + 1] == 9) {
                    ++count;
                }
                if (x <= 0 || this.tc.gridI[x - 1][y] == 9) {
                    // empty if block
                }
                this.tc.gridI[x][y] = ++count;
            }
        }
        if (this.tc.difficulty == 2) {
            for (y = 0; y < 6; ++y) {
                for (x = 0; x < 6; ++x) {
                }
            }
        }
    }

    private void Command_Grid_Enter() {
        if (this.tc.gridB[this.tc.selector.X][this.tc.selector.Y]) {
            this.tc.gridB[this.tc.selector.X][this.tc.selector.Y] = false;
            if (this.tc.gridI[this.tc.selector.X][this.tc.selector.Y] == 9) {
                this.tc.gridI[this.tc.selector.X][this.tc.selector.Y] = 10;
                this.Uncover_Bombs();
                this.tc.turnstate = 4;
                this.tc.scorePoint /= 2;
            } else {
                if (this.tc.gridI[this.tc.selector.X][this.tc.selector.Y] == 0) {
                    this.FieldList.add(this.tc.selector);
                    this.Uncover_Tiles();
                }
                boolean temp = false;
                for (int i = 0; i < 14; ++i) {
                    for (int j = 0; j < 26; ++j) {
                        if (this.tc.gridI[j][i] == 9 || !this.tc.gridB[j][i]) continue;
                        temp = true;
                    }
                }
                if (!temp) {
                    this.tc.turnstate = 3;
                    this.tc.scorePoint += this.bombs;
                }
            }
        }
    }

    private void Uncover_Tiles() {
        while (this.FieldList.size() > 0) {
            boolean temp0 = false;
            Iterator<Vector2> iterator = this.FieldList.iterator();
            if (iterator.hasNext()) {
                boolean temp;
                Vector2 v = iterator.next();
                if (v.X > 0 && v.Y > 0 && this.tc.gridB[v.X - 1][v.Y - 1] && !this.grid_flag[v.X - 1][v.Y - 1]) {
                    this.tc.gridB[v.X - 1][v.Y - 1] = false;
                    if (this.tc.gridI[v.X - 1][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.Y > 0 && this.tc.gridB[v.X][v.Y - 1] && !this.grid_flag[v.X][v.Y - 1]) {
                    this.tc.gridB[v.X][v.Y - 1] = false;
                    if (this.tc.gridI[v.X][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && v.Y > 0 && this.tc.gridB[v.X + 1][v.Y - 1] && !this.grid_flag[v.X + 1][v.Y - 1]) {
                    this.tc.gridB[v.X + 1][v.Y - 1] = false;
                    if (this.tc.gridI[v.X + 1][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && this.tc.gridB[v.X + 1][v.Y] && !this.grid_flag[v.X + 1][v.Y]) {
                    this.tc.gridB[v.X + 1][v.Y] = false;
                    if (this.tc.gridI[v.X + 1][v.Y] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && v.Y < 13 && this.tc.gridB[v.X + 1][v.Y + 1] && !this.grid_flag[v.X + 1][v.Y + 1]) {
                    this.tc.gridB[v.X + 1][v.Y + 1] = false;
                    if (this.tc.gridI[v.X + 1][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.Y < 13 && this.tc.gridB[v.X][v.Y + 1] && !this.grid_flag[v.X][v.Y + 1]) {
                    this.tc.gridB[v.X][v.Y + 1] = false;
                    if (this.tc.gridI[v.X][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X > 0 && v.Y < 13 && this.tc.gridB[v.X - 1][v.Y + 1] && !this.grid_flag[v.X - 1][v.Y + 1]) {
                    this.tc.gridB[v.X - 1][v.Y + 1] = false;
                    if (this.tc.gridI[v.X - 1][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X > 0 && this.tc.gridB[v.X - 1][v.Y] && !this.grid_flag[v.X - 1][v.Y]) {
                    this.tc.gridB[v.X - 1][v.Y] = false;
                    if (this.tc.gridI[v.X - 1][v.Y] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y));
                            temp0 = true;
                            break;
                        }
                    }
                }
            }
            if (temp0) continue;
            this.FieldList.remove(0);
        }
    }

    private void Uncover_Bombs() {
        for (int y = 0; y < 14; ++y) {
            for (int x = 0; x < 26; ++x) {
                if (this.tc.gridI[x][y] != 9) continue;
                this.tc.gridB[x][y] = false;
            }
        }
    }
}

