/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.gui.minigames;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.gui.GuiCasino;
import mod.casinocraft.util.Entity;
import mod.casinocraft.util.MapRoom;
import mod.shared.util.Vector2;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class GuiSokoban
extends GuiCasino {
    MapRoom MP = new MapRoom();
    Entity octanom;
    List<Entity> crate = new ArrayList<Entity>();
    List<Entity> cross = new ArrayList<Entity>();
    boolean moving;

    public GuiSokoban(InventoryPlayer playerInv, IInventory furnaceInv, int table) {
        super(playerInv, furnaceInv, table, CasinoKeeper.MODULE_SOKOBAN);
        this.tc.gridI = new int[16][12];
        this.tc.gridB = new boolean[16][12];
    }

    @Override
    protected void mouseClicked2(double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    protected void keyTyped2(int keyCode) {
        if (keyCode == 265) {
            this.actionTouch(0);
        }
        if (keyCode == 264) {
            this.actionTouch(1);
        }
        if (keyCode == 263) {
            this.actionTouch(2);
        }
        if (keyCode == 262) {
            this.actionTouch(3);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer2(int mouseX, int mouseY) {
    }

    @Override
    protected void drawGuiContainerBackgroundLayer2(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_ARCADEDUMMY);
        this.func_73729_b(this.field_147003_i, this.field_147009_r + this.intro, 0, 0, this.field_146999_f, this.field_147000_g - this.intro);
        if (this.tc.turnstate == 1 && this.intro < 176) {
            this.intro = 0;
            this.tc.turnstate = 2;
        }
        if (this.tc.turnstate >= 2) {
            if (this.tc.turnstate == 5) {
                GlStateManager.func_179131_c((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            }
            this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_OCTAGAMES);
            for (int x = 1; x < 15; ++x) {
                for (int y = 0; y < 12; ++y) {
                    if (!this.getFlag(x + y * 16)) continue;
                    this.func_73729_b(this.field_147003_i + x * 16, this.field_147009_r + y * 16, 112, 216, 16, 16);
                }
            }
            for (Entity e : this.getEntityList(0)) {
                this.func_73729_b(this.field_147003_i + e.Get_Pos().X, this.field_147009_r + e.Get_Pos().Y, 224, 216, 16, 16);
            }
            this.func_73729_b(this.field_147003_i + this.getEntity((int)0).Get_Pos().X, this.field_147009_r + this.getEntity((int)0).Get_Pos().Y, 0, this.getEntity(0).Get_LookDirection() * 16 + 66, 16, 16);
            for (Entity e : this.getEntityList(1)) {
                this.func_73729_b(this.field_147003_i + e.Get_Pos().X, this.field_147009_r + e.Get_Pos().Y, 160, 216, 16, 16);
            }
            if (this.tc.turnstate == 5) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @Override
    public void start2() {
        this.tc.gridB = new boolean[16][12];
        this.tc.gridI = new int[16][12];
        this.octanom = new Entity(1, new Vector2(240, 240), new Vector2(240, 240));
        this.crate.clear();
        this.cross.clear();
        this.Load_Map();
    }

    @Override
    public void actionTouch(int action) {
        this.Command_Move(action);
    }

    @Override
    public void update() {
        if (this.moving) {
            boolean swittch = true;
            for (Entity c : this.crate) {
                if (c.Get_Pos().X == c.Get_Next().X * 16 && c.Get_Pos().Y == c.Get_Next().Y * 16) {
                    c.Set_InMotion(0, 0);
                    continue;
                }
                swittch = false;
            }
            if (swittch) {
                this.moving = false;
            }
        }
        if (this.tc.turnstate >= 2 && this.tc.turnstate < 4) {
            this.octanom.Update();
            boolean win = true;
            for (Entity e : this.crate) {
                e.Update();
                boolean hp1 = true;
                for (Entity c : this.cross) {
                    if (!c.Get_Pos().matches(e.Get_Pos())) continue;
                    hp1 = false;
                }
                if (hp1) {
                    e.Set_HP(1);
                    win = false;
                    continue;
                }
                e.Set_HP(2);
            }
            for (Entity e : this.cross) {
                e.Update();
            }
            if (win && this.tc.turnstate < 4) {
                this.tc.scorePoint = this.crate.size() * 500;
                this.tc.turnstate = 4;
            }
        }
    }

    @Override
    public Entity getEntity(int index) {
        return this.octanom;
    }

    @Override
    public List<Entity> getEntityList(int index) {
        if (index == 0) {
            return this.crate;
        }
        return this.cross;
    }

    @Override
    public int getValue(int index) {
        return this.tc.gridI[index % 16][index / 16];
    }

    @Override
    public boolean getFlag(int index) {
        return this.tc.gridB[index % 16][index / 16];
    }

    @Override
    public String getString(int index) {
        return "";
    }

    private void Load_Map() {
        List<String> list = this.MP.LoadSokoban(this.tc.rand);
        int y = 0;
        for (String s : list) {
            block8: for (int x = 0; x < 16; ++x) {
                char c = s.charAt(x);
                if (c != ' ') {
                    this.tc.gridI[x][y] = this.ConvertGrid(x, y);
                }
                switch (c) {
                    case ' ': {
                        continue block8;
                    }
                    case 'X': {
                        this.tc.gridB[x][y] = true;
                        continue block8;
                    }
                    case 'O': {
                        this.octanom = new Entity(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y));
                        continue block8;
                    }
                    case 'M': {
                        this.cross.add(new Entity(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y)));
                        continue block8;
                    }
                    case 'C': {
                        this.crate.add(new Entity(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y)));
                    }
                }
            }
            ++y;
        }
    }

    private int ConvertGrid(int x, int y) {
        if (y % 2 == 0 && x % 2 == 0) {
            return 1;
        }
        if (y % 2 == 0 && x % 2 != 0) {
            return 2;
        }
        if (y % 2 != 0 && x % 2 == 0) {
            return 2;
        }
        if (y % 2 != 0 && x % 2 != 0) {
            return 1;
        }
        return 0;
    }

    private void Command_Move(int direction) {
        if (!this.octanom.isMoving()) {
            int x = 0;
            int y = 0;
            if (direction == 0) {
                x = 0;
                y = -1;
            }
            if (direction == 1) {
                x = 0;
                y = 1;
            }
            if (direction == 2) {
                x = -1;
                y = 0;
            }
            if (direction == 3) {
                x = 1;
                y = 0;
            }
            if (!this.tc.gridB[this.octanom.Get_Grid().X + x][this.octanom.Get_Grid().Y + y]) {
                boolean blockedO = false;
                for (Entity c : this.crate) {
                    if (c.Get_Grid().X != this.octanom.Get_Grid().X + x || c.Get_Grid().Y != this.octanom.Get_Grid().Y + y) continue;
                    blockedO = true;
                    if (this.tc.gridB[this.octanom.Get_Grid().X + x * 2][this.octanom.Get_Grid().Y + y * 2]) continue;
                    boolean blockedC = false;
                    for (Entity c2 : this.crate) {
                        if (c.Get_Grid().X != this.octanom.Get_Grid().X + x * 2 || c.Get_Grid().Y != this.octanom.Get_Grid().Y + y * 2) continue;
                        blockedC = true;
                    }
                    if (blockedC) continue;
                    this.moving = true;
                    c.Set_InMotion(x * 2, y * 2);
                }
                if (!blockedO) {
                    this.octanom.Set_InMotion(x * 2, y * 2);
                }
            }
        }
    }
}

