/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.gui.minigames;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.gui.GuiCasino;
import mod.casinocraft.util.Card;
import mod.shared.util.Vector2;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class GuiSpider
extends GuiCasino {
    List<Card>[] cards_field = new ArrayList[10];
    List<Card>[] cards_reserve = new ArrayList[5];
    List<Card> cards_finish = new ArrayList<Card>();
    float compress;
    float compressDisplay;

    public GuiSpider(InventoryPlayer playerInv, IInventory furnaceInv, int table) {
        super(playerInv, furnaceInv, table, CasinoKeeper.MODULE_SPIDER);
    }

    @Override
    protected void mouseClicked2(double mouseX, double mouseY, int mouseButton) {
        if (this.tc.turnstate == 2 && mouseButton == 0) {
            for (int y = 1; y < 20; ++y) {
                for (int x = 0; x < 10; ++x) {
                    if (!this.mouseRect(-32 + 32 * x, 16 + (24 - this.getValue(0)) * y, 32, 24, mouseX, mouseY)) continue;
                    this.actionTouch(x + y * 10);
                }
            }
            if (this.mouseRect(296, 24, 32, 196, mouseX, mouseY)) {
                this.actionTouch(-1);
            }
        }
    }

    protected void keyTyped2(char typedChar, int keyCode) {
    }

    @Override
    protected void drawGuiContainerForegroundLayer2(int mouseX, int mouseY) {
    }

    @Override
    protected void drawGuiContainerBackgroundLayer2(float partialTicks, int mouseX, int mouseY) {
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < this.getCardStack(x).size(); ++y) {
                this.drawCard(-32 + x * 32, 16 + y * (24 - this.getValue(0)), this.getCardStack(x).get(y));
            }
        }
        if (this.tc.selector.Y != -1) {
            this.drawCardBack(this.tc.selector.X * 32 - 32, 16 + this.tc.selector.Y * (24 - this.getValue(0)), 9);
        }
        this.drawCardBack(296, 24, 7);
        if (this.getCardStack(14).size() > 0) {
            this.drawCardBack(296, 24, 0);
        }
        if (this.getCardStack(13).size() > 0) {
            this.drawCardBack(296, 48, 0);
        }
        if (this.getCardStack(12).size() > 0) {
            this.drawCardBack(296, 72, 0);
        }
        if (this.getCardStack(11).size() > 0) {
            this.drawCardBack(296, 96, 0);
        }
        if (this.getCardStack(10).size() > 0) {
            this.drawCardBack(296, 120, 0);
        }
        this.drawCardBack(-72, 24, 7);
        int i = 0;
        for (Card c : this.getCardStack(15)) {
            this.drawCard(-72, 24 + i * 24, this.getCard(i));
        }
    }

    @Override
    public void start2() {
        List<Card> deck = this.ShuffleDeck();
        this.cards_field[0] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[0], deck, 0, 6);
        this.cards_field[1] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[1], deck, 0, 6);
        this.cards_field[2] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[2], deck, 0, 6);
        this.cards_field[3] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[3], deck, 0, 6);
        this.cards_field[4] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[4], deck, 0, 5);
        this.cards_field[5] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[5], deck, 0, 5);
        this.cards_field[6] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[6], deck, 0, 5);
        this.cards_field[7] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[7], deck, 0, 5);
        this.cards_field[8] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[8], deck, 0, 5);
        this.cards_field[9] = new ArrayList<Card>();
        this.TransferCards(this.cards_field[9], deck, 0, 5);
        this.cards_reserve[0] = new ArrayList<Card>();
        this.TransferCards(this.cards_reserve[0], deck, 0, 10);
        this.cards_reserve[1] = new ArrayList<Card>();
        this.TransferCards(this.cards_reserve[1], deck, 0, 10);
        this.cards_reserve[2] = new ArrayList<Card>();
        this.TransferCards(this.cards_reserve[2], deck, 0, 10);
        this.cards_reserve[3] = new ArrayList<Card>();
        this.TransferCards(this.cards_reserve[3], deck, 0, 10);
        this.cards_reserve[4] = new ArrayList<Card>();
        this.TransferCards(this.cards_reserve[4], deck, 0, 10);
        this.tc.selector = new Vector2(-1, -1);
        this.compress = 2.0f;
        this.compressDisplay = 2.0f;
        for (int x = 0; x < 10; ++x) {
            int y = 0;
            for (Card c : this.cards_field[x]) {
                c.setShift(0, -24 * y, 70 - 10 * y + x * 3);
                ++y;
            }
        }
    }

    @Override
    public void actionTouch(int action) {
        if (action == -1) {
            this.DrawReserve();
        }
        if (action >= 0) {
            this.TouchField(action % 10, action / 10);
        }
    }

    @Override
    public void update() {
        for (int x = 0; x < 10; ++x) {
            if (this.cards_field[x].size() <= 0) continue;
            for (Card c : this.cards_field[x]) {
                c.update();
            }
        }
        if (this.cards_finish.size() == 8 && this.tc.turnstate < 4) {
            this.tc.scorePoint = 100;
            this.tc.turnstate = 4;
        }
        if (this.compressDisplay > this.compress) {
            this.compressDisplay -= 0.25f;
            if (this.compressDisplay < this.compress) {
                this.compressDisplay = this.compress;
            }
        }
        if (this.compressDisplay < this.compress) {
            this.compressDisplay += 0.25f;
            if (this.compressDisplay > this.compress) {
                this.compressDisplay = this.compress;
            }
        }
    }

    @Override
    public int getValue(int index) {
        return (int)this.compressDisplay;
    }

    @Override
    public List<Card> getCardStack(int index) {
        if (index == 15) {
            return this.cards_finish;
        }
        if (index >= 10) {
            return this.cards_reserve[index - 10];
        }
        return this.cards_field[index];
    }

    private void TransferCards(List<Card> cards_field2, List<Card> deck, int position, int count) {
        for (int i = position; i < position + count; ++i) {
            cards_field2.add(deck.get(position));
            deck.remove(position);
        }
    }

    private void TransferCards(List<Card> cards_field2, List<Card> deck, int position, int count, int shiftX, int shiftY) {
        for (int i = position; i < position + count; ++i) {
            deck.get(position).setShift(shiftX, shiftY, 0);
            cards_field2.add(deck.get(position));
            deck.remove(position);
        }
    }

    private List<Card> ShuffleDeck() {
        ArrayList<Card> stack = new ArrayList<Card>();
        ArrayList<Card> deck = new ArrayList<Card>();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 13; ++x) {
                stack.add(new Card(x, this.tc.difficulty == 1 ? 0 : (this.tc.difficulty == 2 ? y / 2 : y)));
                stack.add(new Card(x, this.tc.difficulty == 1 ? 0 : (this.tc.difficulty == 2 ? y / 2 : y)));
            }
        }
        while (stack.size() > 1) {
            int r = this.tc.rand.nextInt(stack.size() - 1);
            deck.add((Card)stack.get(r));
            stack.remove(r);
        }
        deck.add((Card)stack.get(0));
        return deck;
    }

    private void DrawReserve() {
        if (this.cards_reserve[0].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[0].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[0].get(x));
            }
            this.cards_reserve[0].clear();
        } else if (this.cards_reserve[1].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[1].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[1].get(x));
            }
            this.cards_reserve[1].clear();
        } else if (this.cards_reserve[2].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[2].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[2].get(x));
            }
            this.cards_reserve[2].clear();
        } else if (this.cards_reserve[3].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[3].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[3].get(x));
            }
            this.cards_reserve[3].clear();
        } else if (this.cards_reserve[4].size() > 0) {
            for (int x = 0; x < 10; ++x) {
                this.cards_reserve[4].get(x).setShift(0, 24, 0);
                this.cards_field[x].add(this.cards_reserve[4].get(x));
            }
            this.cards_reserve[4].clear();
        }
    }

    private void TouchField(int x, int y) {
        if (this.cards_field[x].size() >= y - 1) {
            if (this.tc.selector.matches(-1, -1)) {
                int x2 = x;
                int y2 = this.cards_field[x].size() < y ? this.cards_field[x].size() - 1 : y - 1;
                float tempCard = this.cards_field[x2].get((int)y2).number;
                for (int i = y2; i < this.cards_field[x2].size(); ++i) {
                    if (i == this.cards_field[x2].size() - 1 || this.cards_field[x2].get((int)i).number - 1 == this.cards_field[x2].get((int)(i + 1)).number || this.cards_field[x2].get((int)i).number == 1 && this.cards_field[x2].get((int)(i + 1)).number == 13) continue;
                    return;
                }
                this.tc.selector.set(x2, y2);
            } else if (!this.MoveStack(x, y)) {
                this.tc.selector.set(-1, -1);
            }
        }
        this.Compress();
    }

    private boolean MoveStack(int x, int y) {
        int x2 = x;
        int y2 = this.cards_field[x2].size() - 1;
        if (this.cards_field[x2].size() == 0) {
            this.TransferCards(this.cards_field[x2], this.cards_field[this.tc.selector.X], this.tc.selector.Y, this.cards_field[this.tc.selector.X].size() - this.tc.selector.Y, 0, 16);
            this.tc.selector.set(-1, -1);
            this.ClearRow(x2);
            return true;
        }
        if (this.cards_field[this.tc.selector.X].get((int)this.tc.selector.Y).number + 1 == this.cards_field[x2].get((int)y2).number) {
            this.TransferCards(this.cards_field[x2], this.cards_field[this.tc.selector.X], this.tc.selector.Y, this.cards_field[this.tc.selector.X].size() - this.tc.selector.Y, 0, 16);
            this.tc.selector.set(-1, -1);
            this.ClearRow(x2);
            return true;
        }
        return false;
    }

    private void ClearRow(int row) {
        if (this.cards_field[row].size() >= 13) {
            block0: for (int i = 0; i < this.cards_field[row].size(); ++i) {
                if (this.cards_field[row].get((int)i).number != 12) continue;
                for (int j = 0; j < this.cards_field[row].size() - 1; ++j) {
                    if (12 - j == 0 && this.cards_field[row].get((int)(i + j)).number == 13 && this.cards_field[row].get((int)i).suit == this.cards_field[row].get((int)(i + j)).suit) {
                        this.cards_finish.add(this.cards_field[row].get(this.cards_field[row].size() - 1));
                        for (int z = this.cards_field[row].size() - 13; z < this.cards_field[row].size() - 13; ++z) {
                            this.cards_field[row].remove(z);
                        }
                        return;
                    }
                    if (12 - j != this.cards_field[row].get((int)(i + j)).number || this.cards_field[row].get((int)i).suit != this.cards_field[row].get((int)(i + j)).suit) continue block0;
                }
            }
        }
    }

    private void Compress() {
        int i = 0;
        for (int x = 0; x < 8; ++x) {
            if (this.cards_field[x].size() <= i) continue;
            i = this.cards_field[x].size();
        }
        this.compress = i > 8 ? (float)(i - 5) : 0.0f;
    }
}

