/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.gui.minigames;

import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.gui.GuiCasino;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;

public class GuiSudoku
extends GuiCasino {
    int[][] grid_mirror = new int[9][9];
    boolean match;

    public GuiSudoku(InventoryPlayer playerInv, IInventory furnaceInv, int table) {
        super(playerInv, furnaceInv, table, CasinoKeeper.MODULE_SUDOKU);
        this.tc.gridI = new int[9][9];
    }

    @Override
    protected void mouseClicked2(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (int y = 0; y < 9; ++y) {
                for (int x = 0; x < 9; ++x) {
                    if (!this.mouseRect(20 + 24 * x, 20 + 24 * y, 24, 24, mouseX, mouseY)) continue;
                    this.actionTouch(100 + y * 9 + x);
                }
            }
        }
    }

    @Override
    protected void keyTyped2(int keyCode) {
        if (keyCode == 49) {
            this.actionTouch(1);
        }
        if (keyCode == 50) {
            this.actionTouch(2);
        }
        if (keyCode == 51) {
            this.actionTouch(3);
        }
        if (keyCode == 52) {
            this.actionTouch(4);
        }
        if (keyCode == 53) {
            this.actionTouch(5);
        }
        if (keyCode == 54) {
            this.actionTouch(6);
        }
        if (keyCode == 55) {
            this.actionTouch(7);
        }
        if (keyCode == 56) {
            this.actionTouch(8);
        }
        if (keyCode == 57) {
            this.actionTouch(9);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer2(int mouseX, int mouseY) {
    }

    @Override
    protected void drawGuiContainerBackgroundLayer2(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_SUDOKU);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_OCTAGAMES);
        this.func_73729_b(this.field_147003_i + 20 + 24 * this.getValue(-1), this.field_147009_r + 20 + 24 * this.getValue(-2), 0, 232, 24, 24);
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (this.getValue(y * 9 + x + 100) != 0) {
                    if (this.getValue(y * 9 + x) <= 0) continue;
                    GlStateManager.func_179131_c((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
                    this.func_73729_b(this.field_147003_i + 20 + 4 + 24 * x, this.field_147009_r + 20 + 4 + 24 * y, 240, 64 + 16 * this.getValue(y * 9 + x), 16, 16);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    continue;
                }
                if (this.getValue(y * 9 + x) <= 0) continue;
                this.func_73729_b(this.field_147003_i + 20 + 4 + 24 * x, this.field_147009_r + 20 + 4 + 24 * y, 240, 64 + 16 * this.getValue(y * 9 + x), 16, 16);
            }
        }
    }

    @Override
    public void start2() {
        int r;
        this.match = false;
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.tc.gridI[x][y] = 0;
            }
        }
        this.tc.gridI[4][4] = r = this.tc.rand.nextInt(9) + 1;
        this.grid_mirror[4][4] = r;
        this.Generate_Square(5 - this.tc.difficulty, 3, 0);
        this.Generate_Square(5 - this.tc.difficulty, 0, 3);
        this.Generate_Square(5 - this.tc.difficulty, 6, 3);
        this.Generate_Square(5 - this.tc.difficulty, 3, 6);
        this.Generate_Square(5 - this.tc.difficulty, 0, 0);
        this.Generate_Square(5 - this.tc.difficulty, 6, 0);
        this.Generate_Square(5 - this.tc.difficulty, 0, 6);
        this.Generate_Square(5 - this.tc.difficulty, 6, 6);
    }

    @Override
    public void actionTouch(int action) {
        if (action >= 100) {
            int i = action - 100;
            this.tc.selector.set(i % 9, i / 9);
        } else {
            this.tc.gridI[this.tc.selector.X][this.tc.selector.Y] = action;
            this.Check();
        }
    }

    @Override
    public void update() {
        if (this.match && this.tc.turnstate < 4) {
            this.tc.turnstate = 4;
        }
    }

    @Override
    public int getValue(int index) {
        if (index == -1) {
            return this.tc.selector.X;
        }
        if (index == -2) {
            return this.tc.selector.Y;
        }
        if (index >= 100) {
            int i = index - 100;
            return this.grid_mirror[i % 9][i / 9];
        }
        return this.tc.gridI[index % 9][index / 9];
    }

    private void Generate_Square(int count, int xi, int yi) {
        int index = 0;
        while (index < count) {
            int i;
            int x = this.tc.rand.nextInt(3);
            int y = this.tc.rand.nextInt(3);
            if (this.tc.gridI[0][yi + y] == (i = this.tc.rand.nextInt(9) + 1) || this.tc.gridI[1][yi + y] == i || this.tc.gridI[2][yi + y] == i || this.tc.gridI[3][yi + y] == i || this.tc.gridI[4][yi + y] == i || this.tc.gridI[5][yi + y] == i || this.tc.gridI[6][yi + y] == i || this.tc.gridI[7][yi + y] == i || this.tc.gridI[8][yi + y] == i || this.tc.gridI[xi + x][0] == i || this.tc.gridI[xi + x][1] == i || this.tc.gridI[xi + x][2] == i || this.tc.gridI[xi + x][3] == i || this.tc.gridI[xi + x][4] == i || this.tc.gridI[xi + x][5] == i || this.tc.gridI[xi + x][6] == i || this.tc.gridI[xi + x][7] == i || this.tc.gridI[xi + x][8] == i || this.tc.gridI[xi + 0][yi + 0] == i || this.tc.gridI[xi + 1][yi + 0] == i || this.tc.gridI[xi + 2][yi + 0] == i || this.tc.gridI[xi + 0][yi + 1] == i || this.tc.gridI[xi + 1][yi + 1] == i || this.tc.gridI[xi + 2][yi + 1] == i || this.tc.gridI[xi + 0][yi + 2] == i || this.tc.gridI[xi + 1][yi + 2] == i || this.tc.gridI[xi + 2][yi + 2] == i) continue;
            this.tc.gridI[xi + x][yi + y] = i;
            this.grid_mirror[xi + x][yi + y] = i;
            ++index;
        }
    }

    private void Check() {
        int x;
        int i;
        int y;
        int i2;
        boolean[] match_vert = new boolean[9];
        boolean[] match_hori = new boolean[9];
        boolean[] match_cube = new boolean[9];
        int[] n = new int[10];
        for (i2 = 0; i2 < 9; ++i2) {
            n[i2] = 0;
        }
        for (y = 0; y < 9; ++y) {
            for (i = 0; i < 9; ++i) {
                n[i] = 0;
            }
            for (x = 0; x < 9; ++x) {
                int n2 = this.tc.gridI[x][y];
                n[n2] = n[n2] + 1;
            }
            match_vert[y] = n[1] == 1 && n[2] == 1 && n[3] == 1 && n[4] == 1 && n[5] == 1 && n[6] == 1 && n[7] == 1 && n[8] == 1 && n[9] == 1;
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            for (i = 0; i < 9; ++i) {
                n[i] = 0;
            }
            for (int y2 = 0; y2 < 9; ++y2) {
                int n3 = this.tc.gridI[x2][y2];
                n[n3] = n[n3] + 1;
            }
            match_hori[x2] = n[1] == 1 && n[2] == 1 && n[3] == 1 && n[4] == 1 && n[5] == 1 && n[6] == 1 && n[7] == 1 && n[8] == 1 && n[9] == 1;
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                for (int i3 = 0; i3 < 9; ++i3) {
                    n[i3] = 0;
                }
                for (int yi = y * 3; yi < y * 3 + 3; ++yi) {
                    for (int xi = x * 3; xi < x * 3 + 3; ++xi) {
                        int n4 = this.tc.gridI[xi][yi];
                        n[n4] = n[n4] + 1;
                    }
                }
                match_cube[y * 3 + x] = false;
                if (n[1] != 1 || n[2] != 1 || n[3] != 1 || n[4] != 1 || n[5] != 1 || n[6] != 1 || n[7] != 1 || n[8] != 1 || n[9] != 1) continue;
                match_hori[y * 3 + x] = true;
            }
        }
        this.match = true;
        for (i2 = 0; i2 < 9; ++i2) {
            if (!match_vert[i2]) {
                this.match = false;
            }
            if (!match_hori[i2]) {
                this.match = false;
            }
            if (match_cube[i2]) continue;
            this.match = false;
        }
    }
}

