/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import java.nio.charset.Charset;
import java.util.function.Supplier;
import mod.casinocraft.network.PacketClientScoreMessage;
import mod.casinocraft.system.CasinoPacketHandler;
import mod.casinocraft.tileentities.TileEntityBoard;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerScoreMessage {
    static ItemStack stack;
    static int[] points;
    static int[] length;
    static String[] names;
    static int x;
    static int y;
    static int z;

    public ServerScoreMessage(Item item, String[] scoreName, int[] scorePoints, BlockPos pos) {
        stack = new ItemStack((IItemProvider)item);
        for (int i = 0; i < 18; ++i) {
            ServerScoreMessage.points[i] = scorePoints[i];
            ServerScoreMessage.length[i] = scoreName[i].length();
            ServerScoreMessage.names[i] = scoreName[i];
        }
        x = pos.func_177958_n();
        y = pos.func_177956_o();
        z = pos.func_177952_p();
    }

    public static void encode(ServerScoreMessage msg, PacketBuffer buf) {
        buf.func_150788_a(stack);
        for (int i = 0; i < 18; ++i) {
            buf.writeInt(points[i]);
            buf.writeInt(length[i]);
            buf.writeCharSequence((CharSequence)names[i], Charset.defaultCharset());
        }
        buf.writeInt(x);
        buf.writeInt(y);
        buf.writeInt(z);
    }

    public static ServerScoreMessage decode(PacketBuffer buf) {
        int[] _points = new int[18];
        int[] _length = new int[18];
        String[] _names = new String[18];
        ItemStack _stack = buf.func_150791_c();
        for (int i = 0; i < 18; ++i) {
            _points[i] = buf.readInt();
            _length[i] = buf.readInt();
            _names[i] = (String)buf.readCharSequence(_length[i], Charset.defaultCharset());
        }
        int _x = buf.readInt();
        int _y = buf.readInt();
        int _z = buf.readInt();
        return new ServerScoreMessage(_stack.func_77973_b(), _names, _points, new BlockPos(_x, _y, _z));
    }

    static {
        points = new int[18];
        length = new int[18];
        names = new String[18];
    }

    public static class Handler {
        private boolean isEmpty(ItemStack stack) {
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150350_a)) {
                return true;
            }
            return stack.func_77973_b() == null;
        }

        public static void handle(ServerScoreMessage message, Supplier<NetworkEvent.Context> context) {
            EntityPlayerMP serverPlayer = context.get().getSender();
            Item item = stack.func_77973_b();
            BlockPos pos = new BlockPos(x, y, z);
            TileEntityBoard te = (TileEntityBoard)context.get().getSender().field_70170_p.func_175625_s(pos);
            context.get().getSender().func_71121_q().func_152344_a(() -> {
                te.setScoreToken(item);
                for (int i = 0; i < 18; ++i) {
                    te.scorePoints[i] = points[i];
                    te.scoreName[i] = names[i];
                }
            });
            CasinoPacketHandler.sendToAll(new PacketClientScoreMessage(item, names, points, te.func_174877_v()));
            context.get().setPacketHandled(true);
        }
    }
}

