/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities;

import java.util.Random;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.tileentities.TileEntityCasino;
import mod.shared.util.Vector2;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;

public abstract class TileEntityBoard
extends TileEntity
implements IInventory,
ITickable,
IInteractionObject {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    public EnumDyeColor color = EnumDyeColor.BLACK;
    public int bet_storage = 0;
    public int bet_low = 0;
    public int bet_high = 0;
    public boolean transfer_in = false;
    public boolean transfer_out = false;
    public boolean isCreative = false;
    public int[] scorePoints = new int[18];
    public String[] scoreName = new String[18];
    public boolean hasHighscore = false;
    public int scoreLast = 18;
    public static TileEntityType<TileEntityCasino> TILETYPE;
    public Random rand = new Random();
    public int difficulty = 2;
    public int scorePoint = -1;
    public int scoreLevel = -1;
    public int scoreLives = -1;
    public int[][] gridI = new int[4][4];
    public boolean[][] gridB = new boolean[4][4];
    public String hand = "NULL";
    public int reward = -1;
    public Vector2 selector = new Vector2(0, 0);
    public int turnstate;

    public TileEntityBoard(boolean isArcade) {
        super(isArcade ? CasinoKeeper.TILETYPE_ARCADE : CasinoKeeper.TILETYPE_CARDTABLE);
        for (int i = 0; i < 18; ++i) {
            this.scorePoints[i] = 0;
            this.scoreName[i] = "empty";
        }
    }

    public Item getModule() {
        return ((ItemStack)this.inventory.get(1)).func_77973_b();
    }

    public Item getToken() {
        return ((ItemStack)this.inventory.get(4)).func_77973_b();
    }

    public boolean isToken(ItemStack itemstack) {
        return itemstack.func_77973_b() == ((ItemStack)this.inventory.get(4)).func_77973_b();
    }

    public ItemStack getTokenStack() {
        return (ItemStack)this.inventory.get(4);
    }

    public void setToken(ItemStack itemstack) {
        this.inventory.set(4, (Object)new ItemStack((IItemProvider)itemstack.func_77973_b(), 1));
    }

    public Item getScoreToken() {
        return ((ItemStack)this.inventory.get(5)).func_77973_b();
    }

    public void setScoreToken(Item item) {
        this.inventory.set(5, (Object)new ItemStack((IItemProvider)item));
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("casinoboard", new Object[0]);
    }

    public ITextComponent func_200201_e() {
        return new TextComponentTranslation("casinoboard", new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.bet_storage = compound.func_74762_e("storage");
        this.bet_low = compound.func_74762_e("low");
        this.bet_high = compound.func_74762_e("high");
        this.isCreative = compound.func_74767_n("iscreative");
        this.inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        for (int i = 0; i < 18; ++i) {
            this.scorePoints[i] = compound.func_74762_e("points" + i);
            this.scoreName[i] = compound.func_74779_i("name" + i);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("storage", this.bet_storage);
        compound.func_74768_a("low", this.bet_low);
        compound.func_74768_a("high", this.bet_high);
        compound.func_74757_a("iscreative", this.isCreative);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        for (int i = 0; i < 18; ++i) {
            compound.func_74768_a("points" + i, this.scorePoints[i]);
            compound.func_74778_a("name" + i, this.scoreName[i]);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.inventory.get(0);
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, null);
        }
    }

    public void func_73660_a() {
        int count;
        boolean isDirty = false;
        if (this.transfer_in && ((ItemStack)this.inventory.get(2)).func_190916_E() > 0 && (this.bet_storage == 0 || this.isToken((ItemStack)this.inventory.get(2)))) {
            if (this.getToken() == Item.func_150898_a((Block)Blocks.field_150350_a)) {
                this.setToken((ItemStack)this.inventory.get(2));
            }
            count = (Boolean)CasinoKeeper.config_fastload.get() != false ? ((ItemStack)this.inventory.get(2)).func_190916_E() : 1;
            ((ItemStack)this.inventory.get(2)).func_190918_g(count);
            this.bet_storage += count;
            isDirty = true;
        }
        if (this.transfer_out && this.bet_storage > 0 && (this.isToken((ItemStack)this.inventory.get(3)) || ((ItemStack)this.inventory.get(3)).func_190926_b())) {
            if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                count = ((Boolean)CasinoKeeper.config_fastload.get()).booleanValue() ? (this.bet_storage >= 64 ? 64 : this.bet_storage) : 1;
                this.inventory.set(3, (Object)new ItemStack((IItemProvider)this.getTokenStack().func_77973_b(), count));
                this.bet_storage -= count;
                isDirty = true;
            } else if (((ItemStack)this.inventory.get(3)).func_190916_E() < 64) {
                count = ((Boolean)CasinoKeeper.config_fastload.get()).booleanValue() ? (this.bet_storage >= 64 - ((ItemStack)this.inventory.get(3)).func_190916_E() ? 64 - ((ItemStack)this.inventory.get(3)).func_190916_E() : this.bet_storage) : 1;
                ((ItemStack)this.inventory.get(3)).func_190917_f(count);
                this.bet_storage -= count;
                isDirty = true;
            }
            if (this.bet_storage == 0) {
                this.setToken(new ItemStack((IItemProvider)Blocks.field_150350_a));
                isDirty = true;
            }
        }
        if (isDirty) {
            this.func_70296_d();
        }
        if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_WHITE) {
            this.color = EnumDyeColor.WHITE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_ORANGE) {
            this.color = EnumDyeColor.ORANGE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_MAGENTA) {
            this.color = EnumDyeColor.MAGENTA;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_LIGHTBLUE) {
            this.color = EnumDyeColor.LIGHT_BLUE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_YELLOW) {
            this.color = EnumDyeColor.YELLOW;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_LIME) {
            this.color = EnumDyeColor.LIME;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_PINK) {
            this.color = EnumDyeColor.PINK;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_GRAY) {
            this.color = EnumDyeColor.GRAY;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_SILVER) {
            this.color = EnumDyeColor.LIGHT_GRAY;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_CYAN) {
            this.color = EnumDyeColor.CYAN;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_PURPLE) {
            this.color = EnumDyeColor.PURPLE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_BLUE) {
            this.color = EnumDyeColor.BLUE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_BROWN) {
            this.color = EnumDyeColor.BROWN;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_GREEN) {
            this.color = EnumDyeColor.GREEN;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_BASE_RED) {
            this.color = EnumDyeColor.RED;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_BLACK) {
            this.color = EnumDyeColor.BLACK;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_WHITE) {
            this.color = EnumDyeColor.WHITE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_ORANGE) {
            this.color = EnumDyeColor.ORANGE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_MAGENTA) {
            this.color = EnumDyeColor.MAGENTA;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_LIGHTBLUE) {
            this.color = EnumDyeColor.LIGHT_BLUE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_YELLOW) {
            this.color = EnumDyeColor.YELLOW;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_LIME) {
            this.color = EnumDyeColor.LIME;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_PINK) {
            this.color = EnumDyeColor.PINK;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_GRAY) {
            this.color = EnumDyeColor.GRAY;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_SILVER) {
            this.color = EnumDyeColor.LIGHT_GRAY;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_CYAN) {
            this.color = EnumDyeColor.CYAN;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_PURPLE) {
            this.color = EnumDyeColor.PURPLE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_BLUE) {
            this.color = EnumDyeColor.BLUE;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_BROWN) {
            this.color = EnumDyeColor.BROWN;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_GREEN) {
            this.color = EnumDyeColor.GREEN;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_RED) {
            this.color = EnumDyeColor.RED;
        } else if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == CasinoKeeper.CARDTABLE_WIDE_BLACK) {
            this.color = EnumDyeColor.BLACK;
        }
    }

    public boolean func_191420_l() {
        return false;
    }

    private String getScorename(int r) {
        switch (r) {
            case 0: {
                return "Ruby";
            }
            case 1: {
                return "Weiss";
            }
            case 2: {
                return "Blake";
            }
            case 3: {
                return "Yang";
            }
            case 4: {
                return "Jaune";
            }
            case 5: {
                return "Nora";
            }
            case 6: {
                return "Pyrrha";
            }
            case 7: {
                return "Ren";
            }
            case 8: {
                return "Sun";
            }
            case 9: {
                return "Neptune";
            }
            case 10: {
                return "Flynt";
            }
            case 11: {
                return "Neon";
            }
            case 12: {
                return "Cinder";
            }
            case 13: {
                return "Mercury";
            }
            case 14: {
                return "Emerald";
            }
            case 15: {
                return "Summer";
            }
            case 16: {
                return "Taiyang";
            }
            case 17: {
                return "Qrow";
            }
            case 18: {
                return "Raven";
            }
            case 19: {
                return "Winter";
            }
            case 20: {
                return "Coco";
            }
            case 21: {
                return "Fox";
            }
            case 22: {
                return "Velvet";
            }
            case 23: {
                return "Yatsuhashi";
            }
        }
        return "Zwei";
    }

    public void addScore(String name, int points) {
        int i;
        int pos = 18;
        for (i = 17; i >= 0; --i) {
            if (points <= this.scorePoints[i]) continue;
            pos = i;
        }
        if (pos == 17) {
            this.scorePoints[17] = points;
            this.scoreName[17] = name;
            this.scoreLast = 17;
        }
        if (pos < 17) {
            for (i = 16; i >= pos; --i) {
                this.scorePoints[i + 1] = this.scorePoints[i];
                this.scoreName[i + 1] = this.scoreName[i];
            }
            this.scorePoints[pos] = points;
            this.scoreName[pos] = name;
        }
        this.scoreLast = pos;
    }

    public void setupHighscore(Item item) {
        this.scoreLast = 18;
        if (this.getScoreToken() != item) {
            this.setScoreToken(item);
            Random rand = new Random();
            for (int i = 17; i >= 0; --i) {
                this.scorePoints[i] = (18 - i) * 5;
                this.scoreName[i] = this.getScorename(rand.nextInt(24));
            }
        }
        this.hasHighscore = this.scoreActive(item);
    }

    private boolean scoreActive(Item item) {
        if (item == CasinoKeeper.MODULE_PYRAMID) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_TRIPEAK) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_KLONDIKE) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_MEMORY) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_HALMA) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_MINESWEEPER) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_TETRIS) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_COLUMNS) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_MEANMINOS) {
            return true;
        }
        if (item == CasinoKeeper.MODULE_SNAKE) {
            return true;
        }
        return item == CasinoKeeper.MODULE_2048;
    }

    public boolean hasToken() {
        return this.bet_storage > 0;
    }

    public int getBetStorage() {
        return this.bet_storage;
    }

    public int getBetLow() {
        return this.bet_low;
    }

    public int getBetHigh() {
        return this.bet_high;
    }
}

