/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntity2048
extends TileEntityCasino {
    boolean placing;
    boolean active_timer;
    int timer;
    int direction;

    public TileEntity2048() {
        super(null, null);
    }

    public TileEntity2048(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
        this.gridI = new int[4][4];
        this.gridB = new boolean[4][4];
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_2048.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_2048.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_2048.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.gridI[x][y] = 0;
                this.gridB[x][y] = false;
            }
        }
        this.placing = false;
        this.gridI[0][0] = this.rand.nextInt(1) + 1;
        this.gridI[3][0] = this.rand.nextInt(1) + 1;
        this.gridI[0][3] = this.rand.nextInt(1) + 1;
        this.gridI[3][3] = this.rand.nextInt(1) + 1;
        this.active_timer = false;
        this.timer = 0;
        this.direction = 0;
    }

    @Override
    public void actionTouch(int action) {
        if (action == 0) {
            this.Move(1);
        }
        if (action == 1) {
            this.Move(2);
        }
        if (action == 2) {
            this.Move(3);
        }
        if (action == 3) {
            this.Move(4);
        }
    }

    @Override
    public void update() {
        if (this.active_timer) {
            this.timer += 6;
            if (this.timer == 48) {
                this.active_timer = false;
                this.timer = 0;
                this.Change();
                this.Move(this.direction);
                this.placing = true;
            }
        } else {
            if (this.placing) {
                this.Place();
                this.placing = false;
            }
            this.direction = 0;
        }
    }

    @Override
    public int getValue(int index) {
        if (index == 16) {
            return this.timer;
        }
        if (index == 17) {
            return this.direction;
        }
        return this.gridI[index % 4][index / 4];
    }

    @Override
    public boolean getFlag(int index) {
        if (index == 16) {
            return this.placing;
        }
        if (index == 17) {
            return this.active_timer;
        }
        return this.gridB[index % 4][index / 4];
    }

    private void Move(int s) {
        int y;
        int x;
        int x2;
        int y2;
        if (s == 1) {
            for (y2 = 1; y2 < 4; ++y2) {
                for (x2 = 0; x2 < 4; ++x2) {
                    if (this.gridI[x2][y2] == 0 || this.gridI[x2][y2 - 1] != 0 && this.gridI[x2][y2 - 1] != this.gridI[x2][y2]) continue;
                    this.gridB[x2][y2] = true;
                    this.active_timer = true;
                    this.direction = s;
                }
            }
        }
        if (s == 2) {
            for (y2 = 2; y2 > -1; --y2) {
                for (x2 = 3; x2 > -1; --x2) {
                    if (this.gridI[x2][y2] == 0 || this.gridI[x2][y2 + 1] != 0 && this.gridI[x2][y2 + 1] != this.gridI[x2][y2]) continue;
                    this.gridB[x2][y2] = true;
                    this.active_timer = true;
                    this.direction = s;
                }
            }
        }
        if (s == 3) {
            for (x = 1; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    if (this.gridI[x][y] == 0 || this.gridI[x - 1][y] != 0 && this.gridI[x - 1][y] != this.gridI[x][y]) continue;
                    this.gridB[x][y] = true;
                    this.active_timer = true;
                    this.direction = s;
                }
            }
        }
        if (s == 4) {
            for (x = 2; x > -1; --x) {
                for (y = 3; y > -1; --y) {
                    if (this.gridI[x][y] == 0 || this.gridI[x + 1][y] != 0 && this.gridI[x + 1][y] != this.gridI[x][y]) continue;
                    this.gridB[x][y] = true;
                    this.active_timer = true;
                    this.direction = s;
                }
            }
        }
    }

    private void Change() {
        int y;
        int x;
        int x2;
        int y2;
        if (this.direction == 1) {
            for (y2 = 1; y2 < 4; ++y2) {
                for (x2 = 0; x2 < 4; ++x2) {
                    if (!this.gridB[x2][y2]) continue;
                    if (this.gridI[x2][y2 - 1] == 0) {
                        this.gridI[x2][y2 - 1] = this.gridI[x2][y2];
                    } else {
                        int[] nArray = this.gridI[x2];
                        int n = y2 - 1;
                        nArray[n] = nArray[n] + 1;
                        this.Add_Points(this.gridI[x2][y2 - 1]);
                    }
                    this.gridI[x2][y2] = 0;
                }
            }
        }
        if (this.direction == 2) {
            for (y2 = 2; y2 > -1; --y2) {
                for (x2 = 3; x2 > -1; --x2) {
                    if (!this.gridB[x2][y2]) continue;
                    if (this.gridI[x2][y2 + 1] == 0) {
                        this.gridI[x2][y2 + 1] = this.gridI[x2][y2];
                    } else {
                        int[] nArray = this.gridI[x2];
                        int n = y2 + 1;
                        nArray[n] = nArray[n] + 1;
                        this.Add_Points(this.gridI[x2][y2 + 1]);
                    }
                    this.gridI[x2][y2] = 0;
                }
            }
        }
        if (this.direction == 3) {
            for (x = 1; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    if (!this.gridB[x][y]) continue;
                    if (this.gridI[x - 1][y] == 0) {
                        this.gridI[x - 1][y] = this.gridI[x][y];
                    } else {
                        int[] nArray = this.gridI[x - 1];
                        int n = y;
                        nArray[n] = nArray[n] + 1;
                        this.Add_Points(this.gridI[x - 1][y]);
                    }
                    this.gridI[x][y] = 0;
                }
            }
        }
        if (this.direction == 4) {
            for (x = 2; x > -1; --x) {
                for (y = 3; y > -1; --y) {
                    if (!this.gridB[x][y]) continue;
                    if (this.gridI[x + 1][y] == 0) {
                        this.gridI[x + 1][y] = this.gridI[x][y];
                    } else {
                        int[] nArray = this.gridI[x + 1];
                        int n = y;
                        nArray[n] = nArray[n] + 1;
                        this.Add_Points(this.gridI[x + 1][y]);
                    }
                    this.gridI[x][y] = 0;
                }
            }
        }
        for (y2 = 0; y2 < 4; ++y2) {
            for (x2 = 0; x2 < 4; ++x2) {
                this.gridB[x2][y2] = false;
            }
        }
    }

    private void Place() {
        for (int i = 0; i < 24; ++i) {
            int y;
            int x = this.rand.nextInt(4);
            if (this.gridI[x][y = this.rand.nextInt(4)] != 0) continue;
            this.gridI[x][y] = 1;
            break;
        }
        this.Check();
    }

    private void Check() {
        int y;
        int x;
        int x2;
        int y2;
        boolean b = false;
        for (y2 = 1; y2 < 4; ++y2) {
            for (x2 = 0; x2 < 4; ++x2) {
                if (this.gridI[x2][y2] == 0 || this.gridI[x2][y2 - 1] != 0 && this.gridI[x2][y2 - 1] != this.gridI[x2][y2]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (y2 = 2; y2 > -1; --y2) {
            for (x2 = 3; x2 > -1; --x2) {
                if (this.gridI[x2][y2] == 0 || this.gridI[x2][y2 + 1] != 0 && this.gridI[x2][y2 + 1] != this.gridI[x2][y2]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (x = 1; x < 4; ++x) {
            for (y = 0; y < 4; ++y) {
                if (this.gridI[x][y] == 0 || this.gridI[x - 1][y] != 0 && this.gridI[x - 1][y] != this.gridI[x][y]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        for (x = 2; x > -1; --x) {
            for (y = 3; y > -1; --y) {
                if (this.gridI[x][y] == 0 || this.gridI[x + 1][y] != 0 && this.gridI[x + 1][y] != this.gridI[x][y]) continue;
                b = true;
                break;
            }
            if (b) break;
        }
        if (!b) {
            this.turnstate = 4;
        }
    }

    private int Get_Direction(boolean horizontal, int x, int y) {
        if (this.direction == 0) {
            return 0;
        }
        if (horizontal && this.direction == 3 && this.gridB[x][y]) {
            return -this.timer;
        }
        if (horizontal && this.direction == 4 && this.gridB[x][y]) {
            return this.timer;
        }
        if (!horizontal && this.direction == 1 && this.gridB[x][y]) {
            return -this.timer;
        }
        if (!horizontal && this.direction == 2 && this.gridB[x][y]) {
            return this.timer;
        }
        return 0;
    }

    private void Add_Points(int i) {
        if (i == 1) {
            this.scorePoints += 2;
        }
        if (i == 2) {
            this.scorePoints += 4;
        }
        if (i == 3) {
            this.scorePoints += 8;
        }
        if (i == 4) {
            this.scorePoints += 16;
        }
        if (i == 5) {
            this.scorePoints += 32;
        }
        if (i == 6) {
            this.scorePoints += 64;
        }
        if (i == 7) {
            this.scorePoints += 128;
        }
        if (i == 8) {
            this.scorePoints += 256;
        }
        if (i == 9) {
            this.scorePoints += 512;
        }
        if (i == 10) {
            this.scorePoints += 1024;
        }
        if (i == 11) {
            this.scorePoints += 2048;
        }
        if (i == 12) {
            this.scorePoints += 4096;
        }
        if (i == 13) {
            this.scorePoints += 8192;
        }
        if (i == 14) {
            this.scorePoints += 16384;
        }
        if (i == 15) {
            this.scorePoints += 32768;
        }
        if (i == 16) {
            this.scorePoints += 65536;
        }
    }
}

