/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import mod.casinocraft.util.Card;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityBlackJack
extends TileEntityCasino {
    public List<Card> cards_player1 = new ArrayList<Card>();
    public List<Card> cards_player2 = new ArrayList<Card>();
    public List<Card> cards_dealer = new ArrayList<Card>();
    public int value_player1;
    public int value_player2;
    public int value_dealer;
    int split;

    public TileEntityBlackJack() {
        super(null, null);
    }

    public TileEntityBlackJack(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_BLACKJACK.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_BLACKJACK.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_BLACKJACK.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        this.cards_player1.clear();
        this.cards_player2.clear();
        this.cards_dealer.clear();
        this.value_player1 = 0;
        this.value_player2 = 0;
        this.value_dealer = 0;
        this.split = 0;
        this.cards_player1.add(new Card(this.rand.nextInt(13), this.rand.nextInt(4)));
        this.cards_player1.add(new Card(this.rand.nextInt(13), this.rand.nextInt(4)));
        this.cards_dealer.add(new Card(this.rand.nextInt(13), this.rand.nextInt(4)));
        this.cards_dealer.add(new Card(this.rand.nextInt(13), this.rand.nextInt(4)));
        this.cards_dealer.get((int)1).hidden = true;
        this.cards_player1.get(0).setShift(-32, 0, 8);
        this.cards_player1.get(1).setShift(-48, 0, 32);
        this.cards_dealer.get(0).setShift(0, -48, 8);
        this.cards_dealer.get(1).setShift(0, -48, 32);
        this.value_player1 = this.Add_Card(this.cards_player1, 0, 0, true);
        this.value_player2 = 0;
        this.value_dealer = this.Add_Card(this.cards_dealer, 0, 0, true);
        if (this.value_player1 == 21) {
            this.result();
            this.cards_dealer.get((int)1).hidden = false;
        }
    }

    @Override
    public void actionTouch(int action) {
        if (action == 0) {
            if (this.split < 2) {
                this.value_player1 = this.Add_Card(this.cards_player1, -48, 0, false);
                if (this.value_player1 > 21) {
                    if (this.split == 0) {
                        this.result();
                    } else {
                        this.split = 2;
                    }
                }
            } else {
                this.value_player2 = this.Add_Card(this.cards_player2, -48, 0, false);
                if (this.value_player2 > 21) {
                    if (this.value_player1 > 21) {
                        this.result();
                    } else {
                        this.turnstate = 3;
                        this.cards_dealer.get((int)1).hidden = false;
                    }
                }
            }
        }
        if (action == 1) {
            if (this.split == 1) {
                this.split = 2;
            } else {
                this.turnstate = 3;
                this.cards_dealer.get((int)1).hidden = false;
            }
        }
        if (action == 2) {
            this.split = 1;
            this.cards_player2.add(this.cards_player1.get(1));
            this.cards_player1.remove(1);
            this.cards_player1.add(new Card(this.rand.nextInt(13), this.rand.nextInt(4)));
            this.cards_player2.add(new Card(this.rand.nextInt(13), this.rand.nextInt(4)));
            this.cards_player2.get(0).setShift(-32, 0, 8);
            this.cards_player2.get(1).setShift(-48, 0, 32);
            this.cards_player1.get(1).setShift(-48, 0, 32);
            this.value_player1 = this.Add_Card(this.cards_player1, 0, 0, true);
            this.value_player2 = this.Add_Card(this.cards_player2, 0, 0, true);
        }
    }

    @Override
    public void update() {
        int i;
        if (this.cards_player1.size() > 0) {
            for (i = 0; i < this.cards_player1.size(); ++i) {
                this.cards_player1.get(i).update();
            }
        }
        if (this.cards_player2.size() > 0) {
            for (i = 0; i < this.cards_player2.size(); ++i) {
                this.cards_player2.get(i).update();
            }
        }
        if (this.cards_dealer.size() > 0) {
            for (i = 0; i < this.cards_dealer.size(); ++i) {
                this.cards_dealer.get(i).update();
            }
        }
        if (this.turnstate == 3 && this.cards_dealer.get((int)(this.cards_dealer.size() - 1)).shiftY >= -16) {
            if (this.value_dealer > 16 || this.value_dealer > this.value_player1 && this.value_dealer > this.value_player2) {
                this.result();
            } else {
                this.value_dealer = this.Add_Card(this.cards_dealer, 0, -48, false);
            }
        }
    }

    @Override
    public List<Card> getCardStack(int index) {
        if (index == 0) {
            return this.cards_player1;
        }
        if (index == 1) {
            return this.cards_player2;
        }
        if (index == 2) {
            return this.cards_dealer;
        }
        return null;
    }

    @Override
    public int getValue(int index) {
        if (index == 0) {
            return this.value_player1;
        }
        if (index == 1) {
            return this.value_player2;
        }
        if (index == 2) {
            return this.value_dealer;
        }
        return this.split;
    }

    @Override
    public boolean getFlag(int index) {
        return this.cards_player1.get((int)0).number == this.cards_player1.get((int)1).number;
    }

    private void result() {
        this.turnstate = 4;
        if (this.value_dealer > 21) {
            this.hand = "The House gone bust!";
            this.reward = 2;
        } else if (this.value_player1 > 21) {
            this.hand = "The Player gone bust!";
            this.reward = 0;
        } else if (this.value_player1 == this.value_dealer && this.cards_player1.size() > this.cards_dealer.size()) {
            this.hand = "The House wins!";
            this.reward = 0;
        } else if (this.value_player1 == this.value_dealer && this.cards_player1.size() == this.cards_dealer.size()) {
            this.hand = "DRAW";
            this.reward = 1;
        } else if (this.value_player1 == 21 && this.cards_player1.size() == 2) {
            this.hand = "BLACK JACK";
            this.reward = 3;
        } else if (this.value_player1 == this.value_dealer && this.cards_player1.size() < this.cards_dealer.size()) {
            this.hand = "The Player wins!";
            this.reward = 2;
        } else if (this.value_player1 > this.value_dealer) {
            this.hand = "The Player wins!";
            this.reward = 2;
        } else {
            this.hand = "The House wins!";
            this.reward = 0;
        }
        if (this.split > 0) {
            if (this.value_dealer > 21) {
                this.hand = this.hand + " / The House gone bust!";
                this.reward += 2;
            } else if (this.value_player2 > 21) {
                this.hand = this.hand + " / The Player gone bust!";
                this.reward += 0;
            } else if (this.value_player2 == this.value_dealer && this.cards_player2.size() > this.cards_dealer.size()) {
                this.hand = this.hand + " / The House wins!";
                this.reward += 0;
            } else if (this.value_player2 == this.value_dealer && this.cards_player2.size() == this.cards_dealer.size()) {
                this.hand = this.hand + " / DRAW";
                ++this.reward;
            } else if (this.value_player2 == 21 && this.cards_player2.size() == 2) {
                this.hand = this.hand + " / BLACK JACK";
                this.reward += 3;
            } else if (this.value_player2 == this.value_dealer && this.cards_player2.size() < this.cards_dealer.size()) {
                this.hand = this.hand + " / The Player wins!";
                this.reward += 2;
            } else if (this.value_player2 > this.value_dealer) {
                this.hand = this.hand + " / The Player wins!";
                this.reward += 2;
            } else {
                this.hand = this.hand + " / The House wins!";
                this.reward += 0;
            }
        }
    }

    private int Add_Card(List<Card> cards, int shiftX, int shiftY, boolean noCard) {
        int value = 0;
        if (!noCard) {
            cards.add(new Card(this.rand.nextInt(13), this.rand.nextInt(4), shiftX, shiftY));
        }
        int ace = 0;
        for (int i = 0; i < cards.size(); ++i) {
            if (cards.get((int)i).number == 0) {
                ++ace;
                continue;
            }
            if (cards.get((int)i).number <= 9) {
                value += cards.get((int)i).number + 1;
                continue;
            }
            value += 10;
        }
        if (ace > 0) {
            while (ace > 0) {
                value = value <= 10 ? (value += 11) : ++value;
                --ace;
            }
        }
        return value;
    }
}

