/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import mod.casinocraft.util.Dice;
import mod.shared.util.Vector2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityCraps
extends TileEntityCasino {
    Dice[] dice = new Dice[2];
    int result;
    int point;
    int comepoint;

    public TileEntityCraps() {
        super(null, null);
    }

    public TileEntityCraps(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
        this.gridI = new int[21][5];
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_CRAPS.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_CRAPS.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_CRAPS.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        this.hand = "Place your Bets..";
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 21; ++x) {
                this.gridI[x][y] = 0;
            }
        }
        this.selector = new Vector2(10, 2);
        this.result = -1;
        this.point = -1;
        this.comepoint = -1;
        this.dice[0] = new Dice(0, 1);
        this.dice[1] = new Dice(0, 1);
    }

    @Override
    public void actionTouch(int action) {
        if (action == -2) {
            if (this.selector.X > -1 && this.GridValid(this.selector)) {
                this.gridI[this.selector.X][this.selector.Y] = 1;
                this.selector.set(-1, -1);
            }
            this.Spin();
        }
        if (action == -1) {
            if (this.selector.X > -1 && this.GridValid(this.selector)) {
                this.gridI[this.selector.X][this.selector.Y] = 1;
                this.selector.set(-1, -1);
            }
        } else {
            this.selector = new Vector2(action % 21, action / 21);
        }
    }

    @Override
    public void update() {
        if (this.turnstate == 3) {
            for (int i = 0; i < 2; ++i) {
                if (this.dice[i].shiftX > 45) {
                    this.dice[i].Update(1, this.rand.nextInt(6));
                    continue;
                }
                if (this.dice[i].shiftX <= 0) continue;
                this.dice[i].shiftX = 0;
                this.dice[i].shiftY = 0;
            }
        }
        if (this.turnstate == 4) {
            this.selector = new Vector2(-1, -1);
        }
    }

    @Override
    public int getValue(int index) {
        if (index == -1) {
            return this.result;
        }
        if (index == -2) {
            return this.point;
        }
        if (index == -3) {
            return this.comepoint;
        }
        if (index == -4) {
            return this.reward;
        }
        return this.gridI[index % 21][index / 21];
    }

    @Override
    public Dice getDice(int index) {
        return this.dice[index];
    }

    @Override
    public Vector2 getVector(int index) {
        return this.selector;
    }

    @Override
    public boolean getFlag(int index) {
        return false;
    }

    @Override
    public String getString(int index) {
        return this.hand;
    }

    private boolean GridValid(Vector2 v) {
        if (v == new Vector2(1, 0)) {
            return false;
        }
        if (v == new Vector2(19, 0)) {
            return false;
        }
        if (v == new Vector2(1, 4)) {
            return false;
        }
        if (v == new Vector2(19, 4)) {
            return false;
        }
        if (v.Y >= 1 && v.Y <= 3) {
            return v.X % 3 != 1;
        }
        return true;
    }

    private void Spin() {
        if (this.turnstate == 2) {
            this.dice[0].Set_Up(200 + this.rand.nextInt(50), 50 + this.rand.nextInt(200), this.rand.nextInt(2) == 0);
            this.dice[1].Set_Up(50 + this.rand.nextInt(200), 200 + this.rand.nextInt(50), this.rand.nextInt(2) == 0);
            if (this.selector.X > -1) {
                this.gridI[this.selector.X][this.selector.Y] = 1;
                this.selector = new Vector2(-1, -1);
            }
            this.turnstate = 3;
        } else if (this.turnstate == 3 && this.dice[0].shiftX == 0 && this.dice[1].shiftX == 0) {
            this.Result();
        }
    }

    private void Result() {
        this.dice[0].Reset();
        this.dice[1].Reset();
        boolean hasCome = false;
        for (int i = 0; i < 5; ++i) {
            if (this.gridI[0][i] == 1) {
                hasCome = true;
            }
            if (this.gridI[20][i] != 1) continue;
            hasCome = true;
        }
        if (this.point == -1) {
            this.point = this.dice[0].number + 1 + this.dice[1].number + 1;
            this.result = this.dice[0].number + 1 + this.dice[1].number + 1;
            if (this.result == 7 || this.result == 11) {
                this.Result_Pass(true);
                this.Result_DontPass(false);
                this.hand = "Natura Roll!";
                this.turnstate = 4;
            } else if (this.result == 2 || this.result == 3 || this.result == 12) {
                this.Result_Pass(false);
                this.Result_DontPass(true);
                this.hand = "Crab...";
                this.turnstate = 4;
            } else {
                this.hand = "Roll again...";
                this.turnstate = 2;
            }
        } else {
            this.result = this.dice[0].number + 1 + this.dice[1].number + 1;
            this.Result_SingleOdds();
            this.turnstate = 2;
            if (hasCome) {
                if (this.comepoint == -1) {
                    this.comepoint = this.result;
                } else if (this.result == this.comepoint) {
                    this.Result_Come(true);
                    this.Result_DontCome(false);
                } else if (this.result == 7) {
                    this.Result_Come(false);
                    this.Result_DontCome(true);
                }
            }
            if (this.result == 7) {
                this.Result_Pass(false);
                this.Result_PassOdds(false);
                this.Result_DontPass(true);
                this.Result_DontPassOdds(true);
                this.hand = "SEVEN";
                this.turnstate = 4;
            } else if (this.result == this.point) {
                this.Result_Pass(false);
                this.Result_PassOdds(false);
                this.Result_DontPass(true);
                this.Result_DontPassOdds(true);
                this.hand = "POINT";
                this.turnstate = 4;
            }
        }
    }

    private void Result_Come(boolean won) {
        if (this.gridI[0][0] == 1) {
            if (won) {
                this.gridI[0][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[0][0] = 3;
            }
        }
        if (this.gridI[0][1] == 1) {
            if (won) {
                this.gridI[0][1] = 2;
                this.reward += 2;
            } else {
                this.gridI[0][1] = 3;
            }
        }
        if (this.gridI[0][2] == 1) {
            if (won) {
                this.gridI[0][2] = 2;
                this.reward += 2;
            } else {
                this.gridI[0][2] = 3;
            }
        }
        if (this.gridI[0][3] == 1) {
            if (won) {
                this.gridI[0][3] = 2;
                this.reward += 2;
            } else {
                this.gridI[0][3] = 3;
            }
        }
        if (this.gridI[0][4] == 1) {
            if (won) {
                this.gridI[0][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[0][4] = 3;
            }
        }
    }

    private void Result_DontCome(boolean won) {
        if (this.gridI[20][0] == 1) {
            if (won) {
                this.gridI[20][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[20][0] = 3;
            }
        }
        if (this.gridI[20][1] == 1) {
            if (won) {
                this.gridI[20][1] = 2;
                this.reward += 2;
            } else {
                this.gridI[20][1] = 3;
            }
        }
        if (this.gridI[20][2] == 1) {
            if (won) {
                this.gridI[20][2] = 2;
                this.reward += 2;
            } else {
                this.gridI[20][2] = 3;
            }
        }
        if (this.gridI[20][3] == 1) {
            if (won) {
                this.gridI[20][3] = 2;
                this.reward += 2;
            } else {
                this.gridI[20][3] = 3;
            }
        }
        if (this.gridI[20][4] == 1) {
            if (won) {
                this.gridI[20][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[20][4] = 3;
            }
        }
    }

    private void Result_Pass(boolean won) {
        if (this.gridI[2][0] == 1) {
            if (won) {
                this.gridI[2][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[2][0] = 3;
            }
        }
        if (this.gridI[3][0] == 1) {
            if (won) {
                this.gridI[3][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[3][0] = 3;
            }
        }
        if (this.gridI[4][0] == 1) {
            if (won) {
                this.gridI[4][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[4][0] = 3;
            }
        }
        if (this.gridI[5][0] == 1) {
            if (won) {
                this.gridI[5][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[5][0] = 3;
            }
        }
        if (this.gridI[6][0] == 1) {
            if (won) {
                this.gridI[6][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[6][0] = 3;
            }
        }
        if (this.gridI[7][0] == 1) {
            if (won) {
                this.gridI[7][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[7][0] = 3;
            }
        }
        if (this.gridI[8][0] == 1) {
            if (won) {
                this.gridI[8][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[8][0] = 3;
            }
        }
        if (this.gridI[9][0] == 1) {
            if (won) {
                this.gridI[9][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[9][0] = 3;
            }
        }
        if (this.gridI[10][0] == 1) {
            if (won) {
                this.gridI[10][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[10][0] = 3;
            }
        }
        if (this.gridI[11][0] == 1) {
            if (won) {
                this.gridI[11][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[11][0] = 3;
            }
        }
        if (this.gridI[12][0] == 1) {
            if (won) {
                this.gridI[12][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[12][0] = 3;
            }
        }
        if (this.gridI[13][0] == 1) {
            if (won) {
                this.gridI[13][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[13][0] = 3;
            }
        }
        if (this.gridI[14][0] == 1) {
            if (won) {
                this.gridI[14][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[14][0] = 3;
            }
        }
        if (this.gridI[15][0] == 1) {
            if (won) {
                this.gridI[15][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[15][0] = 3;
            }
        }
        if (this.gridI[16][0] == 1) {
            if (won) {
                this.gridI[16][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[16][0] = 3;
            }
        }
        if (this.gridI[17][0] == 1) {
            if (won) {
                this.gridI[17][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[17][0] = 3;
            }
        }
        if (this.gridI[18][0] == 1) {
            if (won) {
                this.gridI[18][0] = 2;
                this.reward += 2;
            } else {
                this.gridI[18][0] = 3;
            }
        }
    }

    private void Result_DontPass(boolean won) {
        if (this.gridI[2][4] == 1) {
            if (won) {
                this.gridI[2][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[2][4] = 3;
            }
        }
        if (this.gridI[3][4] == 1) {
            if (won) {
                this.gridI[3][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[3][4] = 3;
            }
        }
        if (this.gridI[4][4] == 1) {
            if (won) {
                this.gridI[4][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[4][4] = 3;
            }
        }
        if (this.gridI[5][4] == 1) {
            if (won) {
                this.gridI[5][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[5][4] = 3;
            }
        }
        if (this.gridI[6][4] == 1) {
            if (won) {
                this.gridI[6][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[6][4] = 3;
            }
        }
        if (this.gridI[7][4] == 1) {
            if (won) {
                this.gridI[7][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[7][4] = 3;
            }
        }
        if (this.gridI[8][4] == 1) {
            if (won) {
                this.gridI[8][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[8][4] = 3;
            }
        }
        if (this.gridI[9][4] == 1) {
            if (won) {
                this.gridI[9][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[9][4] = 3;
            }
        }
        if (this.gridI[10][4] == 1) {
            if (won) {
                this.gridI[10][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[10][4] = 3;
            }
        }
        if (this.gridI[11][4] == 1) {
            if (won) {
                this.gridI[11][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[11][4] = 3;
            }
        }
        if (this.gridI[12][4] == 1) {
            if (won) {
                this.gridI[12][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[12][4] = 3;
            }
        }
        if (this.gridI[13][4] == 1) {
            if (won) {
                this.gridI[13][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[13][4] = 3;
            }
        }
        if (this.gridI[14][4] == 1) {
            if (won) {
                this.gridI[14][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[14][4] = 3;
            }
        }
        if (this.gridI[15][4] == 1) {
            if (won) {
                this.gridI[15][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[15][4] = 3;
            }
        }
        if (this.gridI[16][4] == 1) {
            if (won) {
                this.gridI[16][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[16][4] = 3;
            }
        }
        if (this.gridI[17][4] == 1) {
            if (won) {
                this.gridI[17][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[17][4] = 3;
            }
        }
        if (this.gridI[18][4] == 1) {
            if (won) {
                this.gridI[18][4] = 2;
                this.reward += 2;
            } else {
                this.gridI[18][4] = 3;
            }
        }
    }

    private void Result_PassOdds(boolean won) {
        if (this.gridI[2][1] == 1) {
            if (won) {
                if (this.result == 4) {
                    this.gridI[2][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[2][1] = 3;
                }
            } else {
                this.gridI[2][1] = 3;
            }
        }
        if (this.gridI[3][1] == 1) {
            if (won) {
                if (this.result == 4) {
                    this.gridI[3][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[3][1] = 3;
                }
            } else {
                this.gridI[3][1] = 3;
            }
        }
        if (this.gridI[5][1] == 1) {
            if (won) {
                if (this.result == 5) {
                    this.gridI[5][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[5][1] = 3;
                }
            } else {
                this.gridI[5][1] = 3;
            }
        }
        if (this.gridI[6][1] == 1) {
            if (won) {
                if (this.result == 5) {
                    this.gridI[6][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[6][1] = 3;
                }
            } else {
                this.gridI[6][1] = 3;
            }
        }
        if (this.gridI[8][1] == 1) {
            if (won) {
                if (this.result == 6) {
                    this.gridI[8][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[8][1] = 3;
                }
            } else {
                this.gridI[8][1] = 3;
            }
        }
        if (this.gridI[9][1] == 1) {
            if (won) {
                if (this.result == 6) {
                    this.gridI[9][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[9][1] = 3;
                }
            } else {
                this.gridI[9][1] = 3;
            }
        }
        if (this.gridI[11][1] == 1) {
            if (won) {
                if (this.result == 8) {
                    this.gridI[11][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[11][1] = 3;
                }
            } else {
                this.gridI[11][1] = 3;
            }
        }
        if (this.gridI[12][1] == 1) {
            if (won) {
                if (this.result == 8) {
                    this.gridI[12][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[12][1] = 3;
                }
            } else {
                this.gridI[12][1] = 3;
            }
        }
        if (this.gridI[14][1] == 1) {
            if (won) {
                if (this.result == 9) {
                    this.gridI[14][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[14][1] = 3;
                }
            } else {
                this.gridI[14][1] = 3;
            }
        }
        if (this.gridI[15][1] == 1) {
            if (won) {
                if (this.result == 9) {
                    this.gridI[15][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[15][1] = 3;
                }
            } else {
                this.gridI[15][1] = 3;
            }
        }
        if (this.gridI[17][1] == 1) {
            if (won) {
                if (this.result == 10) {
                    this.gridI[17][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[17][1] = 3;
                }
            } else {
                this.gridI[17][1] = 3;
            }
        }
        if (this.gridI[18][1] == 1) {
            if (won) {
                if (this.result == 10) {
                    this.gridI[18][1] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[18][1] = 3;
                }
            } else {
                this.gridI[18][1] = 3;
            }
        }
    }

    private void Result_DontPassOdds(boolean won) {
        if (this.gridI[2][3] == 1) {
            if (won) {
                if (this.result == 4) {
                    this.gridI[2][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[2][3] = 3;
                }
            } else {
                this.gridI[2][3] = 3;
            }
        }
        if (this.gridI[3][3] == 1) {
            if (won) {
                if (this.result == 4) {
                    this.gridI[3][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[3][3] = 3;
                }
            } else {
                this.gridI[3][3] = 3;
            }
        }
        if (this.gridI[5][3] == 1) {
            if (won) {
                if (this.result == 5) {
                    this.gridI[5][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[5][3] = 3;
                }
            } else {
                this.gridI[5][3] = 3;
            }
        }
        if (this.gridI[6][3] == 1) {
            if (won) {
                if (this.result == 5) {
                    this.gridI[6][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[6][3] = 3;
                }
            } else {
                this.gridI[6][3] = 3;
            }
        }
        if (this.gridI[8][3] == 1) {
            if (won) {
                if (this.result == 6) {
                    this.gridI[8][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[8][3] = 3;
                }
            } else {
                this.gridI[8][3] = 3;
            }
        }
        if (this.gridI[9][3] == 1) {
            if (won) {
                if (this.result == 6) {
                    this.gridI[9][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[9][3] = 3;
                }
            } else {
                this.gridI[9][3] = 3;
            }
        }
        if (this.gridI[11][3] == 1) {
            if (won) {
                if (this.result == 8) {
                    this.gridI[11][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[11][3] = 3;
                }
            } else {
                this.gridI[11][3] = 3;
            }
        }
        if (this.gridI[12][3] == 1) {
            if (won) {
                if (this.result == 8) {
                    this.gridI[12][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[12][3] = 3;
                }
            } else {
                this.gridI[12][3] = 3;
            }
        }
        if (this.gridI[14][3] == 1) {
            if (won) {
                if (this.result == 9) {
                    this.gridI[14][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[14][3] = 3;
                }
            } else {
                this.gridI[14][3] = 3;
            }
        }
        if (this.gridI[15][3] == 1) {
            if (won) {
                if (this.result == 9) {
                    this.gridI[15][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[15][3] = 3;
                }
            } else {
                this.gridI[15][3] = 3;
            }
        }
        if (this.gridI[17][3] == 1) {
            if (won) {
                if (this.result == 10) {
                    this.gridI[17][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[17][3] = 3;
                }
            } else {
                this.gridI[17][3] = 3;
            }
        }
        if (this.gridI[18][3] == 1) {
            if (won) {
                if (this.result == 10) {
                    this.gridI[18][3] = 2;
                    this.reward += 2;
                } else {
                    this.gridI[18][3] = 3;
                }
            } else {
                this.gridI[18][3] = 3;
            }
        }
    }

    private void Result_SingleOdds() {
        if (this.gridI[2][2] == 1) {
            if (this.result == 4) {
                this.gridI[2][2] = 2;
                this.reward += 10;
            } else {
                this.gridI[2][2] = 3;
            }
        }
        if (this.gridI[3][2] == 1) {
            if (this.result == 4) {
                this.gridI[3][2] = 2;
                this.reward += 10;
            } else {
                this.gridI[3][2] = 3;
            }
        }
        if (this.gridI[5][2] == 1) {
            if (this.result == 5) {
                this.gridI[5][2] = 2;
                this.reward += 8;
            } else {
                this.gridI[5][2] = 3;
            }
        }
        if (this.gridI[6][2] == 1) {
            if (this.result == 5) {
                this.gridI[6][2] = 2;
                this.reward += 8;
            } else {
                this.gridI[6][2] = 3;
            }
        }
        if (this.gridI[8][2] == 1) {
            if (this.result == 6) {
                this.gridI[8][2] = 2;
                this.reward += 6;
            } else {
                this.gridI[8][2] = 3;
            }
        }
        if (this.gridI[9][2] == 1) {
            if (this.result == 6) {
                this.gridI[9][2] = 2;
                this.reward += 6;
            } else {
                this.gridI[9][2] = 3;
            }
        }
        if (this.gridI[11][2] == 1) {
            if (this.result == 8) {
                this.gridI[11][2] = 2;
                this.reward += 6;
            } else {
                this.gridI[11][2] = 3;
            }
        }
        if (this.gridI[12][2] == 1) {
            if (this.result == 8) {
                this.gridI[12][2] = 2;
                this.reward += 6;
            } else {
                this.gridI[12][2] = 3;
            }
        }
        if (this.gridI[14][2] == 1) {
            if (this.result == 9) {
                this.gridI[14][2] = 2;
                this.reward += 8;
            } else {
                this.gridI[14][2] = 3;
            }
        }
        if (this.gridI[15][2] == 1) {
            if (this.result == 9) {
                this.gridI[15][2] = 2;
                this.reward += 8;
            } else {
                this.gridI[15][2] = 3;
            }
        }
        if (this.gridI[17][2] == 1) {
            if (this.result == 10) {
                this.gridI[17][2] = 2;
                this.reward += 10;
            } else {
                this.gridI[17][2] = 3;
            }
        }
        if (this.gridI[18][2] == 1) {
            if (this.result == 10) {
                this.gridI[18][2] = 2;
                this.reward += 10;
            } else {
                this.gridI[18][2] = 3;
            }
        }
    }
}

